/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.zipow.videobox.confapp.CmmAttentionTrackMgr;
import com.zipow.videobox.confapp.CmmAudioStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.confapp.qa.ZoomQABuddy;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.ZMConfUtil;
import com.zipow.videobox.view.ConfChatAttendeeItem;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class PAttendeeItem {
    public String name;
    public String email;
    public long nodeID;
    public boolean isAttentionMode;
    public boolean isRaisedHand;
    public long audioType = 2L;
    public boolean audioOn;
    public boolean isShowGuest;

    public PAttendeeItem(CmmUser user) {
        if (user != null && user.isViewOnlyUserCanTalk()) {
            this.name = user.getScreenName();
            this.email = user.getEmail();
            this.nodeID = user.getNodeId();
            this.isShowGuest = ConfLocalHelper.isGuest(user) && !ConfLocalHelper.isGuestForMyself();
            ZoomQABuddy buddy = ZMConfUtil.getZoomQABuddyByNodeId(this.nodeID);
            if (buddy != null) {
                this.isRaisedHand = ConfLocalHelper.isHaisedHand(buddy.getJID());
            }
            this.isAttentionMode = user.isInAttentionMode();
            this.updateAudio(this.nodeID);
        }
    }

    public ConfChatAttendeeItem getConfChatAttendeeItem() {
        ZoomQABuddy buddy = ZMConfUtil.getZoomQABuddyByNodeId(this.nodeID);
        if (buddy != null) {
            return new ConfChatAttendeeItem(buddy);
        }
        return null;
    }

    public View getView(Context context, View convertView) {
        if (convertView == null || !"webinar".equals(convertView.getTag())) {
            convertView = View.inflate((Context)context, (int)R.layout.zm_qa_webinar_attendee_email_item, null);
            convertView.setTag((Object)"webinar");
        }
        this.bindView(context, convertView);
        return convertView;
    }

    private void bindView(Context context, View convertView) {
        boolean isShare;
        ZoomQABuddy buddy;
        if (convertView == null) {
            return;
        }
        TextView txtName = (TextView)convertView.findViewById(R.id.txtName);
        TextView txtRole = (TextView)convertView.findViewById(R.id.txtRole);
        TextView txtEmail = (TextView)convertView.findViewById(R.id.txtEmail);
        ImageView imgAudio = (ImageView)convertView.findViewById(R.id.imgAudio);
        ImageView imgRaiseHand = (ImageView)convertView.findViewById(R.id.imgRaiseHand);
        ImageView imgAttention = (ImageView)convertView.findViewById(R.id.imgAttention);
        txtName.setText((CharSequence)this.name);
        txtRole.setVisibility(8);
        convertView.setBackgroundResource(this.isShowGuest ? R.drawable.zm_list_selector_guest : R.color.zm_transparent);
        if (StringUtil.isEmptyOrNull((String)this.email) && (buddy = ZMConfUtil.getZoomQABuddyByNodeId(this.nodeID)) != null) {
            this.email = buddy.getEmail();
        }
        txtEmail.setText((CharSequence)this.email);
        txtEmail.setVisibility(StringUtil.isEmptyOrNull((String)this.email) ? 8 : 0);
        imgRaiseHand.setVisibility(this.isRaisedHand ? 0 : 8);
        CmmAttentionTrackMgr mgr = ConfMgr.getInstance().getAttentionTrackAPI();
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        boolean bl = isShare = shareMgr != null && (shareMgr.getShareStatus() == 3 || shareMgr.getShareStatus() == 2);
        if (isShare && mgr != null && mgr.isConfAttentionTrackEnabled()) {
            imgAttention.setVisibility(this.isAttentionMode ? 4 : 0);
        } else {
            imgAttention.setVisibility(8);
        }
        if (this.audioType != 2L) {
            imgAudio.setVisibility(0);
            imgAudio.setContentDescription((CharSequence)context.getString(this.audioOn ? R.string.zm_description_plist_status_audio_on : R.string.zm_description_plist_status_audio_off));
            imgAudio.setImageResource(ZMConfUtil.getAudioImageResId(convertView.isInEditMode(), this.audioOn, this.audioType, this.nodeID));
            Drawable drawable2 = imgAudio.getDrawable();
            if (drawable2 instanceof AnimationDrawable) {
                ((AnimationDrawable)drawable2).start();
            }
        } else {
            imgAudio.setVisibility(8);
        }
    }

    protected void updateAudio(long nodeId) {
        CmmAudioStatus audioStatus = ZMConfUtil.getCmmAudioStatus(nodeId);
        if (audioStatus != null) {
            this.audioOn = !audioStatus.getIsMuted();
            this.audioType = audioStatus.getAudiotype();
        }
    }
}

