/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import us.zoom.androidlib.app.ZMTipFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMTip;
import us.zoom.videomeetings.R;

public class NormalMessageTip
extends ZMTipFragment {
    public static final int DEFAULT_TIP_SHOW_DURATION = 3000;

    public static void show(Context context, FragmentManager fragmentMgr, String tag, int titleId, int messageId) {
        String title = null;
        String message = null;
        if (titleId > -1) {
            title = context.getString(titleId);
        }
        if (messageId > -1) {
            message = context.getString(messageId);
        }
        NormalMessageTip.show(fragmentMgr, tag, title, message, 0, 0);
    }

    public static void show(Context context, FragmentManager fragmentMgr, String tag, int titleId, int messageId, int anchor, int arrowDirection) {
        String title = null;
        String message = null;
        if (titleId > -1) {
            title = context.getString(titleId);
        }
        if (messageId > -1) {
            message = context.getString(messageId);
        }
        NormalMessageTip.show(fragmentMgr, tag, title, message, 0, anchor, arrowDirection, 0L);
    }

    public static void show(Context context, FragmentManager fragmentMgr, String tag, int titleId, int messageId, long time) {
        String title = null;
        String message = null;
        if (titleId > -1) {
            title = context.getString(titleId);
        }
        if (messageId > -1) {
            message = context.getString(messageId);
        }
        NormalMessageTip.show(fragmentMgr, tag, title, message, 0, 0, 0, time);
    }

    public static void show(FragmentManager fragmentMgr, String tag, String title, String message) {
        NormalMessageTip.show(fragmentMgr, tag, title, message, 0, 0);
    }

    public static void show(FragmentManager fragmentMgr, String tag, String title, String message, int anchor, int arrowDirection) {
        NormalMessageTip.show(fragmentMgr, tag, title, message, 0, anchor, arrowDirection, 0L);
    }

    public static void show(FragmentManager fragmentMgr, String tag, String title, String message, long time) {
        NormalMessageTip.show(fragmentMgr, tag, title, message, 0, 0, 0, time);
    }

    public static void show(FragmentManager fragmentMgr, String tag, String title, String message, int anchor, int arrowDirection, boolean autoFocus) {
        Bundle args = new Bundle();
        args.putString("title", title);
        args.putString("message", message);
        args.putInt("icon", 0);
        args.putInt("anchor", anchor);
        args.putInt("arrowDirection", arrowDirection);
        args.putBoolean("autoFocus", autoFocus);
        NormalMessageTip tip = new NormalMessageTip();
        tip.setArguments(args);
        tip.show(fragmentMgr, tag, 0L);
    }

    public static void show(FragmentManager fragmentMgr, String tag, String title, String message, int iconRes, int anchor, int arrowDirection, long time) {
        Bundle args = new Bundle();
        args.putString("title", title);
        args.putString("message", message);
        args.putInt("icon", iconRes);
        args.putInt("anchor", anchor);
        args.putInt("arrowDirection", arrowDirection);
        NormalMessageTip tip = new NormalMessageTip();
        tip.setArguments(args);
        tip.show(fragmentMgr, tag, time);
    }

    public static boolean hasTip(FragmentManager fragmentMgr, String tag) {
        NormalMessageTip tip = (NormalMessageTip)fragmentMgr.findFragmentByTag(tag);
        return tip != null;
    }

    public static boolean dismiss(FragmentManager fragmentMgr, String tag) {
        NormalMessageTip tip = (NormalMessageTip)fragmentMgr.findFragmentByTag(tag);
        if (tip != null) {
            tip.dismiss();
            return true;
        }
        return false;
    }

    public ZMTip onCreateTip(Context context, LayoutInflater layoutInflater, Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        String title = args.getString("title");
        String message = args.getString("message");
        int icon = args.getInt("icon");
        int anchor = args.getInt("anchor");
        int arrowDirection = args.getInt("arrowDirection");
        this.mAutoFocus = args.getBoolean("autoFocus", true);
        View view = layoutInflater.inflate(R.layout.zm_normal_message_tip, null);
        TextView txtTitle = (TextView)view.findViewById(R.id.txtTitle);
        TextView txtMessage = (TextView)view.findViewById(R.id.txtMessage);
        ImageView imgIcon = (ImageView)view.findViewById(R.id.imgIcon);
        txtTitle.setFocusable(false);
        txtMessage.setFocusable(false);
        if (StringUtil.isEmptyOrNull((String)title)) {
            txtTitle.setVisibility(8);
        } else {
            txtTitle.setText((CharSequence)title);
        }
        txtMessage.setText((CharSequence)message);
        if (icon > 0) {
            imgIcon.setImageResource(icon);
        } else {
            imgIcon.setVisibility(8);
        }
        View viewAnchor = this.getActivity().findViewById(anchor);
        ZMTip tip = new ZMTip(context);
        tip.addView(view);
        view.setFocusable(false);
        tip.setAnchor(viewAnchor, arrowDirection);
        tip.setFocusable(false);
        tip.setBackgroundColor(context.getResources().getColor(R.color.zm_message_tip_background));
        tip.setBorderColor(context.getResources().getColor(R.color.zm_message_tip_border));
        tip.setShadow(4.0f, 0, 0, context.getResources().getColor(R.color.zm_message_tip_shadow));
        return tip;
    }
}

