/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import us.zoom.androidlib.app.ZMTipFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMTip;
import us.zoom.videomeetings.R;

public class NormalMessageButtonTip
extends ZMTipFragment
implements View.OnClickListener {
    private TextView mTxtButton;

    public static void show(FragmentManager fragmentMgr, String tag, String message, String button) {
        NormalMessageButtonTip.show(fragmentMgr, tag, "", message, button, 0L);
    }

    public static void show(FragmentManager fragmentMgr, String tag, String message, String button, long time) {
        NormalMessageButtonTip.show(fragmentMgr, tag, "", message, button, time);
    }

    public static void show(FragmentManager fragmentMgr, String tag, String title, String message, String button) {
        NormalMessageButtonTip.show(fragmentMgr, tag, title, message, button, 0L);
    }

    public static void show(FragmentManager fragmentMgr, String tag, String title, String message, String button, long time) {
        NormalMessageButtonTip.show(fragmentMgr, tag, -1, 0, title, message, button, 0, 0, time);
    }

    public static void show(FragmentManager fragmentMgr, String tag, int gravity, int margin, String message, String button) {
        NormalMessageButtonTip.show(fragmentMgr, tag, gravity, margin, "", message, button, 0L);
    }

    public static void show(FragmentManager fragmentMgr, String tag, int gravity, int padding, String title, String message, String button) {
        NormalMessageButtonTip.show(fragmentMgr, tag, gravity, padding, title, message, button, 0L);
    }

    public static void show(FragmentManager fragmentMgr, String tag, int gravity, int padding, String title, String message, String button, long time) {
        NormalMessageButtonTip.show(fragmentMgr, tag, gravity, padding, title, message, button, 0, 0, time);
    }

    public static void show(FragmentManager fragmentMgr, String tag, String title, String message, String button, int anchor, int arrowDirection) {
        NormalMessageButtonTip.show(fragmentMgr, tag, -1, 0, title, message, button, anchor, arrowDirection, 0L);
    }

    public static void show(FragmentManager fragmentMgr, String tag, int gravity, int padding, String title, String message, String button, int anchor, int arrowDirection, long time) {
        Bundle args = new Bundle();
        args.putString("title", title);
        args.putString("message", message);
        args.putString("button", button);
        args.putInt("anchor", anchor);
        args.putInt("arrowDirection", arrowDirection);
        args.putInt("gravity", gravity);
        args.putInt("padding", padding);
        NormalMessageButtonTip tip = new NormalMessageButtonTip();
        tip.setArguments(args);
        tip.show(fragmentMgr, tag, time);
    }

    public static boolean hasTip(FragmentManager fragmentMgr, String tag) {
        Fragment tip = fragmentMgr.findFragmentByTag(tag);
        return tip != null && tip instanceof NormalMessageButtonTip;
    }

    public static boolean dismiss(FragmentManager fragmentMgr, String tag) {
        Fragment tip = fragmentMgr.findFragmentByTag(tag);
        if (tip != null && tip instanceof NormalMessageButtonTip) {
            ((NormalMessageButtonTip)tip).dismiss();
            return true;
        }
        return false;
    }

    public ZMTip onCreateTip(Context context, LayoutInflater layoutInflater, Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        String title = args.getString("title");
        String message = args.getString("message");
        String button = args.getString("button");
        int anchor = args.getInt("anchor");
        int arrowDirection = args.getInt("arrowDirection");
        int gravity = args.getInt("gravity", -1);
        int padding = args.getInt("padding", 0);
        View view = layoutInflater.inflate(R.layout.zm_normal_message_button_tip, null);
        TextView txtTitle = (TextView)view.findViewById(R.id.txtTitle);
        TextView txtMessage = (TextView)view.findViewById(R.id.txtMessage);
        this.mTxtButton = (TextView)view.findViewById(R.id.txtButton);
        if (this.mTxtButton != null) {
            this.mTxtButton.setOnClickListener((View.OnClickListener)this);
        }
        txtTitle.setFocusable(false);
        txtMessage.setFocusable(false);
        if (StringUtil.isEmptyOrNull((String)title)) {
            txtTitle.setVisibility(8);
        } else {
            txtTitle.setText((CharSequence)title);
        }
        txtMessage.setText((CharSequence)message);
        if (StringUtil.isEmptyOrNull((String)button)) {
            this.mTxtButton.setVisibility(8);
        } else {
            this.mTxtButton.setText((CharSequence)button);
        }
        View viewAnchor = this.getActivity().findViewById(anchor);
        ZMTip tip = new ZMTip(context);
        tip.setLayoutGravity(gravity, padding);
        tip.addView(view);
        tip.setAnchor(viewAnchor, arrowDirection);
        tip.setBackgroundColor(context.getResources().getColor(R.color.zm_message_tip_background));
        tip.setBorderColor(context.getResources().getColor(R.color.zm_message_tip_border));
        tip.setShadow(4.0f, 0, 0, context.getResources().getColor(R.color.zm_message_tip_shadow));
        return tip;
    }

    public void onClick(View v) {
        if (v == this.mTxtButton) {
            this.onClickTextButton();
        }
    }

    private void onClickTextButton() {
        this.dismiss();
    }
}

