/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmUserList;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.view.NonVerbalFeedbackListAdapter;
import com.zipow.videobox.view.NonVerbalFeedbackListItem;

public class NonVerbalFeedbackListView
extends ListView
implements AdapterView.OnItemClickListener {
    private NonVerbalFeedbackListAdapter mAdapter;

    public NonVerbalFeedbackListView(Context context) {
        super(context);
        this.initView(context);
    }

    public NonVerbalFeedbackListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public NonVerbalFeedbackListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mAdapter = new NonVerbalFeedbackListAdapter(context);
        this.setItemsCanFocus(true);
        if (this.isInEditMode()) {
            this._editMode_reloadAllItem(this.mAdapter);
        } else {
            this.loadAllItem(this.mAdapter);
        }
        this.setAdapter((ListAdapter)this.mAdapter);
        this.setOnItemClickListener(this);
    }

    public void reloadAllItems() {
        this.mAdapter.clear();
        this.loadAllItem(this.mAdapter);
        this.mAdapter.notifyDataSetChanged();
    }

    public void updated(CmmUser user) {
        if (user == null) {
            return;
        }
        boolean update = this.mAdapter.updateFeedback(user);
        if (update) {
            this.mAdapter.checkLabelItem();
            this.mAdapter.notifyDataSetChanged();
        }
    }

    private void loadAllItem(NonVerbalFeedbackListAdapter adapter) {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (adapter == null || confContext == null || !confContext.isFeedbackEnable() || confContext.isWebinar()) {
            return;
        }
        CmmUserList userList = ConfMgr.getInstance().getUserList();
        if (userList == null) {
            return;
        }
        int count = userList.getUserCount();
        for (int i = 0; i < count; ++i) {
            CmmUser user = userList.getUserAt(i);
            if (user == null || user.isMMRUser() || user.getFeedback() == 0) continue;
            adapter.addFeedback(user);
        }
        adapter.checkLabelItem();
    }

    private void _editMode_reloadAllItem(NonVerbalFeedbackListAdapter adapter) {
        NonVerbalFeedbackListItem item;
        int i;
        for (i = 0; i < 3; ++i) {
            item = new NonVerbalFeedbackListItem(1, null);
            item.setScreenName("User_" + i);
            item.setFeedback(1);
            adapter.addNormalFB(item);
        }
        for (i = 0; i < 3; ++i) {
            item = new NonVerbalFeedbackListItem(1, null);
            item.setScreenName("User_" + i);
            item.setFeedback(7);
            adapter.addNormalFB(item);
        }
        adapter.checkLabelItem();
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
    }
}

