/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.view.NonVerbalFeedbackListItem;
import java.util.ArrayList;

public class NonVerbalFeedbackListAdapter
extends BaseAdapter {
    private ArrayList<NonVerbalFeedbackListItem> mFeedbackList = new ArrayList();
    private Context mContext;

    public NonVerbalFeedbackListAdapter(Context context) {
        this.mContext = context;
    }

    public void clear() {
        this.mFeedbackList.clear();
    }

    public void addRaisHandFB(NonVerbalFeedbackListItem item) {
        if (item == null) {
            return;
        }
        int pos = 0;
        for (NonVerbalFeedbackListItem it : this.mFeedbackList) {
            if (it.getFeedback() != 1) break;
            ++pos;
        }
        this.mFeedbackList.add(pos, item);
    }

    public void addNormalFB(NonVerbalFeedbackListItem item) {
        if (item == null) {
            return;
        }
        this.mFeedbackList.add(item);
    }

    public void addFeedback(CmmUser user) {
        if (user == null) {
            return;
        }
        NonVerbalFeedbackListItem item = new NonVerbalFeedbackListItem(1, user);
        if (item.getFeedback() == 1) {
            this.addRaisHandFB(item);
        } else {
            this.addNormalFB(item);
        }
    }

    public boolean updateFeedback(CmmUser user) {
        if (user == null) {
            return false;
        }
        long userId = user.getNodeId();
        int feedback = user.getFeedback();
        for (NonVerbalFeedbackListItem item : this.mFeedbackList) {
            if (userId != item.getUserId()) continue;
            if (feedback == item.getFeedback()) {
                return false;
            }
            this.mFeedbackList.remove(item);
            if (feedback != 0) {
                this.addFeedback(user);
            }
            return true;
        }
        if (feedback != 0) {
            this.addFeedback(user);
            return true;
        }
        return false;
    }

    public void checkLabelItem() {
        NonVerbalFeedbackListItem item;
        int count = this.mFeedbackList.size();
        if (count <= 0) {
            return;
        }
        NonVerbalFeedbackListItem lastItem = this.mFeedbackList.get(count - 1);
        if (lastItem.getFeedback() == 1) {
            return;
        }
        NonVerbalFeedbackListItem firstItem = this.mFeedbackList.get(0);
        if (firstItem.getFeedback() != 1) {
            if (firstItem.getFeedback() == 0) {
                this.mFeedbackList.remove(firstItem);
            }
            return;
        }
        int pos = 0;
        for (NonVerbalFeedbackListItem it : this.mFeedbackList) {
            if (it.getFeedback() != 1) break;
            ++pos;
        }
        if (pos > 0 && pos < count && (item = this.mFeedbackList.get(pos)).getItemType() != 0) {
            NonVerbalFeedbackListItem label = new NonVerbalFeedbackListItem(0, null);
            this.mFeedbackList.add(pos, label);
        }
    }

    public int getCount() {
        return this.mFeedbackList.size();
    }

    public NonVerbalFeedbackListItem getItem(int position) {
        if (position < 0 || position >= this.mFeedbackList.size()) {
            return null;
        }
        return this.mFeedbackList.get(position);
    }

    public long getItemId(int position) {
        NonVerbalFeedbackListItem item = this.getItem(position);
        if (item != null) {
            return item.getUserId();
        }
        return -1L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        NonVerbalFeedbackListItem item = this.getItem(position);
        if (item == null) {
            return null;
        }
        return item.getView(this.mContext, convertView);
    }
}

