/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.zipow.videobox.view.ToolbarButton;
import java.util.ArrayList;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMToolbarLayout;
import us.zoom.videomeetings.R;

public class NonVerbalFeedbackActionView
extends LinearLayout
implements View.OnClickListener {
    private ZMToolbarLayout mPanelEmojis;
    private ToolbarButton mBtnRaiseHand;
    private ToolbarButton mBtnYes;
    private ToolbarButton mBtnNo;
    private ToolbarButton mBtnSlower;
    private ToolbarButton mBtnFaster;
    private ToolbarButton mBtnEmojis;
    private ToolbarButton mBtnGood;
    private ToolbarButton mBtnBad;
    private ToolbarButton mBtnCoffee;
    private ToolbarButton mBtnClock;
    private ToolbarButton mBtnClap;
    private int mFeedback = 0;
    private NonVerbalFBListener mListener = null;

    public NonVerbalFeedbackActionView(Context context) {
        super(context);
        this.init(context);
    }

    public NonVerbalFeedbackActionView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public NonVerbalFeedbackActionView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        View.inflate((Context)context, (int)R.layout.zm_non_verbal_feedback_action, (ViewGroup)this);
        ArrayList<ToolbarButton> toolbarButtons = new ArrayList<ToolbarButton>();
        this.mBtnRaiseHand = (ToolbarButton)this.findViewById(R.id.btnRaiseHand);
        toolbarButtons.add(this.mBtnRaiseHand);
        this.mBtnYes = (ToolbarButton)this.findViewById(R.id.btnYes);
        toolbarButtons.add(this.mBtnYes);
        this.mBtnNo = (ToolbarButton)this.findViewById(R.id.btnNo);
        toolbarButtons.add(this.mBtnNo);
        this.mBtnSlower = (ToolbarButton)this.findViewById(R.id.btnSlower);
        toolbarButtons.add(this.mBtnSlower);
        this.mBtnFaster = (ToolbarButton)this.findViewById(R.id.btnFaster);
        toolbarButtons.add(this.mBtnFaster);
        this.mBtnEmojis = (ToolbarButton)this.findViewById(R.id.btnEmojis);
        toolbarButtons.add(this.mBtnEmojis);
        this.mBtnGood = (ToolbarButton)this.findViewById(R.id.btnGood);
        toolbarButtons.add(this.mBtnGood);
        this.mBtnBad = (ToolbarButton)this.findViewById(R.id.btnBad);
        toolbarButtons.add(this.mBtnBad);
        this.mBtnCoffee = (ToolbarButton)this.findViewById(R.id.btnCoffee);
        toolbarButtons.add(this.mBtnCoffee);
        this.mBtnClock = (ToolbarButton)this.findViewById(R.id.btnClock);
        toolbarButtons.add(this.mBtnClock);
        this.mBtnClap = (ToolbarButton)this.findViewById(R.id.btnClap);
        toolbarButtons.add(this.mBtnClap);
        int padding = UIUtil.dip2px((Context)this.getContext(), (float)3.0f);
        for (ToolbarButton toolbarButton : toolbarButtons) {
            toolbarButton.setPadding(padding, padding, padding, padding);
        }
        this.mPanelEmojis = (ZMToolbarLayout)this.findViewById(R.id.panelEmojis);
        if (this.mBtnRaiseHand != null) {
            this.mBtnRaiseHand.setOnClickListener(this);
        }
        if (this.mBtnYes != null) {
            this.mBtnYes.setOnClickListener(this);
        }
        if (this.mBtnNo != null) {
            this.mBtnNo.setOnClickListener(this);
        }
        if (this.mBtnSlower != null) {
            this.mBtnSlower.setOnClickListener(this);
        }
        if (this.mBtnFaster != null) {
            this.mBtnFaster.setOnClickListener(this);
        }
        if (this.mBtnEmojis != null) {
            this.mBtnEmojis.setOnClickListener(this);
        }
        if (this.mBtnGood != null) {
            this.mBtnGood.setOnClickListener(this);
        }
        if (this.mBtnBad != null) {
            this.mBtnBad.setOnClickListener(this);
        }
        if (this.mBtnCoffee != null) {
            this.mBtnCoffee.setOnClickListener(this);
        }
        if (this.mBtnClock != null) {
            this.mBtnClock.setOnClickListener(this);
        }
        if (this.mBtnClap != null) {
            this.mBtnClap.setOnClickListener(this);
        }
    }

    public void setLinstener(NonVerbalFBListener l) {
        this.mListener = l;
    }

    private void clearFeedbackFocus() {
        this.mBtnRaiseHand.setIconBackgroundResource(0);
        this.mBtnYes.setIconBackgroundResource(0);
        this.mBtnNo.setIconBackgroundResource(0);
        this.mBtnFaster.setIconBackgroundResource(0);
        this.mBtnSlower.setIconBackgroundResource(0);
        this.mBtnGood.setIconBackgroundResource(0);
        this.mBtnClap.setIconBackgroundResource(0);
        this.mBtnCoffee.setIconBackgroundResource(0);
        this.mBtnBad.setIconBackgroundResource(0);
        this.mBtnClock.setIconBackgroundResource(0);
    }

    public void setFeedbackFocus(int feedback) {
        this.clearFeedbackFocus();
        this.mFeedback = feedback;
        boolean bShowEmojisView = false;
        switch (feedback) {
            case 1: {
                this.mBtnRaiseHand.setIconBackgroundResource(R.drawable.zm_feedback_focus_bg);
                break;
            }
            case 4: {
                this.mBtnFaster.setIconBackgroundResource(R.drawable.zm_feedback_focus_bg);
                break;
            }
            case 5: {
                this.mBtnSlower.setIconBackgroundResource(R.drawable.zm_feedback_focus_bg);
                break;
            }
            case 2: {
                this.mBtnYes.setIconBackgroundResource(R.drawable.zm_feedback_focus_bg);
                break;
            }
            case 3: {
                this.mBtnNo.setIconBackgroundResource(R.drawable.zm_feedback_focus_bg);
                break;
            }
            case 7: {
                this.mBtnGood.setIconBackgroundResource(R.drawable.zm_feedback_focus_bg);
                bShowEmojisView = true;
                break;
            }
            case 6: {
                this.mBtnBad.setIconBackgroundResource(R.drawable.zm_feedback_focus_bg);
                bShowEmojisView = true;
                break;
            }
            case 8: {
                this.mBtnClap.setIconBackgroundResource(R.drawable.zm_feedback_focus_bg);
                bShowEmojisView = true;
                break;
            }
            case 9: {
                this.mBtnCoffee.setIconBackgroundResource(R.drawable.zm_feedback_focus_bg);
                bShowEmojisView = true;
                break;
            }
            case 10: {
                this.mBtnClock.setIconBackgroundResource(R.drawable.zm_feedback_focus_bg);
                bShowEmojisView = true;
            }
        }
        if (bShowEmojisView) {
            this.mPanelEmojis.setVisibility(0);
        } else {
            this.mPanelEmojis.setVisibility(8);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        int feedback = -1;
        if (id2 == R.id.btnRaiseHand) {
            feedback = 1;
        } else if (id2 == R.id.btnYes) {
            feedback = 2;
        } else if (id2 == R.id.btnNo) {
            feedback = 3;
        } else if (id2 == R.id.btnSlower) {
            feedback = 5;
        } else if (id2 == R.id.btnFaster) {
            feedback = 4;
        } else if (id2 == R.id.btnGood) {
            feedback = 7;
        } else if (id2 == R.id.btnBad) {
            feedback = 6;
        } else if (id2 == R.id.btnCoffee) {
            feedback = 9;
        } else if (id2 == R.id.btnClock) {
            feedback = 10;
        } else if (id2 == R.id.btnClap) {
            feedback = 8;
        } else if (id2 == R.id.btnEmojis) {
            this.onClickEmojis();
            return;
        }
        if (this.mListener != null) {
            if (feedback == this.mFeedback) {
                this.mListener.onClearFeedback();
            } else {
                this.mListener.onSetFeedback(feedback);
            }
        }
    }

    private void onClickEmojis() {
        if (this.mPanelEmojis == null) {
            return;
        }
        int visibility = this.mPanelEmojis.getVisibility();
        if (visibility == 0) {
            this.mPanelEmojis.setVisibility(8);
        } else if (visibility == 8) {
            this.mPanelEmojis.setVisibility(0);
        }
        this.invalidate();
    }

    public static interface NonVerbalFBListener {
        public void onSetFeedback(int var1);

        public void onClearFeedback();
    }
}

