/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckedTextView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.zipow.annotate.ZoomShareData;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.AudioSessionMgr;
import com.zipow.videobox.confapp.CmmAudioStatus;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmFeedbackMgr;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.RecordMgr;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.confapp.bo.BOMgr;
import com.zipow.videobox.dialog.ConfirmStopRecordDialog;
import com.zipow.videobox.fragment.LoginAsHostAlertDialog;
import com.zipow.videobox.share.ScreenShareMgr;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.NonVerbalFeedbackActionView;
import java.util.ArrayList;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.app.ZMTipFragment;
import us.zoom.androidlib.util.AccessibilityUtil;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMChoiceAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.androidlib.widget.ZMTip;
import us.zoom.androidlib.widget.ZMTipLayer;
import us.zoom.videomeetings.R;

public class MoreTip
extends ZMTipFragment
implements View.OnClickListener,
NonVerbalFeedbackActionView.NonVerbalFBListener {
    private static final String TAG = MoreTip.class.getSimpleName();
    public static final String ARG_ANCHOR_ID = "anchorId";
    private View mBtnStartRecord;
    private View mLlRecordStatus;
    private ImageView mImgRecording;
    private ProgressBar mProgressStartingRecord;
    private TextView mTxtRecordStatus;
    private ImageView mBtnPauseRecord;
    private ImageView mBtnStopRecord;
    private View mBtnLoginAsHost;
    private View mBtnClaimHostByHostKey;
    private TextView mTxtHandAction;
    private View mBtnEnableAnnotate;
    private View mBtnDisableAnnotate;
    private View mBtnDisconnectAudio;
    private View mPanelDisconnectAudio;
    private View mPanelHandAction;
    private View mPanelRecord;
    private View mPanelOptions;
    private View mPanelNonHostAction;
    private CheckedTextView mChkLockMeeting;
    private View mPanelOptionLockMeeting;
    private View mOptionLockMeeting;
    private CheckedTextView mChkLockShare;
    private View mPanelOptionLockShare;
    private View mOptionLockShare;
    private CheckedTextView mChkMuteOnEntry;
    private View mOptionMuteOnEntry;
    private CheckedTextView mChkPlayEnterExitChime;
    private View mOptionPlayEnterExitChime;
    private CheckedTextView mChkAllowPanelistVideo;
    private View mOptionAllowPanelistVideo;
    private CheckedTextView mChkPutOnHoldOnEntry;
    private View mOptionPutOnHoldOnEntry;
    private CheckedTextView mChkAllowAttendeeRaiseHand;
    private View mOptionAllowAttendeeRaiseHand;
    private CheckedTextView mChkDisableAttendeeAnnotation;
    private View mOptionDisableAttendeeAnnotation;
    private View mBtnClaimHost;
    private View mPanelClaimHost;
    private View mPanelFeedback;
    private NonVerbalFeedbackActionView mFeedbackActionView;
    private View mBtnClearMyFeedback;
    private View mPanelControlAccess;
    private TextView mTxtCurPrivildge;
    private ConfUI.IConfUIListener mConfUIListener;

    public static void show(FragmentManager fragmentMgr, int anchorId) {
        if (fragmentMgr == null) {
            return;
        }
        Bundle args = new Bundle();
        args.putInt(ARG_ANCHOR_ID, anchorId);
        MoreTip tip = new MoreTip();
        tip.setArguments(args);
        tip.show(fragmentMgr, MoreTip.class.getName());
    }

    public static void updateIfExists(FragmentManager fragmentMgr) {
        if (fragmentMgr == null) {
            return;
        }
        MoreTip tip = (MoreTip)fragmentMgr.findFragmentByTag(MoreTip.class.getName());
        if (tip != null) {
            tip.updateUI();
        }
    }

    public static void updateRecordIfExists(FragmentManager fragmentMgr, boolean isCurUserRecording, boolean isInDrivingMode) {
        if (fragmentMgr == null) {
            return;
        }
        MoreTip tip = (MoreTip)fragmentMgr.findFragmentByTag(MoreTip.class.getName());
        if (tip != null) {
            tip.updateRecord(isCurUserRecording, isInDrivingMode);
        }
    }

    public static boolean isShown(FragmentManager fragmentMgr) {
        if (fragmentMgr == null) {
            return false;
        }
        MoreTip tip = (MoreTip)fragmentMgr.findFragmentByTag(MoreTip.class.getName());
        return tip != null;
    }

    public static boolean dismiss(FragmentManager fragmentMgr) {
        if (fragmentMgr == null) {
            return false;
        }
        MoreTip tip = (MoreTip)fragmentMgr.findFragmentByTag(MoreTip.class.getName());
        if (tip != null) {
            tip.dismiss();
            return true;
        }
        return false;
    }

    public static boolean hasItemsToShow() {
        ConfMgr confMgr = ConfMgr.getInstance();
        CmmUser myself = confMgr.getMyself();
        CmmConfContext confContext = confMgr.getConfContext();
        if (myself != null && confContext != null) {
            boolean isCurUserHost = myself.isHost();
            boolean isCurUserCoHost = myself.isCoHost();
            CmmAudioStatus audioStatus = myself.getAudioStatusObj();
            if (!isCurUserHost && !isCurUserCoHost && audioStatus != null && audioStatus.getAudiotype() == 2L && confContext.isWebinar()) {
                return false;
            }
            if (myself.isBOModerator() && audioStatus != null && audioStatus.getAudiotype() == 2L) {
                return false;
            }
        }
        return true;
    }

    public ZMTip onCreateTip(Context context, LayoutInflater layoutInflater, Bundle savedInstanceState) {
        View anchor;
        View view = layoutInflater.inflate(R.layout.zm_more_tip, null);
        this.mBtnStartRecord = view.findViewById(R.id.btnStartRecord);
        this.mLlRecordStatus = view.findViewById(R.id.llRecordStatus);
        this.mImgRecording = (ImageView)view.findViewById(R.id.imgRecording);
        this.mProgressStartingRecord = (ProgressBar)view.findViewById(R.id.progressStartingRecord);
        this.mTxtRecordStatus = (TextView)view.findViewById(R.id.txtRecordStatus);
        this.mBtnPauseRecord = (ImageView)view.findViewById(R.id.btn_pause_record);
        this.mBtnStopRecord = (ImageView)view.findViewById(R.id.btn_stop_record);
        this.mBtnLoginAsHost = view.findViewById(R.id.btnLoginAsHost);
        this.mBtnClaimHostByHostKey = view.findViewById(R.id.btnClaimHostByHostkey);
        this.mPanelNonHostAction = view.findViewById(R.id.panelNonHostAction);
        this.mTxtHandAction = (TextView)view.findViewById(R.id.txtHandAction);
        this.mBtnEnableAnnotate = view.findViewById(R.id.btnEnableAnnotation);
        this.mBtnDisableAnnotate = view.findViewById(R.id.btnDisableAnnotation);
        this.mPanelHandAction = view.findViewById(R.id.panelHandAction);
        this.mBtnDisconnectAudio = view.findViewById(R.id.btnDisconnectAudio);
        this.mPanelDisconnectAudio = view.findViewById(R.id.panelDisconnectAudio);
        this.mPanelRecord = view.findViewById(R.id.panelRecord);
        this.mPanelOptions = view.findViewById(R.id.panelOptions);
        this.mChkLockMeeting = (CheckedTextView)view.findViewById(R.id.chkLockMeeting);
        this.mPanelOptionLockMeeting = view.findViewById(R.id.panelOptionLockMeeting);
        this.mOptionLockMeeting = view.findViewById(R.id.optionLockMeeting);
        this.mChkLockShare = (CheckedTextView)view.findViewById(R.id.chkLockShare);
        this.mPanelOptionLockShare = view.findViewById(R.id.panelOptionLockShare);
        this.mOptionLockShare = view.findViewById(R.id.optionLockShare);
        this.mChkMuteOnEntry = (CheckedTextView)view.findViewById(R.id.chkMuteOnEntry);
        this.mOptionMuteOnEntry = view.findViewById(R.id.optionMuteOnEntry);
        this.mChkPlayEnterExitChime = (CheckedTextView)view.findViewById(R.id.chkPlayEnterExitChime);
        this.mOptionPlayEnterExitChime = view.findViewById(R.id.optionPlayEnterExitChime);
        this.mChkAllowPanelistVideo = (CheckedTextView)view.findViewById(R.id.chkAllowPanelistVideo);
        this.mOptionAllowPanelistVideo = view.findViewById(R.id.optionAllowPanelistVideo);
        this.mChkPutOnHoldOnEntry = (CheckedTextView)view.findViewById(R.id.chkPutOnHoldOnEntry);
        this.mOptionPutOnHoldOnEntry = view.findViewById(R.id.optionPutOnHoldOnEntry);
        this.mChkAllowAttendeeRaiseHand = (CheckedTextView)view.findViewById(R.id.chkAllowAttendeeRaiseHand);
        this.mOptionAllowAttendeeRaiseHand = view.findViewById(R.id.optionAllowAttendeeRaiseHand);
        this.mChkDisableAttendeeAnnotation = (CheckedTextView)view.findViewById(R.id.chkDisableAttendeeAnnotation);
        this.mOptionDisableAttendeeAnnotation = view.findViewById(R.id.optionDisableAttendeeAnnotation);
        this.mBtnClaimHost = view.findViewById(R.id.btnClaimHost);
        this.mPanelClaimHost = view.findViewById(R.id.panelClaimHost);
        this.mPanelFeedback = view.findViewById(R.id.panelFeedback);
        this.mFeedbackActionView = (NonVerbalFeedbackActionView)view.findViewById(R.id.viewFeedback);
        this.mBtnClearMyFeedback = view.findViewById(R.id.txtClearFeedback);
        this.mPanelControlAccess = view.findViewById(R.id.panelControlAccess);
        this.mTxtCurPrivildge = (TextView)view.findViewById(R.id.txtCurPrivildge);
        TextView txtLockMeeting = (TextView)view.findViewById(R.id.txtLockMeeting);
        TextView txtLockMeetingDesc = (TextView)view.findViewById(R.id.txtLockMeetingDesc);
        CmmConfContext cmmConfContext = ConfMgr.getInstance().getConfContext();
        if (cmmConfContext != null) {
            if (cmmConfContext.isWebinar()) {
                txtLockMeeting.setText((CharSequence)this.getString(R.string.zm_mi_lock_webinar_18265));
                txtLockMeetingDesc.setText((CharSequence)this.getString(R.string.zm_lbl_lock_webinar_desc_18265));
            } else {
                txtLockMeeting.setText((CharSequence)this.getString(R.string.zm_mi_lock_meeting));
                txtLockMeetingDesc.setText((CharSequence)this.getString(R.string.zm_lbl_lock_meeting_desc));
            }
        }
        this.updateUI();
        int displayWidth = UIUtil.getDisplayWidth((Context)context);
        int displayHeight = UIUtil.getDisplayHeight((Context)context);
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)displayWidth, (int)Integer.MIN_VALUE);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)displayHeight, (int)Integer.MIN_VALUE);
        view.measure(widthMeasureSpec, heightMeasureSpec);
        int width = view.getMeasuredWidth();
        if (width > displayWidth * 7 / 8) {
            width = displayWidth * 7 / 8;
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(width, -2);
            view.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        Bundle args = this.getArguments();
        ZMTip tip = new ZMTip(context);
        tip.addView(view);
        int anchorId = args.getInt(ARG_ANCHOR_ID, 0);
        if (anchorId > 0 && (anchor = this.getActivity().findViewById(anchorId)) != null) {
            tip.setAnchor(anchor, UIMgr.isLargeMode((Context)this.getActivity()) ? 1 : 3);
        }
        this.mBtnStartRecord.setOnClickListener((View.OnClickListener)this);
        this.mBtnPauseRecord.setOnClickListener((View.OnClickListener)this);
        this.mBtnStopRecord.setOnClickListener((View.OnClickListener)this);
        this.mBtnLoginAsHost.setOnClickListener((View.OnClickListener)this);
        this.mBtnClaimHostByHostKey.setOnClickListener((View.OnClickListener)this);
        this.mTxtHandAction.setOnClickListener((View.OnClickListener)this);
        this.mBtnEnableAnnotate.setOnClickListener((View.OnClickListener)this);
        this.mBtnDisableAnnotate.setOnClickListener((View.OnClickListener)this);
        this.mBtnDisconnectAudio.setOnClickListener((View.OnClickListener)this);
        this.mPanelOptionLockMeeting.setOnClickListener((View.OnClickListener)this);
        this.mPanelOptionLockShare.setOnClickListener((View.OnClickListener)this);
        this.mOptionMuteOnEntry.setOnClickListener((View.OnClickListener)this);
        this.mOptionPlayEnterExitChime.setOnClickListener((View.OnClickListener)this);
        this.mOptionAllowPanelistVideo.setOnClickListener((View.OnClickListener)this);
        this.mOptionPutOnHoldOnEntry.setOnClickListener((View.OnClickListener)this);
        this.mOptionAllowAttendeeRaiseHand.setOnClickListener((View.OnClickListener)this);
        this.mChkDisableAttendeeAnnotation.setOnClickListener((View.OnClickListener)this);
        this.mBtnClaimHost.setOnClickListener((View.OnClickListener)this);
        this.mFeedbackActionView.setLinstener(this);
        this.mBtnClearMyFeedback.setOnClickListener((View.OnClickListener)this);
        this.mPanelControlAccess.setOnClickListener((View.OnClickListener)this);
        this.mBtnEnableAnnotate.setVisibility(8);
        this.mBtnDisableAnnotate.setVisibility(8);
        this.mOptionDisableAttendeeAnnotation.setVisibility(8);
        return tip;
    }

    public void onResume() {
        super.onResume();
        if (this.mConfUIListener == null) {
            this.mConfUIListener = new ConfUI.SimpleConfUIListener(){

                @Override
                public boolean onUserEvent(int eventType, long userId, int flag) {
                    return MoreTip.this.onUserEvent(eventType, userId, flag);
                }

                @Override
                public boolean onConfStatusChanged2(int cmd, long ret) {
                    if (cmd == 28) {
                        MoreTip.this.updatePrivildge();
                    }
                    return false;
                }
            };
        }
        ConfUI.getInstance().addListener(this.mConfUIListener);
        this.updateUI();
    }

    public void onPause() {
        super.onPause();
        ConfUI.getInstance().removeListener(this.mConfUIListener);
    }

    private boolean onUserEvent(final int eventType, final long userId, final int flag) {
        this.getNonNullEventTaskManagerOrThrowException().pushLater(new EventAction("onUserEvent"){

            public void run(IUIElement ui) {
                ((MoreTip)ui).handleOnUserEvent(eventType, userId, flag);
            }
        });
        return true;
    }

    private void handleOnUserEvent(int eventType, long userId, int flag) {
        if (eventType == 0) {
            this.updateUI();
        }
    }

    private void updatePrivildge() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            this.dismiss();
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            this.dismiss();
            return;
        }
        int privildge = confStatus.getAttendeeChatPriviledge();
        if (confContext.isWebinar()) {
            if (!ConfMgr.getInstance().isAllowAttendeeChat()) {
                this.mTxtCurPrivildge.setText(R.string.zm_mi_no_one_11380);
            } else if (privildge == 1) {
                this.mTxtCurPrivildge.setText(R.string.zm_mi_panelists_and_attendees_11380);
            } else {
                this.mTxtCurPrivildge.setText(R.string.zm_webinar_txt_all_panelists);
            }
        } else if (privildge == 3) {
            this.mTxtCurPrivildge.setText(R.string.zm_mi_host_only_11380);
        } else {
            this.mTxtCurPrivildge.setText(R.string.zm_webinar_txt_everyone);
        }
    }

    private void updateRecord(boolean isCurUserRecording, boolean isInDrivingMode) {
        RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
        if (recordMgr == null) {
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        if (ConfLocalHelper.isViewOnlyButNotSpeakAttendee()) {
            this.mLlRecordStatus.setVisibility(8);
            return;
        }
        if (isCurUserRecording) {
            this.mLlRecordStatus.setVisibility(!isInDrivingMode ? 0 : 8);
            if (confStatus.isCMRInConnecting()) {
                this.mImgRecording.setVisibility(8);
                this.mBtnPauseRecord.setVisibility(4);
                this.mBtnStopRecord.setVisibility(4);
                this.mProgressStartingRecord.setVisibility(0);
                this.mTxtRecordStatus.setText(R.string.zm_record_status_preparing);
            } else {
                if (recordMgr.isCMRPaused()) {
                    this.mImgRecording.setVisibility(8);
                    this.mTxtRecordStatus.setText(R.string.zm_record_status_paused);
                } else {
                    this.mImgRecording.setVisibility(0);
                    this.mTxtRecordStatus.setText(R.string.zm_record_status_recording);
                }
                CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
                if (confContext != null && confContext.isAutoCMRForbidManualStop() && !recordMgr.isCMRPaused()) {
                    this.mBtnPauseRecord.setVisibility(4);
                    this.mBtnStopRecord.setVisibility(4);
                } else {
                    this.mBtnPauseRecord.setVisibility(0);
                    this.mBtnStopRecord.setVisibility(0);
                    this.mBtnPauseRecord.setImageResource(recordMgr.isCMRPaused() ? R.drawable.zm_btn_record_resume : R.drawable.zm_btn_record_pause);
                    this.mBtnPauseRecord.setContentDescription((CharSequence)(recordMgr.isCMRPaused() ? this.getString(R.string.zm_record_btn_resume) : this.getString(R.string.zm_record_btn_pause)));
                }
                this.mProgressStartingRecord.setVisibility(8);
            }
        } else {
            this.mLlRecordStatus.setVisibility(8);
        }
    }

    private void updateUI() {
        if (!ConfMgr.getInstance().isConfConnected()) {
            this.dismiss();
            return;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            this.dismiss();
            return;
        }
        CmmAudioStatus audioStatus = myself.getAudioStatusObj();
        if (audioStatus == null) {
            this.dismiss();
            return;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            this.dismiss();
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            this.dismiss();
            return;
        }
        AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
        if (audioMgr == null) {
            this.dismiss();
            return;
        }
        boolean isOrginaHost = confContext.getOrginalHost();
        BOMgr boMgr = ConfMgr.getInstance().getBOMgr();
        long audioType = audioStatus.getAudiotype();
        if (2L == audioType) {
            this.mPanelDisconnectAudio.setVisibility(8);
        } else {
            this.mPanelDisconnectAudio.setVisibility(this.isDisconnectAudioDisabled() ? 8 : 0);
        }
        boolean isPrivateChatOff = confContext.isPrivateChatOFF();
        if (isPrivateChatOff && !confContext.isWebinar()) {
            this.mPanelControlAccess.setVisibility(8);
        } else {
            this.mPanelControlAccess.setVisibility(myself.isHost() || myself.isCoHost() ? 0 : 8);
        }
        this.updatePrivildge();
        if (myself.isHost() || myself.isCoHost() || myself.isBOModerator()) {
            ShareSessionMgr shareMgr;
            RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
            if (!myself.isBOModerator() && recordMgr != null && recordMgr.canStartCMR()) {
                boolean recording = recordMgr.isRecordingInProgress();
                this.mBtnStartRecord.setVisibility(recording ? 8 : 0);
                this.mLlRecordStatus.setVisibility(recording ? 0 : 8);
                boolean isCurUserRecording = recordMgr.isRecordingInProgress();
                ConfActivity confActivity = (ConfActivity)this.getActivity();
                if (confActivity != null) {
                    this.updateRecord(isCurUserRecording, confActivity.isInDivveMode());
                } else {
                    this.updateRecord(isCurUserRecording, false);
                }
            } else {
                this.mPanelRecord.setVisibility(8);
            }
            if (myself.isBOModerator()) {
                this.mOptionLockMeeting.setVisibility(8);
                this.mOptionLockShare.setVisibility(8);
                this.mOptionMuteOnEntry.setVisibility(8);
                this.mOptionPlayEnterExitChime.setVisibility(8);
                this.mOptionPutOnHoldOnEntry.setVisibility(8);
            } else {
                this.mOptionLockMeeting.setVisibility(0);
                this.mOptionLockShare.setVisibility(0);
                this.mOptionMuteOnEntry.setVisibility(0);
                this.mOptionPlayEnterExitChime.setVisibility(0);
                this.mOptionPutOnHoldOnEntry.setVisibility(0);
                this.mChkLockMeeting.setChecked(confStatus.isConfLocked());
                this.mChkLockShare.setChecked(ConfMgr.getInstance().isShareLocked());
                this.mChkMuteOnEntry.setChecked(audioMgr.isMuteOnEntryOn());
                this.mChkPlayEnterExitChime.setChecked(ConfMgr.getInstance().isPlayChimeOn());
                if (confContext.isMeetingSupportSilentMode() && confContext.supportPutUserinWaitingListUponEntryFeature()) {
                    this.mChkPutOnHoldOnEntry.setChecked(ConfMgr.getInstance().isPutOnHoldOnEntryOn());
                } else {
                    this.mOptionPutOnHoldOnEntry.setVisibility(8);
                }
            }
            this.mPanelHandAction.setVisibility(8);
            if (confContext.isWebinar()) {
                this.mChkAllowPanelistVideo.setChecked(!confStatus.isStartVideoDisabled());
                this.mChkAllowAttendeeRaiseHand.setChecked(confStatus.isAllowRaiseHand());
            } else {
                this.mOptionAllowPanelistVideo.setVisibility(8);
                this.mOptionAllowAttendeeRaiseHand.setVisibility(8);
            }
            if (!myself.isBOModerator()) {
                if (confContext.isScreenShareDisabled()) {
                    this.mOptionLockShare.setVisibility(8);
                } else {
                    this.mOptionLockShare.setVisibility(0);
                }
            }
            if (null != (shareMgr = ConfMgr.getInstance().getShareObj()) && this.isStartingShare() && shareMgr.senderSupportAnnotation(0L)) {
                boolean isShareLocked = shareMgr.isAttendeeAnnotationDisabledForMySharedContent();
                this.mOptionDisableAttendeeAnnotation.setVisibility(0);
                this.mChkDisableAttendeeAnnotation.setChecked(isShareLocked);
            } else {
                this.mOptionDisableAttendeeAnnotation.setVisibility(8);
            }
            this.mPanelNonHostAction.setVisibility(8);
            this.mPanelFeedback.setVisibility(8);
            this.mBtnClearMyFeedback.setVisibility(8);
        } else {
            this.mPanelRecord.setVisibility(8);
            this.mPanelOptions.setVisibility(8);
            if (ConfMgr.getInstance().isViewOnlyMeeting()) {
                this.mPanelHandAction.setVisibility(8);
            } else if (confContext.isFeedbackEnable()) {
                this.mPanelHandAction.setVisibility(8);
            } else {
                this.mPanelHandAction.setVisibility(0);
                if (myself.getRaiseHandState()) {
                    this.mTxtHandAction.setText((CharSequence)this.getString(R.string.zm_btn_lower_hand));
                    this.mTxtHandAction.setContentDescription((CharSequence)this.getString(R.string.zm_description_msg_myself_lower_hand_17843));
                } else {
                    this.mTxtHandAction.setText((CharSequence)this.getString(R.string.zm_btn_raise_hand));
                    this.mTxtHandAction.setContentDescription((CharSequence)this.getString(R.string.zm_description_msg_myself_raise_hand_17843));
                }
            }
            if (!(confStatus.hasHostinMeeting() || boMgr != null && boMgr.isInBOMeeting())) {
                if (VideoBoxApplication.getInstance().isSDKMode()) {
                    this.mBtnLoginAsHost.setVisibility(8);
                    if (PreferenceUtil.readBooleanValue("sdk_enable_claim_host_with_hostkey", false)) {
                        this.mPanelNonHostAction.setVisibility(0);
                    } else {
                        this.mBtnClaimHostByHostKey.setVisibility(8);
                        this.mPanelNonHostAction.setVisibility(8);
                    }
                } else {
                    this.mPanelNonHostAction.setVisibility(0);
                }
            } else {
                this.mPanelNonHostAction.setVisibility(8);
            }
            ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
            if (null != shareMgr && this.isStartingShare() && shareMgr.senderSupportAnnotation(0L)) {
                boolean isShareLocked = shareMgr.isAttendeeAnnotationDisabledForMySharedContent();
                this.mBtnEnableAnnotate.setVisibility(isShareLocked ? 0 : 8);
                this.mBtnDisableAnnotate.setVisibility(isShareLocked ? 8 : 0);
            }
            if (confContext.isFeedbackEnable()) {
                this.mPanelFeedback.setVisibility(0);
                this.mFeedbackActionView.setFeedbackFocus(myself.getFeedback());
                if (myself.getFeedback() == 0) {
                    this.mBtnClearMyFeedback.setVisibility(8);
                } else {
                    this.mBtnClearMyFeedback.setVisibility(0);
                }
            } else {
                this.mPanelFeedback.setVisibility(8);
                this.mBtnClearMyFeedback.setVisibility(8);
            }
        }
        if (isOrginaHost) {
            boolean isInBoMeeting;
            boolean bl = isInBoMeeting = boMgr != null && boMgr.isInBOMeeting();
            if (!isInBoMeeting && !myself.isHost() || isInBoMeeting && !boMgr.isBOController()) {
                this.mPanelClaimHost.setVisibility(0);
            } else {
                this.mPanelClaimHost.setVisibility(8);
            }
        } else {
            this.mPanelClaimHost.setVisibility(8);
        }
        ZMTip tip = this.getTip();
        if (tip != null) {
            ZMTipLayer parent = (ZMTipLayer)tip.getParent();
            if (parent == null) {
                return;
            }
            parent.requestLayout();
        }
    }

    public void onClick(View v) {
        if (v == this.mBtnStartRecord) {
            this.onClickBtnStartRecord();
            this.dismiss();
        } else if (v == this.mBtnStopRecord) {
            ZMActivity zmActivity = (ZMActivity)this.getActivity();
            if (zmActivity != null) {
                ConfirmStopRecordDialog.showConfirmStopRecordDialog(zmActivity);
                this.dismiss();
            }
        } else if (v == this.mBtnPauseRecord) {
            this.onClickBtnPauseRecord();
        } else if (v == this.mBtnDisconnectAudio) {
            this.onClickBtnDisconnectAudio();
            this.dismiss();
        } else if (v == this.mPanelOptionLockMeeting) {
            this.onClickChkLockMeeting();
        } else if (v == this.mPanelOptionLockShare) {
            this.onClickChkLockShare();
        } else if (v == this.mOptionMuteOnEntry) {
            this.onClickChkMuteOnEntry();
        } else if (v == this.mOptionPlayEnterExitChime) {
            this.onClickChkEnterExitChime();
        } else if (v == this.mOptionAllowPanelistVideo) {
            this.onClickChkAllowPanelistVideo();
        } else if (v == this.mOptionPutOnHoldOnEntry) {
            this.onClickChkPutOnHoldOnEntry();
        } else if (v == this.mOptionAllowAttendeeRaiseHand) {
            this.onClickChkAllowAttendeeRaiseHand();
        } else if (v == this.mChkDisableAttendeeAnnotation) {
            boolean on = !this.mChkDisableAttendeeAnnotation.isChecked();
            this.mChkDisableAttendeeAnnotation.setChecked(on);
            this.onClickAnnotateDisable(on);
        } else if (v == this.mTxtHandAction) {
            this.onClickHandAction();
            this.dismiss();
        } else if (v == this.mBtnEnableAnnotate) {
            this.onClickAnnotateDisable(false);
            this.dismiss();
        } else if (v == this.mBtnDisableAnnotate) {
            this.onClickAnnotateDisable(true);
            this.dismiss();
        } else if (v == this.mBtnLoginAsHost) {
            this.onClickLoginAsHost();
            this.dismiss();
        } else if (v == this.mBtnClaimHostByHostKey) {
            this.onClickClaimHostByHostKey();
            this.dismiss();
        } else if (v == this.mBtnClaimHost) {
            this.onClickClaimHost();
            this.dismiss();
        } else if (v == this.mBtnClearMyFeedback) {
            this.onClickClearMyFeedback();
            this.dismiss();
        } else if (v == this.mPanelControlAccess) {
            this.onClickControlAccess();
        }
    }

    private void onClickClearMyFeedback() {
        CmmFeedbackMgr feedbackMgr = ConfMgr.getInstance().getFeedbackMgr();
        if (feedbackMgr == null) {
            return;
        }
        feedbackMgr.changeMyFeedback(0);
    }

    private void onClickClaimHostByHostKey() {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null && confStatus.hasHostinMeeting()) {
            this.updateUI();
            return;
        }
        ConfActivity confActivity = (ConfActivity)this.getActivity();
        if (confActivity != null) {
            confActivity.enterHostKeyToClaimHost();
        }
    }

    private void onClickClaimHost() {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return;
        }
        ConfMgr.getInstance().handleUserCmd(30, myself.getNodeId());
    }

    private void onClickLoginAsHost() {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null && confStatus.hasHostinMeeting()) {
            this.updateUI();
            return;
        }
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        LoginAsHostAlertDialog.showLoginAsHostAlertDialog(activity);
    }

    private void onClickBtnStartRecord() {
        RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
        if (recordMgr.canStartCMR()) {
            recordMgr.startCMR();
        }
    }

    private void onClickBtnPauseRecord() {
        RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
        if (recordMgr != null) {
            if (recordMgr.isCMRPaused()) {
                if (ConfLocalHelper.resumeRecord()) {
                    this.mBtnPauseRecord.setImageResource(R.drawable.zm_btn_record_pause);
                }
                this.mBtnPauseRecord.setContentDescription((CharSequence)this.getString(R.string.zm_record_btn_pause));
            } else {
                ZMActivity activity = (ZMActivity)this.getActivity();
                if (activity != null && ConfLocalHelper.pauseRecord()) {
                    this.mBtnPauseRecord.setImageResource(R.drawable.zm_btn_record_resume);
                    this.mBtnPauseRecord.setContentDescription((CharSequence)this.getString(R.string.zm_record_btn_resume));
                }
            }
        }
    }

    private void onClickChkLockMeeting() {
        boolean lock = !this.mChkLockMeeting.isChecked();
        this.lockMeeting(lock);
    }

    private void lockMeeting(boolean lock) {
        ConfMgr.getInstance().handleConfCmd(lock ? 56 : 57);
        this.mChkLockMeeting.setChecked(lock);
    }

    private void onClickChkLockShare() {
        boolean lock = !this.mChkLockShare.isChecked();
        this.lockShare(lock);
    }

    private void lockShare(boolean lock) {
        ConfMgr.getInstance().handleConfCmd(lock ? 76 : 77);
        this.mChkLockShare.setChecked(lock);
    }

    private void onClickChkMuteOnEntry() {
        boolean on = !this.mChkMuteOnEntry.isChecked();
        this.mChkMuteOnEntry.setChecked(on);
        AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
        if (audioMgr != null) {
            audioMgr.setMuteOnEntry(on);
        }
    }

    private void onClickChkEnterExitChime() {
        boolean on = !this.mChkPlayEnterExitChime.isChecked();
        this.mChkPlayEnterExitChime.setChecked(on);
        ConfMgr.getInstance().setPlayChimeOnOff(on);
    }

    private void onClickBtnDisconnectAudio() {
        ConfActivity confActivity = (ConfActivity)this.getActivity();
        if (confActivity != null) {
            confActivity.disconnectAudio();
        }
    }

    private void onClickChkAllowPanelistVideo() {
        boolean on = !this.mChkAllowPanelistVideo.isChecked();
        this.mChkAllowPanelistVideo.setChecked(on);
        ConfMgr.getInstance().handleConfCmd(on ? 102 : 103);
    }

    private void onClickChkPutOnHoldOnEntry() {
        boolean on = !this.mChkPutOnHoldOnEntry.isChecked();
        this.mChkPutOnHoldOnEntry.setChecked(on);
        ConfMgr.getInstance().setPutOnHoldOnEntry(on);
    }

    private void onClickChkAllowAttendeeRaiseHand() {
        boolean on = !this.mChkAllowAttendeeRaiseHand.isChecked();
        this.mChkAllowAttendeeRaiseHand.setChecked(on);
        ConfMgr.getInstance().handleConfCmd(on ? 117 : 118);
    }

    private void onClickHandAction() {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return;
        }
        if (myself.getRaiseHandState()) {
            if (ConfMgr.getInstance().handleUserCmd(36, myself.getNodeId()) && AccessibilityUtil.isSpokenFeedbackEnabled((Context)this.getContext())) {
                AccessibilityUtil.announceForAccessibilityCompat((View)this.mTxtHandAction, (int)R.string.zm_description_msg_myself_already_lower_hand_17843);
            }
        } else if (ConfMgr.getInstance().handleUserCmd(35, myself.getNodeId()) && AccessibilityUtil.isSpokenFeedbackEnabled((Context)this.getContext())) {
            AccessibilityUtil.announceForAccessibilityCompat((View)this.mTxtHandAction, (int)R.string.zm_description_msg_myself_already_raise_hand_17843);
        }
    }

    private void onClickAnnotateDisable(boolean bDisable) {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (null != shareMgr) {
            shareMgr.DisableAttendeeAnnotationForMySharedContent(bDisable);
            ZoomShareData.getInstance().setAttendeeAnnotateDisable(bDisable);
            if (!bDisable && ScreenShareMgr.getInstance().isSharing()) {
                ScreenShareMgr.getInstance().setAnnoToolbarVisible(true);
            }
        }
    }

    private void onClickControlAccess() {
        FragmentManager fm = this.getActivity().getSupportFragmentManager();
        if (fm == null) {
            return;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return;
        }
        boolean isWebinar = confContext.isWebinar();
        CmmConfStatus cmmConfStatus = ConfMgr.getInstance().getConfStatusObj();
        if (cmmConfStatus == null) {
            return;
        }
        int privildge = cmmConfStatus.getAttendeeChatPriviledge();
        HostControlAccessDialog.show(fm, isWebinar ? 1 : 0, privildge);
    }

    private boolean isStartingShare() {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (null != shareMgr) {
            int shareStatus = shareMgr.getShareStatus();
            return shareStatus == 2 || shareStatus == 1;
        }
        return false;
    }

    private boolean isDisconnectAudioDisabled() {
        ConfActivity confActivity = (ConfActivity)this.getActivity();
        return confActivity != null && confActivity.getConfParams().isDisconnectAudioDisabled();
    }

    @Override
    public void onSetFeedback(int feedback) {
        CmmFeedbackMgr feedbackMgr = ConfMgr.getInstance().getFeedbackMgr();
        if (feedbackMgr == null) {
            return;
        }
        if (feedback == 1) {
            this.onClickHandAction();
        } else {
            feedbackMgr.changeMyFeedback(feedback);
        }
        this.dismiss();
    }

    @Override
    public void onClearFeedback() {
        CmmFeedbackMgr feedbackMgr = ConfMgr.getInstance().getFeedbackMgr();
        if (feedbackMgr == null) {
            return;
        }
        feedbackMgr.changeMyFeedback(0);
        this.dismiss();
    }

    public static class HostControlAccessDialog
    extends ZMDialogFragment {
        private static final String MODE = "MODE";
        private static final String CURRENT_PRIVILEDGE = "CURRENT_PRIVILEDGE";
        private static final int MODE_MEETING = 0;
        private static final int MODE_WEBINAR = 1;
        private int mMode;
        private int mCurPriviledge;
        private ZMChoiceAdapter<ZMSimpleMenuItem> mAdapter;

        public static void show(@NonNull FragmentManager fm, int mode, int priviledge) {
            Bundle args = new Bundle();
            args.putInt(MODE, mode);
            args.putInt(CURRENT_PRIVILEDGE, priviledge);
            HostControlAccessDialog f = new HostControlAccessDialog();
            f.setArguments(args);
            f.show(fm, HostControlAccessDialog.class.getName());
        }

        public HostControlAccessDialog() {
            this.setCancelable(true);
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            FragmentActivity activity = this.getActivity();
            Bundle bundle = this.getArguments();
            if (bundle != null) {
                this.mMode = bundle.getInt(MODE, 0);
                this.mCurPriviledge = bundle.getInt(CURRENT_PRIVILEDGE, 1);
            }
            this.mAdapter = this.createUpdateAdapter((Context)activity);
            ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setTitle(R.string.zm_mi_allow_attendees_chat_11380).setAdapter(this.mAdapter, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    HostControlAccessDialog.this.onSelectItem(which);
                }
            }).create();
            dialog.setCanceledOnTouchOutside(true);
            return dialog;
        }

        private ZMChoiceAdapter<ZMSimpleMenuItem> createUpdateAdapter(Context context) {
            ArrayList<ZMSimpleMenuItem> items = new ArrayList<ZMSimpleMenuItem>();
            if (this.mMode == 0) {
                ZMSimpleMenuItem zmSimpleMenuItem = new ZMSimpleMenuItem(context.getString(R.string.zm_mi_host_only_11380), null);
                items.add(zmSimpleMenuItem);
                zmSimpleMenuItem = new ZMSimpleMenuItem(context.getString(R.string.zm_webinar_txt_everyone), null);
                items.add(zmSimpleMenuItem);
                if (this.mCurPriviledge == 3) {
                    ((ZMSimpleMenuItem)items.get(0)).setSelected(true);
                } else {
                    ((ZMSimpleMenuItem)items.get(1)).setSelected(true);
                }
            } else {
                ZMSimpleMenuItem zmSimpleMenuItem = new ZMSimpleMenuItem(context.getString(R.string.zm_mi_no_one_11380), null);
                items.add(zmSimpleMenuItem);
                zmSimpleMenuItem = new ZMSimpleMenuItem(context.getString(R.string.zm_webinar_txt_all_panelists), null);
                items.add(zmSimpleMenuItem);
                zmSimpleMenuItem = new ZMSimpleMenuItem(context.getString(R.string.zm_mi_panelists_and_attendees_11380), null);
                items.add(zmSimpleMenuItem);
                if (!ConfMgr.getInstance().isAllowAttendeeChat()) {
                    ((ZMSimpleMenuItem)items.get(0)).setSelected(true);
                } else if (this.mCurPriviledge == 2) {
                    ((ZMSimpleMenuItem)items.get(1)).setSelected(true);
                } else {
                    ((ZMSimpleMenuItem)items.get(2)).setSelected(true);
                }
            }
            if (this.mAdapter == null) {
                this.mAdapter = new ZMChoiceAdapter((Context)this.getActivity(), R.drawable.zm_group_type_select, context.getString(R.string.zm_accessibility_icon_item_selected_19247));
            } else {
                this.mAdapter.clear();
            }
            this.mAdapter.addAll(items);
            return this.mAdapter;
        }

        private void onSelectItem(int which) {
            ConfMgr confMgr = ConfMgr.getInstance();
            CmmConfStatus cmmConfStatus = confMgr.getConfStatusObj();
            if (cmmConfStatus == null) {
                return;
            }
            if (this.mMode == 0) {
                if (which == 0) {
                    cmmConfStatus.changeAttendeeChatPriviledge(3);
                } else {
                    cmmConfStatus.changeAttendeeChatPriviledge(1);
                }
            } else if (which == 0) {
                if (confMgr.isAllowAttendeeChat()) {
                    confMgr.handleConfCmd(106);
                }
            } else if (which == 1) {
                if (!confMgr.isAllowAttendeeChat()) {
                    confMgr.handleConfCmd(105);
                }
                cmmConfStatus.changeAttendeeChatPriviledge(2);
            } else {
                if (!confMgr.isAllowAttendeeChat()) {
                    confMgr.handleConfCmd(105);
                }
                cmmConfStatus.changeAttendeeChatPriviledge(1);
            }
        }
    }
}

