/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.AvatarView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import us.zoom.androidlib.app.ZMTipFragment;
import us.zoom.androidlib.widget.ZMTip;
import us.zoom.videomeetings.R;

public class MessageTip
extends ZMTipFragment
implements View.OnClickListener {
    private static final int MAX_MESSAGE_TIP_NUMBER = 4;
    public static final String ARG_TITLE = "title";
    public static final String ARG_AVATAR = "avatar";
    public static final String ARG_MESSAGE = "message";
    public static final String ARG_ANCHOR_ID = "anchorId";
    public static final String ARG_MESSAGE_TIP_INDEX = "chatTipIndex";
    private static int gMessageTipIndex = 0;

    public static void show(FragmentManager fragmentMgr, String avatar, String title, String message, int anchorId) {
        if (fragmentMgr == null) {
            return;
        }
        MessageTip.dismissExceedMessageTips(fragmentMgr);
        Bundle args = new Bundle();
        args.putString(ARG_AVATAR, avatar);
        args.putString(ARG_TITLE, title);
        args.putString(ARG_MESSAGE, message);
        args.putInt(ARG_ANCHOR_ID, anchorId);
        args.putInt(ARG_MESSAGE_TIP_INDEX, gMessageTipIndex++);
        MessageTip tip = new MessageTip();
        tip.setArguments(args);
        tip.show(fragmentMgr, MessageTip.class.getName(), 6000L);
        fragmentMgr.executePendingTransactions();
    }

    private static void dismissExceedMessageTips(FragmentManager fragmentMgr) {
        List frags = fragmentMgr.getFragments();
        if (frags != null) {
            ArrayList<MessageTip> msgFrags = new ArrayList<MessageTip>();
            int count = 0;
            for (Fragment f : frags) {
                if (!(f instanceof MessageTip)) continue;
                ++count;
                msgFrags.add((MessageTip)f);
            }
            if (count >= 4) {
                Collections.sort(msgFrags, new MessageTipComparator());
                for (int i = 0; i < msgFrags.size(); ++i) {
                    Fragment f;
                    f = (Fragment)msgFrags.get(i);
                    ((MessageTip)f).dismiss();
                    if (--count < 4) break;
                }
            }
        }
    }

    public static boolean isShown(FragmentManager fragmentMgr) {
        if (fragmentMgr == null) {
            return false;
        }
        MessageTip tip = (MessageTip)fragmentMgr.findFragmentByTag(MessageTip.class.getName());
        return tip != null;
    }

    public static boolean dismiss(FragmentManager fragmentMgr) {
        if (fragmentMgr == null) {
            return false;
        }
        List frags = fragmentMgr.getFragments();
        if (frags == null) {
            return false;
        }
        boolean found = false;
        for (Fragment f : frags) {
            if (!(f instanceof MessageTip)) continue;
            ((MessageTip)f).dismiss();
            found = true;
        }
        return found;
    }

    public ZMTip onCreateTip(Context context, LayoutInflater layoutInflater, Bundle savedInstanceState) {
        View anchor;
        View view = layoutInflater.inflate(R.layout.zm_message_tip, null);
        View contentView = view.findViewById(R.id.content);
        AvatarView avatar = (AvatarView)view.findViewById(R.id.avatarView);
        TextView txtTitle = (TextView)view.findViewById(R.id.txtTitle);
        TextView txtMessage = (TextView)view.findViewById(R.id.txtMessage);
        Bundle args = this.getArguments();
        String avatarSrc = args.getString(ARG_AVATAR);
        avatar.setAvatar(avatarSrc);
        String title = args.getString(ARG_TITLE);
        txtTitle.setText((CharSequence)title);
        txtMessage.setText((CharSequence)args.getString(ARG_MESSAGE));
        ZMTip tip = new ZMTip(context);
        tip.addView(view);
        int anchorId = args.getInt(ARG_ANCHOR_ID, 0);
        if (anchorId > 0 && (anchor = this.getActivity().findViewById(anchorId)) != null) {
            tip.setAnchor(anchor, UIMgr.isLargeMode((Context)this.getActivity()) ? 1 : 3);
        }
        contentView.setOnClickListener((View.OnClickListener)this);
        tip.setBackgroundColor(context.getResources().getColor(R.color.zm_message_tip_background));
        tip.setBorderColor(context.getResources().getColor(R.color.zm_message_tip_border));
        tip.setShadow(4.0f, 0, 0, context.getResources().getColor(R.color.zm_message_tip_shadow));
        return tip;
    }

    public void onClick(View v) {
        this.dismiss();
    }

    public static class MessageTipComparator
    implements Comparator<MessageTip> {
        @Override
        public int compare(MessageTip lhs, MessageTip rhs) {
            Bundle argR;
            long idxL = 0L;
            long idxR = 0L;
            Bundle argL = lhs.getArguments();
            if (argL != null) {
                idxL = argL.getInt(MessageTip.ARG_MESSAGE_TIP_INDEX, 0);
            }
            if ((argR = rhs.getArguments()) != null) {
                idxR = argR.getInt(MessageTip.ARG_MESSAGE_TIP_INDEX, 0);
            }
            return (int)(idxL - idxR);
        }
    }
}

