/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.view.BaseMeetingToolbar;
import com.zipow.videobox.view.ToolbarButton;
import us.zoom.videomeetings.R;

public class MeetingToolbar
extends BaseMeetingToolbar {
    private int mIconSize;

    public MeetingToolbar(Context context) {
        this(context, null);
    }

    public MeetingToolbar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void initView(Context context) {
        View.inflate((Context)context, (int)R.layout.zm_meeting_toolbar, (ViewGroup)this);
        this.mIconSize = this.getResources().getDimensionPixelSize(R.dimen.zm_toolbar_big_size);
        this.mBtnJoin = (ToolbarButton)this.findViewById(R.id.btnJoin);
        this.setToolbar(this.mBtnJoin, this.mIconSize, R.drawable.zm_btn_big_toolbar_blue);
        this.mBtnStart = (ToolbarButton)this.findViewById(R.id.btnStart);
        this.setToolbar(this.mBtnStart, this.mIconSize, R.drawable.zm_btn_big_toolbar_orange);
        this.mBtnUpcoming = (ToolbarButton)this.findViewById(R.id.btnUpcoming);
        this.setToolbar(this.mBtnUpcoming, this.mIconSize, R.drawable.zm_btn_big_toolbar_blue);
        ToolbarButton btnSchedule = (ToolbarButton)this.findViewById(R.id.btnSchedule);
        this.setToolbar(btnSchedule, this.mIconSize, R.drawable.zm_btn_big_toolbar_blue);
        this.mBtnJoin.setOnClickListener(this);
        this.mBtnStart.setOnClickListener(this);
        btnSchedule.setOnClickListener(this);
        this.mBtnUpcoming.setOnClickListener(this);
        this.refresh();
    }

    @Override
    public void refresh() {
        if (PTApp.getInstance().hasActiveCall() && VideoBoxApplication.getInstance().isConfProcessRunning()) {
            this.mBtnStart.setVisibility(8);
            this.mBtnJoin.setImageResource(R.drawable.zm_ic_big_back_meeting);
            this.setToolbar(this.mBtnJoin, this.mIconSize, R.drawable.zm_btn_big_toolbar_orange);
            this.mBtnJoin.setText(R.string.zm_btn_mm_return_to_conf_21854);
        } else {
            this.mBtnStart.setVisibility(0);
            this.mBtnJoin.setImageResource(R.drawable.zm_ic_big_join_meeting);
            this.setToolbar(this.mBtnJoin, this.mIconSize, R.drawable.zm_btn_big_toolbar_blue);
            this.mBtnJoin.setText(R.string.zm_bo_btn_join_bo);
        }
    }
}

