/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import com.zipow.videobox.view.InviteLocalContactsListView;
import com.zipow.videobox.view.LocalContactItem;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.QuickSearchListView;
import us.zoom.videomeetings.R;

public class InviteLocalContactsListAdapter
extends QuickSearchListView.QuickSearchListDataAdapter {
    private static final String TAG = InviteLocalContactsListAdapter.class.getSimpleName();
    private static final int ITEM_TYPE_NORMAL = 0;
    private static final int ITEM_TYPE_ENABLE_ADDRBOOK = 1;
    private List<LocalContactItem> mItems = new ArrayList<LocalContactItem>();
    private Context mContext;
    private InviteLocalContactsListView mListView;
    private String mItemEnableAddrBook = "enableAddrBook";
    private boolean mIsAddrBookEnabled = false;
    private boolean mLazyLoadAvatarDisabled = false;

    public InviteLocalContactsListAdapter(Context context, InviteLocalContactsListView listView) {
        assert (context != null);
        this.mContext = context;
        this.mListView = listView;
    }

    public void setAddrBookEnabled(boolean enabled) {
        this.mIsAddrBookEnabled = enabled;
    }

    public List<LocalContactItem> cache() {
        ArrayList<LocalContactItem> items = new ArrayList<LocalContactItem>();
        items.addAll(this.mItems);
        return items;
    }

    public void setItems(List<LocalContactItem> items) {
        this.mItems.clear();
        this.mItems.addAll(items);
    }

    public void clear() {
        this.mItems.clear();
    }

    public void addItem(LocalContactItem item) {
        assert (item != null);
        this.mItems.add(item);
    }

    public int getCount() {
        if (this.mIsAddrBookEnabled) {
            return this.mItems.size();
        }
        return 1;
    }

    public int getContactsItemCount() {
        return this.mItems.size();
    }

    public Object getItem(int position) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        if (!this.mIsAddrBookEnabled && position == 0) {
            return this.mItemEnableAddrBook;
        }
        return this.mItems.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        if (!this.mIsAddrBookEnabled && position == 0) {
            return 1;
        }
        return 0;
    }

    public int getViewTypeCount() {
        return 2;
    }

    public void setLazyLoadAvatarDisabled(boolean disabled) {
        this.mLazyLoadAvatarDisabled = disabled;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (position < 0 || position >= this.getCount()) {
            View view = new View(this.mContext);
            return view;
        }
        Object obj = this.getItem(position);
        if (obj instanceof LocalContactItem) {
            LocalContactItem item = (LocalContactItem)obj;
            return item.getView(this.mContext, convertView, this.mListView, this.mLazyLoadAvatarDisabled);
        }
        if (this.mItemEnableAddrBook.equals(obj)) {
            return this.getEnableAddrbookView(this.mContext, convertView, parent);
        }
        View view = new View(this.mContext);
        return view;
    }

    private View getEnableAddrbookView(Context context, View convertView, ViewGroup parent) {
        if (context == null) {
            return null;
        }
        View view = null;
        if (convertView != null && "enableAddrBook".equals(convertView.getTag())) {
            view = convertView;
        } else {
            LayoutInflater factory = LayoutInflater.from((Context)context);
            view = factory.inflate(R.layout.zm_addrbook_item_enable_addrbook_matching, parent, false);
            view.setTag((Object)"enableAddrBook");
        }
        Button btnEnable = (Button)view.findViewById(R.id.btnEnable);
        if (btnEnable != null) {
            btnEnable.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    InviteLocalContactsListAdapter.this.mListView.onClickBtnEnableAddrBook();
                }
            });
        }
        return view;
    }

    public void filter(String filter) {
        this.filter(this.mItems, filter);
    }

    private void filter(List<LocalContactItem> list, String filter) {
        for (int i = list.size() - 1; i >= 0; --i) {
            LocalContactItem item = list.get(i);
            String screenName = item.getScreenName();
            if (!StringUtil.isEmptyOrNull((String)screenName) && screenName.toLowerCase(CompatUtils.getLocalDefault()).contains(filter)) continue;
            list.remove(i);
        }
    }

    public String getItemSortKey(Object item) {
        if (item instanceof LocalContactItem) {
            LocalContactItem abItem = (LocalContactItem)item;
            String key = abItem.getSortKey();
            if (key == null) {
                key = "";
            }
            return key;
        }
        return "*";
    }

    public void sort() {
        Collections.sort(this.mItems, new LocalContactItemComparator(CompatUtils.getLocalDefault()));
    }

    static class LocalContactItemComparator
    implements Comparator<LocalContactItem> {
        private Collator mCollator;

        public LocalContactItemComparator(Locale locale) {
            this.mCollator = Collator.getInstance(locale);
            this.mCollator.setStrength(0);
        }

        @Override
        public int compare(LocalContactItem lhs, LocalContactItem rhs) {
            if (lhs == rhs) {
                return 0;
            }
            if (lhs.getIsZoomUser() && !rhs.getIsZoomUser()) {
                return 1;
            }
            if (!lhs.getIsZoomUser() && rhs.getIsZoomUser()) {
                return -1;
            }
            String str1 = lhs.getSortKey();
            String str2 = rhs.getSortKey();
            if (str1 == null) {
                str1 = "";
            }
            if (str2 == null) {
                str2 = "";
            }
            return this.mCollator.compare(str1, str2);
        }
    }
}

