/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import com.zipow.videobox.ptapp.ABContactsCache;
import com.zipow.videobox.ptapp.ABContactsHelper;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.ZoomContact;
import com.zipow.videobox.ptapp.delegate.FavoriteMgrDelegation;
import com.zipow.videobox.ptapp.delegate.PTAppDelegation;
import com.zipow.videobox.ptapp.delegate.PTBuddyHelperDelegation;
import com.zipow.videobox.ptapp.mm.BuddyNameUtil;
import com.zipow.videobox.ptapp.mm.ZMSortUtil;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomBuddySearchData;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.IMBuddyItemComparator;
import com.zipow.videobox.util.MemCache;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.InviteBuddyItem;
import com.zipow.videobox.view.InviteBuddyListAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.QuickSearchListView;
import us.zoom.videomeetings.R;

public class InviteBuddyListView
extends QuickSearchListView
implements AdapterView.OnItemClickListener {
    private static final String TAG = InviteBuddyListView.class.getSimpleName();
    private InviteBuddyListAdapter mAdapter;
    private Listener mListener;
    private String mFilter;
    private Button mBtnSearchMore;
    private List<InviteBuddyItem> mSelectedItems = new ArrayList<InviteBuddyItem>();
    private WebSearchResult mWebSearchResult = new WebSearchResult();
    private RetainedFragment mRetainedFragment;
    private int mLastTopPosition = 0;
    private boolean mIsInviteAddrBook = false;
    private static final int MAX_ADDRBOOKITEM_COUNT_FOR_NO_FILTER = 250;
    private boolean mIsInviteZoomRooms = false;

    public InviteBuddyListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public InviteBuddyListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public InviteBuddyListView(Context context) {
        super(context);
        this.initView();
    }

    public void setIsInviteAddrBook(boolean bInviteAddrBook) {
        this.mIsInviteAddrBook = bInviteAddrBook;
        this.mIsInviteZoomRooms = false;
    }

    public void setIsInviteZoomRooms(boolean bInviteZoomRooms) {
        this.mIsInviteAddrBook = true;
        this.mIsInviteZoomRooms = bInviteZoomRooms;
    }

    private void initView() {
        this.mAdapter = new InviteBuddyListAdapter(this.getContext());
        this.setOnItemClickListener(this);
        this.initAddMoreFooter();
        if (!this.isInEditMode()) {
            this.initRetainedFragment();
        }
    }

    private void _editmode_loadAllBuddyItems(InviteBuddyListAdapter adapter) {
        for (int i = 0; i < 20; ++i) {
            InviteBuddyItem item = new InviteBuddyItem();
            item.sortKey = item.screenName = "Buddy " + i;
            item.userId = String.valueOf(i);
            item.isChecked = i % 2 == 0;
            adapter.addItem(item);
        }
    }

    private void loadAllBuddyItems(InviteBuddyListAdapter adapter) {
        if (this.mIsInviteAddrBook) {
            this.setQuickSearchEnabled(true);
            this.loadAllAddrBookItems(adapter);
        } else {
            switch (PTAppDelegation.getInstance().getPTLoginType()) {
                case 100: 
                case 101: {
                    this.setQuickSearchEnabled(true);
                    this.loadAllZoomFavoriteItems(adapter);
                    break;
                }
                case 0: 
                case 2: {
                    this.setQuickSearchEnabled(false);
                    this.loadAllIMBuddyItems(adapter);
                }
            }
        }
    }

    private void initAddMoreFooter() {
        View footer = View.inflate((Context)this.getContext(), (int)R.layout.zm_search_view_more, null);
        this.mBtnSearchMore = (Button)footer.findViewById(R.id.btnSearchMore);
        this.mBtnSearchMore.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InviteBuddyListView.this.mListener.onViewMoreClick();
            }
        });
        this.mBtnSearchMore.setVisibility(8);
        this.getListView().addFooterView(footer);
    }

    private void updateViewMore() {
        if (!this.mIsInviteAddrBook) {
            this.mBtnSearchMore.setVisibility(8);
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null || !messenger.isConnectionGood()) {
            return;
        }
        if (!StringUtil.isEmptyOrNull((String)this.mFilter) && this.mFilter.length() >= 3) {
            this.mBtnSearchMore.setVisibility(0);
        } else {
            this.mBtnSearchMore.setVisibility(8);
        }
    }

    private void loadAllIMBuddyItems(InviteBuddyListAdapter adapter) {
        long timeStart = System.currentTimeMillis();
        PTBuddyHelperDelegation buddyHelper = PTAppDelegation.getInstance().getBuddyHelper();
        int count = buddyHelper.getBuddyItemCount();
        if (this.mFilter != null && this.mFilter.length() > 0) {
            String lowerFilter = this.mFilter.toLowerCase(CompatUtils.getLocalDefault());
            for (int i = 0; i < count; ++i) {
                PTAppProtos.BuddyItem protoItem = buddyHelper.getBuddyItem(i);
                if (protoItem == null || protoItem.getIsPending() || protoItem.getIsNoneFriend()) continue;
                String name = protoItem.getScreenName();
                if (name == null) {
                    name = "";
                }
                if (name.toLowerCase(CompatUtils.getLocalDefault()).indexOf(lowerFilter) < 0) continue;
                InviteBuddyItem item = new InviteBuddyItem(protoItem);
                item.isChecked = this.isBuddySelected(item.userId);
                adapter.addItem(item);
            }
        } else {
            for (int i = 0; i < count; ++i) {
                PTAppProtos.BuddyItem protoItem = buddyHelper.getBuddyItem(i);
                if (protoItem == null || !protoItem.getIsOnline() || protoItem.getIsPending() || protoItem.getIsNoneFriend()) continue;
                InviteBuddyItem item = new InviteBuddyItem(protoItem);
                item.isChecked = this.isBuddySelected(item.userId);
                adapter.addItem(item);
            }
        }
        adapter.sort();
    }

    private void loadAllZoomFavoriteItems(InviteBuddyListAdapter adapter) {
        FavoriteMgrDelegation favMgr = PTAppDelegation.getInstance().getFavoriteMgr();
        if (favMgr == null) {
            return;
        }
        ArrayList<ZoomContact> contacts = new ArrayList<ZoomContact>();
        if (favMgr.getFavoriteListWithFilter("", contacts)) {
            String lowerFilter = "";
            if (this.mFilter != null && this.mFilter.length() > 0) {
                lowerFilter = this.mFilter.toLowerCase(CompatUtils.getLocalDefault());
            }
            for (ZoomContact contact : contacts) {
                String email;
                InviteBuddyItem item = new InviteBuddyItem(contact);
                String name = item.screenName != null ? item.screenName : "";
                String string2 = email = item.email != null ? item.email : "";
                if (lowerFilter.length() > 0 && name.toLowerCase(CompatUtils.getLocalDefault()).indexOf(lowerFilter) < 0 && email.toLowerCase(CompatUtils.getLocalDefault()).indexOf(lowerFilter) < 0) continue;
                item.isChecked = this.isBuddySelected(item.userId);
                adapter.addItem(item);
            }
        }
        adapter.sort();
    }

    private void loadAllAddrBookItems(InviteBuddyListAdapter adapter) {
        ZoomMessenger messenger;
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        ABContactsCache cache = null;
        String myNumber = null;
        if (PTApp.getInstance().isPhoneNumberRegistered()) {
            cache = ABContactsCache.getInstance();
            if (!cache.isCached() && !cache.reloadAllContacts()) {
                return;
            }
            ABContactsHelper contactsHelper = PTApp.getInstance().getABContactsHelper();
            if (contactsHelper != null) {
                myNumber = contactsHelper.getVerifiedPhoneNumber();
            }
        }
        if ((messenger = PTApp.getInstance().getZoomMessenger()) == null) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)this.mFilter)) {
            for (int i = 0; i < messenger.getBuddyCount(); ++i) {
                ZoomBuddy buddy = messenger.getBuddyAt(i);
                if (buddy == null || buddy.isPending() || buddy.isRobot()) continue;
                InviteBuddyItem buddyItem = this.newInviteBuddyItemFromBuddy(messenger, buddy, myNumber);
                if (buddyItem != null) {
                    buddyItem.isChecked = this.isBuddySelected(buddyItem.userId);
                    if (this.mIsInviteZoomRooms) {
                        IMAddrBookItem addrBookItem = buddyItem.getAddrBookItem();
                        if (addrBookItem != null && addrBookItem.isZoomRoomContact()) {
                            adapter.addItem(buddyItem);
                        }
                    } else {
                        adapter.addItem(buddyItem);
                    }
                }
                if (adapter.getCount() < 250) {
                    continue;
                }
                break;
            }
        } else {
            ZoomBuddy buddy;
            List<String> localBuddies = messenger.localStrictSearchBuddies(this.mFilter, null);
            for (String jid : localBuddies) {
                IMAddrBookItem addrItem;
                buddy = messenger.getBuddyWithJID(jid);
                if (buddy == null || buddy.isRobot() || (addrItem = IMAddrBookItem.fromZoomBuddy(buddy)) == null) continue;
                InviteBuddyItem item = new InviteBuddyItem(addrItem);
                item.isChecked = this.isBuddySelected(item.userId);
                if (this.mIsInviteZoomRooms) {
                    IMAddrBookItem addrBookItem = item.getAddrBookItem();
                    if (addrBookItem != null && addrBookItem.isZoomRoomContact()) {
                        adapter.addItem(item);
                    }
                } else {
                    this.mAdapter.addItem(item);
                }
                if (adapter.getCount() < 250) continue;
                break;
            }
            if (this.mWebSearchResult != null && StringUtil.isSameString((String)this.mWebSearchResult.key, (String)this.mFilter)) {
                for (String jid : this.mWebSearchResult.getAllJids()) {
                    buddy = messenger.getBuddyWithJID(jid);
                    if (buddy != null && !buddy.isRobot()) {
                        InviteBuddyItem contact = this.mWebSearchResult.findByJid(jid);
                        if (contact == null) {
                            IMAddrBookItem addrItem = IMAddrBookItem.fromZoomBuddy(buddy);
                            if (addrItem == null) continue;
                            contact = new InviteBuddyItem(addrItem);
                        }
                        this.mAdapter.updateItem(contact);
                        if (this.mAdapter.getCount() >= 250) break;
                    }
                    this.mBtnSearchMore.setVisibility(8);
                }
            }
        }
        adapter.sort();
    }

    private IMAddrBookItem newAddrBookItem(ZoomBuddy buddy) {
        IMAddrBookItem item = IMAddrBookItem.fromZoomBuddy(buddy);
        return item;
    }

    private InviteBuddyItem newInviteBuddyItemFromBuddy(ZoomMessenger messenger, ZoomBuddy buddy, String myNumber) {
        String number;
        IMAddrBookItem item = this.newAddrBookItem(buddy);
        if (item == null) {
            return null;
        }
        String name = BuddyNameUtil.getBuddyDisplayName(buddy, null);
        String normalizedNumber = number = buddy.getPhoneNumber();
        String email = buddy.getEmail();
        if (!StringUtil.isSameString((String)this.mWebSearchResult.key, (String)this.mFilter) || this.mWebSearchResult.findByJid(buddy.getJid()) == null) {
            boolean isBuddy;
            if (!StringUtil.isEmptyOrNull((String)myNumber) && myNumber.equals(normalizedNumber)) {
                return null;
            }
            if (this.mFilter != null && this.mFilter.length() > 0) {
                String lowerEmail;
                String lowerFilter = this.mFilter.toLowerCase(CompatUtils.getLocalDefault());
                String lowerName = name == null ? "" : name.toLowerCase(CompatUtils.getLocalDefault());
                String string2 = lowerEmail = email == null ? "" : email.toLowerCase(CompatUtils.getLocalDefault());
                if (!lowerName.contains(lowerFilter) && !lowerEmail.contains(lowerFilter)) {
                    return null;
                }
            }
            boolean bl = isBuddy = messenger.isMyContact(buddy.getJid()) && !buddy.isNoneFriend();
            if (!isBuddy && item.getContactId() < 0) {
                return null;
            }
        }
        InviteBuddyItem buddyItem = new InviteBuddyItem(item);
        buddyItem.isChecked = this.isAddrBookItemSelected(item);
        buddyItem.avatar = item.getAvatarPath();
        return buddyItem;
    }

    public void updateBuddyItem(PTAppProtos.BuddyItem protoItem) {
        if (protoItem == null) {
            return;
        }
        if (this.mIsInviteAddrBook) {
            return;
        }
        if (this.mFilter != null && this.mFilter.length() > 0) {
            String name = protoItem.getScreenName();
            if (StringUtil.isEmptyOrNull((String)name)) {
                return;
            }
            String lowerFilter = this.mFilter.toLowerCase(CompatUtils.getLocalDefault());
            if (protoItem.getIsOnline() && name.toLowerCase(CompatUtils.getLocalDefault()).indexOf(lowerFilter) >= 0) {
                InviteBuddyItem item = new InviteBuddyItem(protoItem);
                InviteBuddyItem oldItem = this.mAdapter.getItemByJid(item.userId);
                this.mAdapter.updateItem(item);
                if (oldItem != null && oldItem.isChecked) {
                    this.addSelectedItem(item);
                    if (this.mListener != null) {
                        this.mListener.onSelectionChanged();
                    }
                }
                this.mAdapter.sort();
            } else {
                this.mAdapter.removeItem(protoItem.getJid());
            }
            this.mAdapter.notifyDataSetChanged();
        } else {
            if (protoItem.getIsOnline()) {
                InviteBuddyItem item = new InviteBuddyItem(protoItem);
                InviteBuddyItem oldItem = this.mAdapter.getItemByJid(item.userId);
                this.mAdapter.updateItem(item);
                if (oldItem != null && oldItem.isChecked) {
                    this.addSelectedItem(item);
                    if (this.mListener != null) {
                        this.mListener.onSelectionChanged();
                    }
                }
                this.mAdapter.sort();
            } else {
                this.mAdapter.removeItem(protoItem.getJid());
            }
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void sort() {
        this.mAdapter.sort();
        this.mAdapter.notifyDataSetChanged();
    }

    public void setAvatarMemCache(MemCache<String, Bitmap> avatarCache) {
        this.mAdapter.setAvatarMemCache(avatarCache);
    }

    private boolean isBuddySelected(String jid) {
        if (jid == null) {
            return false;
        }
        for (InviteBuddyItem item : this.mSelectedItems) {
            if (!jid.equals(item.userId)) continue;
            return true;
        }
        return false;
    }

    private boolean isAddrBookItemSelected(IMAddrBookItem abItem) {
        if (abItem == null) {
            return false;
        }
        for (InviteBuddyItem item : this.mSelectedItems) {
            IMAddrBookItem abItemTmp = item.getAddrBookItem();
            if (abItemTmp == null || !StringUtil.isSameString((String)abItemTmp.getJid(), (String)abItem.getJid())) continue;
            return true;
        }
        return false;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isInEditMode()) {
            this._editmode_loadAllBuddyItems(this.mAdapter);
        }
        this.setAdapter(this.mAdapter);
        if (this.mLastTopPosition >= 0) {
            this.setSelectionFromTop(this.mLastTopPosition, 0);
        }
    }

    public void onRestoreInstanceState(Parcelable state) {
        Parcelable superState = null;
        if (state instanceof Bundle) {
            Bundle allState = (Bundle)state;
            superState = allState.getParcelable("InviteBuddyListView.superState");
            this.mFilter = allState.getString("InviteBuddyListView.mFilter");
            this.mLastTopPosition = allState.getInt("InviteBuddyListView.topPosition", -1);
            this.updateViewMore();
        } else {
            superState = state;
        }
        super.onRestoreInstanceState(superState);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle bundle = new Bundle();
        bundle.putParcelable("InviteBuddyListView.superState", superState);
        bundle.putString("InviteBuddyListView.mFilter", this.mFilter);
        bundle.putInt("InviteBuddyListView.topPosition", this.pointToPosition(10, 10));
        return bundle;
    }

    public void setListener(Listener l) {
        this.mListener = l;
    }

    public void reloadAllBuddyItems() {
        long timeStart = System.currentTimeMillis();
        this.mAdapter.clear();
        this.loadAllBuddyItems(this.mAdapter);
        this.mAdapter.notifyDataSetChanged();
    }

    public void clearSelection() {
        this.mSelectedItems.clear();
        for (int index = 0; index < this.mAdapter.getCount(); ++index) {
            InviteBuddyItem item = (InviteBuddyItem)this.mAdapter.getItem(index);
            if (item != null) {
                item.isChecked = false;
            }
            this.mAdapter.notifyDataSetChanged();
        }
        if (this.mListener != null) {
            this.mListener.onSelectionChanged();
        }
    }

    public List<InviteBuddyItem> getSelectedBuddies() {
        return this.mSelectedItems;
    }

    public void unselectBuddy(InviteBuddyItem item) {
        if (item != null) {
            InviteBuddyItem listItem = this.mAdapter.getItemByJid(item.userId);
            if (listItem != null) {
                listItem.isChecked = false;
                this.mAdapter.notifyDataSetChanged();
            }
            this.removeSelectedItem(item);
            if (this.mListener != null) {
                this.mListener.onSelectionChanged();
            }
        }
    }

    public void filter(String filter) {
        if (filter == null) {
            filter = "";
        }
        filter = filter.trim().toLowerCase(CompatUtils.getLocalDefault());
        String oldFilter = this.mFilter;
        this.mFilter = filter;
        if (oldFilter == null) {
            oldFilter = "";
        }
        if (oldFilter.equals(filter)) {
            return;
        }
        if (!StringUtil.isEmptyOrNull((String)filter) && !this.mIsInviteAddrBook) {
            if (!StringUtil.isEmptyOrNull((String)oldFilter) && filter.contains(oldFilter)) {
                this.mAdapter.filter(filter);
                this.mAdapter.notifyDataSetChanged();
            } else {
                this.reloadAllBuddyItems();
            }
        } else {
            this.mWebSearchResult.clear();
            this.reloadAllBuddyItems();
        }
        this.updateViewMore();
    }

    public void setFilter(String filter) {
        this.mFilter = filter;
        this.updateViewMore();
    }

    public String getFilter() {
        return this.mFilter;
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Object obj = this.getItemAtPosition(position);
        if (obj == null || !(obj instanceof InviteBuddyItem)) {
            return;
        }
        InviteBuddyItem item = (InviteBuddyItem)obj;
        item.isChecked = !item.isChecked;
        this.mAdapter.notifyDataSetChanged();
        if (item.isChecked) {
            this.addSelectedItem(item);
        } else {
            this.removeSelectedItem(item);
        }
        if (this.mListener != null) {
            this.mListener.onSelectionChanged();
        }
    }

    private void removeSelectedItem(InviteBuddyItem item) {
        for (int i = this.mSelectedItems.size() - 1; i >= 0; --i) {
            InviteBuddyItem tmpItem = this.mSelectedItems.get(i);
            if (item.userId == null || !item.userId.equals(tmpItem.userId)) continue;
            this.mSelectedItems.remove(i);
            if (this.mListener == null) break;
            this.mListener.onSelected(false, tmpItem);
            break;
        }
    }

    private void addSelectedItem(InviteBuddyItem item) {
        item.isChecked = true;
        for (int i = this.mSelectedItems.size() - 1; i >= 0; --i) {
            InviteBuddyItem tmpItem = this.mSelectedItems.get(i);
            if (item.userId == null || !item.userId.equals(tmpItem.userId)) continue;
            this.mSelectedItems.set(i, item);
            return;
        }
        this.mSelectedItems.add(item);
        if (this.mListener != null) {
            this.mListener.onSelected(true, item);
        }
        Collections.sort(this.mSelectedItems, new IMBuddyItemComparator(CompatUtils.getLocalDefault(), false, true));
    }

    public void notifyDataSetChanged(boolean disableLazyLoadAvatar) {
        if (this.mAdapter != null) {
            if (disableLazyLoadAvatar) {
                this.mAdapter.setLazyLoadAvatarDisabled(true);
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        InviteBuddyListView.this.mAdapter.setLazyLoadAvatarDisabled(false);
                    }
                }, 1000L);
            }
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void onIndicationZoomMessengerSearchBuddyByKey(String key, int result) {
        ZoomBuddy mySelf;
        if (!StringUtil.isSameString((String)key, (String)this.mFilter)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        HashSet<String> buddies = new HashSet<String>();
        List<String> localBuddies = messenger.localStrictSearchBuddies(this.mFilter, null);
        if (localBuddies != null && localBuddies.size() > 0 && messenger.isAnyBuddyGroupLarge()) {
            messenger.getBuddiesPresence(localBuddies, false);
        }
        if (localBuddies != null) {
            buddies.addAll(localBuddies);
        }
        this.mWebSearchResult.key = this.mFilter;
        ZoomBuddySearchData searchData = messenger.getBuddySearchData();
        if (searchData != null) {
            ZoomBuddySearchData.SearchKey searchKey = searchData.getSearchKey();
            ArrayList<String> webSearched = new ArrayList<String>();
            if (searchKey != null && TextUtils.equals((CharSequence)searchData.getSearchKey().getKey(), (CharSequence)this.mFilter)) {
                for (int i = 0; i < searchData.getBuddyCount(); ++i) {
                    ZoomBuddy buddy = searchData.getBuddyAt(i);
                    if (buddy == null || buddies.contains(buddy.getJid())) continue;
                    String jid = buddy.getJid();
                    webSearched.add(jid);
                    this.mWebSearchResult.putInviteBuddyItem(jid, new InviteBuddyItem(IMAddrBookItem.fromZoomBuddy(buddy)));
                }
                messenger.getBuddiesPresence(webSearched, false);
                buddies.addAll(webSearched);
            }
        }
        List<String> sorted = null;
        ArrayList<String> source = new ArrayList<String>();
        source.addAll(buddies);
        sorted = ZMSortUtil.sortBuddies(source, 0, this.mFilter);
        if (sorted != null && sorted.size() > 0 && (mySelf = messenger.getMyself()) != null) {
            for (String jid : sorted) {
                ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
                if (buddy == null) continue;
                InviteBuddyItem item = this.mWebSearchResult.findByJid(jid);
                if (item == null) {
                    item = new InviteBuddyItem(IMAddrBookItem.fromZoomBuddy(buddy));
                }
                item.isChecked = this.isBuddySelected(item.userId);
                item.avatar = item.avatar;
                if (this.mIsInviteZoomRooms) {
                    IMAddrBookItem addrBookItem = item.getAddrBookItem();
                    if (addrBookItem != null && addrBookItem.isZoomRoomContact()) {
                        this.mAdapter.updateItem(item);
                    }
                } else {
                    this.mAdapter.updateItem(item);
                }
                if (this.mAdapter.getCount() < 250) continue;
                break;
            }
        }
        this.mAdapter.notifyDataSetChanged();
        this.mBtnSearchMore.setVisibility(8);
    }

    public void onIndicateZoomMessengerOnlineBuddies(List<String> jidList) {
        if (jidList == null || jidList.size() == 0) {
            return;
        }
        for (String jid : jidList) {
            InviteBuddyItem item = this.mAdapter.getItemByJid(jid);
            if (item == null) continue;
            this.updateBuddyInfoWithJid(jid);
        }
    }

    public void onIndicateZoomMessengerGetContactsPresence(List<String> onLines, List<String> offLines) {
        InviteBuddyItem item;
        if (onLines != null && onLines.size() > 0) {
            for (String jid : onLines) {
                item = this.mAdapter.getItemByJid(jid);
                if (item == null) continue;
                this.updateBuddyInfoWithJid(jid);
            }
        }
        if (offLines != null && offLines.size() > 0) {
            for (String jid : offLines) {
                item = this.mAdapter.getItemByJid(jid);
                if (item == null) continue;
                this.updateBuddyInfoWithJid(jid);
            }
        }
    }

    public void updateBuddyInfoWithJid(String jid) {
        ABContactsHelper contactsHelper;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
        if (buddy == null) {
            return;
        }
        String myNumber = null;
        if (PTApp.getInstance().isPhoneNumberRegistered() && (contactsHelper = PTApp.getInstance().getABContactsHelper()) != null) {
            myNumber = contactsHelper.getVerifiedPhoneNumber();
        }
        this.mAdapter.removeItem(buddy.getJid());
        InviteBuddyItem item = this.newInviteBuddyItemFromBuddy(messenger, buddy, myNumber);
        if (item != null) {
            if (this.mIsInviteZoomRooms) {
                IMAddrBookItem addrBookItem = item.getAddrBookItem();
                if (addrBookItem != null && addrBookItem.isZoomRoomContact()) {
                    this.mAdapter.addItem(item);
                }
            } else {
                this.mAdapter.addItem(item);
            }
            if (this.mWebSearchResult.findByJid(jid) != null) {
                this.mWebSearchResult.putInviteBuddyItem(jid, item);
            }
        }
        this.notifyDataSetChanged(true);
    }

    private void initRetainedFragment() {
        this.mRetainedFragment = this.getRetainedFragment();
        if (this.mRetainedFragment == null) {
            this.mRetainedFragment = new RetainedFragment();
            this.mRetainedFragment.saveSelectedItems(this.mSelectedItems);
            this.mRetainedFragment.saveWebSearchResult(this.mWebSearchResult);
            ((ZMActivity)this.getContext()).getSupportFragmentManager().beginTransaction().add((Fragment)this.mRetainedFragment, RetainedFragment.class.getName()).commit();
        } else {
            WebSearchResult oldSearchResult;
            List<InviteBuddyItem> oldItems = this.mRetainedFragment.restoreSelectedItems();
            if (oldItems != null) {
                this.mSelectedItems = oldItems;
            }
            if ((oldSearchResult = this.mRetainedFragment.restoreWebSearchResult()) != null) {
                this.mWebSearchResult = oldSearchResult;
            }
        }
        this.mRetainedFragment.setParentListView(this);
    }

    private RetainedFragment getRetainedFragment() {
        if (this.mRetainedFragment != null) {
            return this.mRetainedFragment;
        }
        FragmentManager fm = ((ZMActivity)this.getContext()).getSupportFragmentManager();
        RetainedFragment retainedFragment = (RetainedFragment)fm.findFragmentByTag(RetainedFragment.class.getName());
        return retainedFragment;
    }

    static class WebSearchResult {
        String key;
        Map<String, InviteBuddyItem> results = new HashMap<String, InviteBuddyItem>();

        WebSearchResult() {
        }

        public InviteBuddyItem findByJid(String jid) {
            return this.results.get(jid);
        }

        public Set<String> getAllJids() {
            return this.results.keySet();
        }

        public void putInviteBuddyItem(String jid, InviteBuddyItem item) {
            this.results.put(jid, item);
        }

        public void clear() {
            this.key = null;
            this.results.clear();
        }
    }

    public static class RetainedFragment
    extends ZMFragment
    implements ABContactsCache.IABContactsCacheListener {
        private List<InviteBuddyItem> mSelectedItems = null;
        private WebSearchResult mWebSearchResult = null;
        private InviteBuddyListView mListView = null;

        public RetainedFragment() {
            this.setRetainInstance(true);
        }

        public void setParentListView(InviteBuddyListView listView) {
            this.mListView = listView;
        }

        public void onActivityCreated(Bundle savedInstanceState) {
            super.onActivityCreated(savedInstanceState);
            ABContactsCache.getInstance().addListener(this);
        }

        public void onDestroy() {
            super.onDestroy();
            ABContactsCache.getInstance().removeListener(this);
        }

        public void saveSelectedItems(List<InviteBuddyItem> items) {
            this.mSelectedItems = items;
        }

        public List<InviteBuddyItem> restoreSelectedItems() {
            return this.mSelectedItems;
        }

        public void saveWebSearchResult(WebSearchResult items) {
            this.mWebSearchResult = items;
        }

        public WebSearchResult restoreWebSearchResult() {
            return this.mWebSearchResult;
        }

        @Override
        public void onContactsCacheUpdated() {
            if (this.isResumed() && this.mListView != null) {
                this.mListView.reloadAllBuddyItems();
            }
        }
    }

    public static interface Listener {
        public void onSelectionChanged();

        public void onViewMoreClick();

        public void onSelected(boolean var1, InviteBuddyItem var2);
    }
}

