/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckedTextView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.util.MemCache;
import com.zipow.videobox.util.ZMBitmapFactory;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.InviteBuddyItem;
import com.zipow.videobox.view.PresenceStateView;
import java.io.File;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class InviteBuddyItemView
extends LinearLayout {
    private InviteBuddyItem mItem;
    private TextView mTxtScreenName;
    private TextView mTxtEmail;
    private AvatarView mAvatarView;
    private CheckedTextView mCheckbox;
    private PresenceStateView mPresenceStateView;
    private Handler mHandler = new Handler();

    public InviteBuddyItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public InviteBuddyItemView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.inflateLayout();
        this.mTxtScreenName = (TextView)this.findViewById(R.id.txtScreenName);
        this.mTxtEmail = (TextView)this.findViewById(R.id.txtEmail);
        this.mAvatarView = (AvatarView)this.findViewById(R.id.avatarView);
        this.mCheckbox = (CheckedTextView)this.findViewById(R.id.check);
        this.mPresenceStateView = (PresenceStateView)this.findViewById(R.id.presenceStateView);
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_invite_buddy_item, (ViewGroup)this);
    }

    public void setScreenName(CharSequence name) {
        if (name != null && this.mTxtScreenName != null) {
            this.mTxtScreenName.setText(name);
        }
        if (this.mAvatarView != null) {
            this.mAvatarView.setName(name);
        }
    }

    public void setEmail(String email) {
        if (this.mTxtEmail != null) {
            if (email != null) {
                this.mTxtEmail.setText((CharSequence)email);
                this.mTxtEmail.setVisibility(0);
            } else {
                this.mTxtEmail.setVisibility(8);
            }
        }
    }

    public void setAvatar(String imgPathName, int presence) {
        if (this.mAvatarView != null) {
            this.mAvatarView.setAvatar(imgPathName, presence);
        }
    }

    private void setAvatar(Bitmap bitmap, int presence) {
        if (this.mAvatarView != null) {
            this.mAvatarView.setAvatar(bitmap, presence);
        }
    }

    private void setChecked(boolean bChecked) {
        if (this.mCheckbox != null) {
            this.mCheckbox.setChecked(bChecked);
        }
    }

    public void setBuddyListItem(InviteBuddyItem item, MemCache<String, Bitmap> avatarCache, boolean disableLazyloadAvatar) {
        if (item == null) {
            return;
        }
        this.mItem = item;
        String name = this.mItem.screenName;
        if (StringUtil.isEmptyOrNull((String)name)) {
            name = this.mItem.email;
            this.setEmail(null);
        } else {
            this.setEmail(this.mItem.email);
        }
        this.setScreenName(name);
        if (this.mAvatarView != null) {
            this.mAvatarView.setBgColorSeedString(this.mItem.userId);
        }
        if (this.mItem.isAddrBookItem()) {
            if (!this.mItem.isPresenceSupported) {
                this.mPresenceStateView.setVisibility(8);
                return;
            }
            IMAddrBookItem abItem = this.mItem.getAddrBookItem();
            this.mPresenceStateView.setState(abItem);
        } else {
            if (!this.mItem.isPresenceSupported) {
                this.mPresenceStateView.setVisibility(8);
                return;
            }
            if (this.mPresenceStateView.setState(this.mItem.presence)) {
                this.mTxtScreenName.setTextColor(this.getResources().getColor(R.color.zm_im_buddyname_online));
            } else {
                this.mTxtScreenName.setTextColor(this.getResources().getColor(R.color.zm_im_buddyname_offline));
            }
        }
        this.setChecked(this.mItem.isChecked);
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        if (disableLazyloadAvatar) {
            this.loadAvatar(this.mItem, context, false, avatarCache);
        } else if (!this.loadAvatar(this.mItem, context, true, avatarCache)) {
            this.lazyLoadAvatar(this.mItem, context, avatarCache);
        }
    }

    private void lazyLoadAvatar(final InviteBuddyItem item, final Context context, final MemCache<String, Bitmap> avatarCache) {
        this.setAvatar((String)null, item.isAddrBookItem() ? 0 : item.presence);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (InviteBuddyItemView.this.mItem != item) {
                    return;
                }
                InviteBuddyItemView.this.loadAvatar(item, context, false, avatarCache);
            }
        }, 300L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean loadAvatar(InviteBuddyItem item, Context context, boolean fromMemCacheOnly, MemCache<String, Bitmap> avatarCache) {
        Bitmap bitmap;
        String avatar = item.avatar;
        if (StringUtil.isEmptyOrNull((String)avatar)) {
            Bitmap bitmap2;
            if (!item.isAddrBookItem()) return true;
            IMAddrBookItem abItem = item.getAddrBookItem();
            if (abItem == null) return false;
            if (avatarCache != null && (bitmap2 = avatarCache.getCachedItem(String.valueOf(abItem.getContactId()))) != null) {
                this.setAvatar(bitmap2, this.getItemPresence(item));
                return true;
            }
            bitmap2 = abItem.getAvatarBitmap(context, fromMemCacheOnly);
            this.setAvatar(bitmap2, this.getItemPresence(item));
            if (bitmap2 == null) return false;
            if (avatarCache == null) return true;
            avatarCache.cacheItem(String.valueOf(abItem.getContactId()), bitmap2);
            return true;
        }
        if (avatarCache != null && (bitmap = avatarCache.getCachedItem(avatar)) != null) {
            this.setAvatar(bitmap, this.getItemPresence(item));
            return true;
        }
        File file = new File(avatar);
        if (!file.exists() || !file.isFile()) return false;
        Bitmap bitmap3 = ZMBitmapFactory.decodeFile(avatar, fromMemCacheOnly);
        if (bitmap3 != null) {
            this.setAvatar(bitmap3, this.getItemPresence(item));
            if (avatarCache == null) return true;
            avatarCache.cacheItem(avatar, bitmap3);
            return true;
        }
        this.setAvatar((Bitmap)null, this.getItemPresence(item));
        return false;
    }

    private int getItemPresence(InviteBuddyItem item) {
        return item.isAddrBookItem() ? 0 : item.presence;
    }
}

