/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.content.res.Configuration;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.view.ViewGroup;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.fragment.IMAddrBookListFragment;
import com.zipow.videobox.fragment.IMBuddyListFragment;
import com.zipow.videobox.fragment.IMFavoriteListFragment;
import com.zipow.videobox.fragment.IMMeetingFragment;
import com.zipow.videobox.fragment.MMChatsListFragment;
import com.zipow.videobox.fragment.SettingFragment;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomProductHelper;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.sip.server.SipCallManager;
import com.zipow.videobox.view.mm.MMContentFragment;
import com.zipow.videobox.view.sip.PhoneCallFragment;
import java.util.ArrayList;
import us.zoom.androidlib.util.ResourcesUtil;
import us.zoom.videomeetings.R;

public class IMViewPagerAdapter
extends FragmentStatePagerAdapter {
    public static final int ITEM_ADDRBOOK = 0;
    public static final int ITEM_MEETING = 2;
    public static final int ITEM_BUDDYLIST = 3;
    public static final int ITEM_SETTINGS = 4;
    public static final int ITEM_FAVORITELIST = 5;
    public static final int ITEM_CHATS = 6;
    public static final int ITEM_CONTENT = 7;
    public static final int ITEM_SIP = 8;
    private ArrayList<Fragment> mPages = new ArrayList();

    public IMViewPagerAdapter(FragmentManager fm) {
        super(fm);
        ZoomProductHelper productHelper;
        if (ResourcesUtil.getBoolean((Context)VideoBoxApplication.getInstance(), (int)R.bool.zm_config_use_4_pies_meeting_tab, (boolean)false)) {
            this.mPages.add((Fragment)new IMMeetingFragment());
        } else {
            this.mPages.add((Fragment)new MMChatsListFragment());
        }
        if (SipCallManager.getInstance().isSipCallEnabled()) {
            this.mPages.add((Fragment)new PhoneCallFragment());
        }
        if ((productHelper = PTApp.getInstance().getZoomProductHelper()) == null) {
            return;
        }
        if (PTApp.getInstance().hasZoomMessenger()) {
            this.mPages.add((Fragment)new IMAddrBookListFragment());
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger != null && messenger.imChatGetOption() != 2) {
                boolean isContentEnable;
                boolean isE2E = messenger.e2eGetMyOption() == 2;
                MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
                boolean bl = isContentEnable = mgr != null && mgr.getFileContentMgmtOption() == 1;
                if (!isE2E && isContentEnable && !PTApp.getInstance().isFileTransferDisabled()) {
                    this.mPages.add((Fragment)new MMContentFragment());
                }
            }
        } else if (PTApp.getInstance().isCurrentLoginTypeSupportIM()) {
            this.mPages.add((Fragment)new IMBuddyListFragment());
        }
        this.mPages.add((Fragment)SettingFragment.createSettingFragment(true, false));
    }

    public Object instantiateItem(ViewGroup container, int position) {
        Fragment f;
        Fragment fRet = (Fragment)super.instantiateItem(container, position);
        if (fRet != (f = this.getItem(position))) {
            this.mPages.set(position, fRet);
        }
        return fRet;
    }

    public Fragment getItem(int position) {
        if (position >= this.mPages.size()) {
            return null;
        }
        return this.mPages.get(position);
    }

    public Fragment getItemById(int itemId) {
        switch (itemId) {
            case 6: {
                return this.getItemByType(MMChatsListFragment.class);
            }
            case 0: {
                return this.getItemByType(IMAddrBookListFragment.class);
            }
            case 2: {
                return this.getItemByType(IMMeetingFragment.class);
            }
            case 3: {
                return this.getItemByType(IMBuddyListFragment.class);
            }
            case 4: {
                return this.getItemByType(SettingFragment.class);
            }
            case 5: {
                return this.getItemByType(IMFavoriteListFragment.class);
            }
            case 7: {
                return this.getItemByType(MMContentFragment.class);
            }
            case 8: {
                return this.getItemByType(PhoneCallFragment.class);
            }
        }
        return null;
    }

    private Fragment getItemByType(Class clazz) {
        for (Fragment f : this.mPages) {
            if (f.getClass() != clazz) continue;
            return f;
        }
        return null;
    }

    public int getCount() {
        return this.mPages.size();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        Fragment f = this.getItemById(2);
        if (f != null && f.isAdded()) {
            this.notifyDataSetChanged();
        }
    }

    public int getItemPosition(Object object) {
        if (object == this.getItemById(2)) {
            return -2;
        }
        boolean found = false;
        for (Fragment f : this.mPages) {
            if (f != object) continue;
            found = true;
            break;
        }
        if (!found) {
            return -2;
        }
        return super.getItemPosition(object);
    }

    public void clear() {
        this.mPages.clear();
    }
}

