/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.zipow.videobox.AddrBookItemDetailsActivity;
import com.zipow.videobox.MMChatActivity;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.GroupAction;
import com.zipow.videobox.ptapp.mm.ZMBuddySyncInstance;
import com.zipow.videobox.ptapp.mm.ZMSortUtil;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomBuddySearchData;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.IMSearchAdapter;
import com.zipow.videobox.view.WebSearchResult;
import com.zipow.videobox.view.mm.MMChatListFooter;
import com.zipow.videobox.view.mm.MMChatsListItem;
import com.zipow.videobox.view.mm.MMChatsListView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.videomeetings.R;

public class IMSearchView
extends ListView
implements AdapterView.OnItemClickListener,
AdapterView.OnItemLongClickListener {
    private static final String TAG = IMSearchView.class.getSimpleName();
    private IMSearchAdapter mIMSearchAdapter;
    private String mFilter;
    private Handler mHandler = new Handler();
    private Runnable mFilterRunnabel;
    private List<IMAddrBookItem> mContactsCache;
    private List<MMChatsListItem> mChatsListItemsCache;
    private WebSearchResult mWebSearchResult;
    private boolean mIsWebSearchMode = false;
    private boolean mJumpChats = false;
    private static final int MAX_LOCAL_CONTACTS_NUM = 5;
    private View mEmptyView;
    private boolean mHasFooter = false;

    public IMSearchView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public IMSearchView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public IMSearchView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.mIMSearchAdapter = new IMSearchAdapter(this.getContext());
        this.setAdapter((ListAdapter)this.mIMSearchAdapter);
        this.setOnItemClickListener(this);
        this.setOnItemLongClickListener(this);
    }

    public void setmHasFooter(boolean mNeedFooter) {
        this.mHasFooter = mNeedFooter;
    }

    public void onResume() {
        this.mChatsListItemsCache = this.getSearchedLocalChatSessions(PTApp.getInstance().getZoomMessenger());
        this.refreshSearchResult(false);
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("superState", super.onSaveInstanceState());
        bundle.putBoolean("mIsWebSearchMode", this.mIsWebSearchMode);
        bundle.putSerializable("mWebSearchResult", (Serializable)this.mWebSearchResult);
        bundle.putString("mFilter", this.mFilter);
        bundle.putBoolean("hasFooter", this.mHasFooter);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state != null && state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mIsWebSearchMode = bundle.getBoolean("mIsWebSearchMode");
            state = bundle.getParcelable("superState");
            this.mFilter = bundle.getString("mFilter");
            this.mWebSearchResult = (WebSearchResult)bundle.getSerializable("mWebSearchResult");
            this.mHasFooter = bundle.getBoolean("hasFooter", false);
        }
        super.onRestoreInstanceState(state);
    }

    public void setJumpChats(boolean jumpChats) {
        this.mJumpChats = jumpChats;
    }

    public void setEmptyView(View emptyView) {
        this.mEmptyView = emptyView;
    }

    public void setFilter(final String filter) {
        this.mIsWebSearchMode = false;
        this.mWebSearchResult = null;
        if (this.mFilterRunnabel != null) {
            this.mHandler.removeCallbacks(this.mFilterRunnabel);
        }
        this.mFilterRunnabel = new Runnable(){

            @Override
            public void run() {
                if (TextUtils.equals((CharSequence)IMSearchView.this.mFilter, (CharSequence)filter)) {
                    return;
                }
                if (!TextUtils.isEmpty((CharSequence)filter)) {
                    IMSearchView.this.mFilter = filter.toLowerCase(CompatUtils.getLocalDefault());
                } else {
                    IMSearchView.this.mFilter = filter;
                }
                IMSearchView.this.refreshSearchResult(true, true);
            }
        };
        this.mHandler.postDelayed(this.mFilterRunnabel, 300L);
    }

    public boolean isResultEmpty() {
        if (this.mIMSearchAdapter == null) {
            return true;
        }
        return this.mIMSearchAdapter.getCount() <= 0;
    }

    private List<IMAddrBookItem> getSearchedBuddies(ZoomMessenger messenger) {
        ZoomBuddySearchData searchData;
        if (messenger == null || TextUtils.isEmpty((CharSequence)this.mFilter)) {
            return null;
        }
        HashSet<String> buddies = new HashSet<String>();
        List<String> localBuddies = messenger.localStrictSearchBuddies(this.mFilter, null);
        if (localBuddies != null && localBuddies.size() > 0 && messenger.isAnyBuddyGroupLarge()) {
            messenger.getBuddiesPresence(localBuddies, true);
        }
        if (localBuddies != null) {
            buddies.addAll(localBuddies);
        }
        if ((searchData = messenger.getBuddySearchData()) != null && this.mFilter != null && StringUtil.isSameString((String)searchData.getSearchKey().getKey(), (String)this.mFilter)) {
            this.mWebSearchResult = new WebSearchResult();
            ArrayList<String> webSearched = new ArrayList<String>();
            this.mWebSearchResult.setKey(this.mFilter);
            for (int i = 0; i < searchData.getBuddyCount(); ++i) {
                ZoomBuddy buddy = searchData.getBuddyAt(i);
                if (buddy == null) continue;
                String jid = buddy.getJid();
                webSearched.add(jid);
                IMAddrBookItem item = IMAddrBookItem.fromZoomBuddy(buddy);
                if (item == null) continue;
                this.mWebSearchResult.putItem(jid, item);
            }
            buddies.addAll(webSearched);
            messenger.getBuddiesPresence(webSearched, false);
        } else if (this.mWebSearchResult != null && StringUtil.isSameString((String)this.mFilter, (String)this.mWebSearchResult.getKey())) {
            buddies.addAll(this.mWebSearchResult.getJids());
        }
        ArrayList<String> source = new ArrayList<String>();
        source.addAll(buddies);
        List<String> sorted = ZMSortUtil.sortBuddies(source, 0, this.mFilter);
        ArrayList<IMAddrBookItem> searchBuddiesList = new ArrayList<IMAddrBookItem>();
        if (sorted != null && sorted.size() > 0) {
            ZoomBuddy mySelf;
            int maxNum = sorted.size();
            if (!this.mIsWebSearchMode) {
                maxNum = sorted.size() > 5 ? 5 : sorted.size();
            }
            if ((mySelf = messenger.getMyself()) != null) {
                for (int i = 0; searchBuddiesList.size() < maxNum && i < sorted.size(); ++i) {
                    ZoomBuddy buddy;
                    String jid = sorted.get(i);
                    IMAddrBookItem item = ZMBuddySyncInstance.getInsatance().getBuddyByJid(jid);
                    if (item == null && (buddy = messenger.getBuddyWithJID(jid)) != null) {
                        item = IMAddrBookItem.fromZoomBuddy(buddy);
                    }
                    if (item == null || TextUtils.equals((CharSequence)item.getJid(), (CharSequence)mySelf.getJid())) continue;
                    searchBuddiesList.add(item);
                }
            }
        }
        return searchBuddiesList;
    }

    private List<MMChatsListItem> getSearchedLocalChatSessions(ZoomMessenger messenger) {
        if (messenger == null || TextUtils.isEmpty((CharSequence)this.mFilter) || messenger.imChatGetOption() == 2) {
            return null;
        }
        List<String> sessions = messenger.localSearchGroupSessionsByName(this.mFilter);
        ArrayList<MMChatsListItem> searchChatsList = new ArrayList<MMChatsListItem>();
        if (sessions != null && sessions.size() > 0) {
            for (int i = 0; i < sessions.size(); ++i) {
                MMChatsListItem item;
                String jid = sessions.get(i);
                ZoomChatSession session = messenger.getSessionById(jid);
                if (session == null || (item = MMChatsListItem.fromZoomChatSession(session, messenger, this.getContext())) == null) continue;
                searchChatsList.add(item);
            }
        }
        return searchChatsList;
    }

    private void refreshSearchResult(boolean fromNative, boolean autoWebSearch) {
        this.mIMSearchAdapter.clear();
        if (TextUtils.isEmpty((CharSequence)this.mFilter)) {
            this.mIMSearchAdapter.notifyDataSetChanged();
            super.setEmptyView(null);
            if (this.mEmptyView != null) {
                this.mEmptyView.setVisibility(8);
            }
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ArrayList<Object> searchResults = new ArrayList<Object>();
        if (fromNative || this.mContactsCache == null) {
            this.mContactsCache = this.getSearchedBuddies(messenger);
        }
        if (CollectionsUtil.isListEmpty(this.mContactsCache) && autoWebSearch && messenger.searchBuddyByKey(this.mFilter)) {
            this.mIsWebSearchMode = true;
        }
        if (this.mContactsCache != null && this.mContactsCache.size() > 0 || this.mIsWebSearchMode && !this.isWebSearchOver()) {
            searchResults.add(this.getContext().getString(R.string.zm_lbl_search_category_contact));
        }
        if (this.mContactsCache != null) {
            searchResults.addAll(this.mContactsCache);
        }
        if (this.mIsWebSearchMode) {
            if (!this.isWebSearchOver()) {
                searchResults.add(new IMSearchAdapter.ItemWebSearching());
            }
        } else if (this.mFilter.trim().length() >= 3) {
            searchResults.add(new IMSearchAdapter.ItemViewMore());
        }
        if (fromNative || this.mChatsListItemsCache == null) {
            this.mChatsListItemsCache = this.getSearchedLocalChatSessions(messenger);
        }
        if (this.mChatsListItemsCache != null && this.mChatsListItemsCache.size() > 0) {
            this.mChatsListItemsCache = ZMSortUtil.sortSessions(this.mChatsListItemsCache);
            searchResults.add(this.getContext().getString(R.string.zm_lbl_search_category_chat_groups));
            searchResults.addAll(this.mChatsListItemsCache);
        }
        if (this.mHasFooter) {
            searchResults.add(new MMChatListFooter(this.mFilter));
        }
        this.mIMSearchAdapter.clear();
        this.mIMSearchAdapter.addAllItems(searchResults);
        this.mIMSearchAdapter.notifyDataSetChanged();
        super.setEmptyView(this.mEmptyView);
    }

    private boolean isWebSearchOver() {
        return this.mWebSearchResult != null && StringUtil.isSameString((String)this.mFilter, (String)this.mWebSearchResult.getKey());
    }

    public void refreshSearchResult(boolean fromNative) {
        this.refreshSearchResult(fromNative, false);
    }

    public void onGroupAction(int result, GroupAction action, String msgId) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        String sessionId = action.getGroupId();
        if (StringUtil.isEmptyOrNull((String)sessionId)) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(sessionId);
        if (session == null) {
            this.mIMSearchAdapter.removeItem(sessionId);
        } else {
            MMChatsListItem item = MMChatsListItem.fromZoomChatSession(session, messenger, this.getContext());
            this.mIMSearchAdapter.updateItem(item);
        }
        switch (action.getActionType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.mIMSearchAdapter.removeCache(sessionId);
            }
        }
        this.mIMSearchAdapter.notifyDataSetChanged();
    }

    public void onReceiveMessage(String sessionId, String senderJid, String messageId) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)messageId)) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)sessionId)) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(sessionId);
        if (session == null) {
            this.mIMSearchAdapter.removeItem(sessionId);
        } else {
            MMChatsListItem item = MMChatsListItem.fromZoomChatSession(session, messenger, this.getContext());
            this.mIMSearchAdapter.updateItem(item);
        }
    }

    public void onNotify_ChatSessionListUpdate() {
        this.refreshSearchResult(true);
    }

    public void onNotify_MUCGroupInfoUpdatedImpl(String groupID) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)groupID)) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(groupID);
        if (session == null) {
            this.mIMSearchAdapter.removeItem(groupID);
        } else {
            MMChatsListItem item = MMChatsListItem.fromZoomChatSession(session, messenger, this.getContext());
            this.mIMSearchAdapter.updateItem(item);
        }
    }

    public void onConfirm_MessageSent(String sessionId, String messageId, int result) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)messageId)) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)sessionId)) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(sessionId);
        if (session == null) {
            this.mIMSearchAdapter.removeItem(sessionId);
        } else {
            MMChatsListItem item = MMChatsListItem.fromZoomChatSession(session, messenger, this.getContext());
            this.mIMSearchAdapter.updateItem(item);
        }
    }

    public void onIndicateZoomMessengerBuddyListUpdated() {
        this.refreshSearchResult(true);
    }

    public void updateBuddyInfoWithJid(String jid) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
        if (buddy == null) {
            return;
        }
        IMAddrBookItem item = IMAddrBookItem.fromZoomBuddy(buddy);
        if (item == null) {
            return;
        }
        if (this.mContactsCache != null) {
            for (int i = 0; i < this.mContactsCache.size(); ++i) {
                IMAddrBookItem cache = this.mContactsCache.get(i);
                if (cache == null || !TextUtils.equals((CharSequence)cache.getJid(), (CharSequence)item.getJid())) continue;
                this.mContactsCache.set(i, item);
            }
        }
        this.mIMSearchAdapter.updateItem(item);
    }

    public void onZoomMessengerRemoveBuddy(String jid, int result) {
        this.refreshSearchResult(true);
    }

    private void onClickChatItem(MMChatsListItem item) {
        if (item == null) {
            return;
        }
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(item.getSessionId());
        if (session == null) {
            return;
        }
        if (session.isGroup()) {
            ZoomGroup group = session.getSessionGroup();
            if (group == null) {
                return;
            }
            String groupId = group.getGroupID();
            if (StringUtil.isEmptyOrNull((String)groupId)) {
                return;
            }
            IMSearchView.startGroupChat(activity, groupId);
        } else {
            ZoomBuddy buddy = session.getSessionBuddy();
            if (buddy == null) {
                return;
            }
            IMSearchView.startOneToOneChat(activity, buddy);
        }
    }

    private static void startOneToOneChat(ZMActivity activity, ZoomBuddy buddy) {
        MMChatActivity.showAsOneToOneChat(activity, buddy);
    }

    private static void startGroupChat(ZMActivity activity, String groupId) {
        MMChatActivity.showAsGroupChat(activity, groupId);
    }

    private void onClickContactItem(IMAddrBookItem item) {
        if (item == null) {
            return;
        }
        if (item.isPending()) {
            return;
        }
        this.showUserActions(item);
    }

    private void showUserActions(IMAddrBookItem item) {
        if (item == null) {
            return;
        }
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (this.mJumpChats && messenger.imChatGetOption() != 2) {
            MMChatActivity.showAsOneToOneChat(activity, item, item.getJid());
        } else {
            AddrBookItemDetailsActivity.show(activity, item, 106);
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Object oItem = this.mIMSearchAdapter.getItem(position);
        if (oItem == null) {
            return;
        }
        if (oItem instanceof MMChatsListItem) {
            this.onClickChatItem((MMChatsListItem)oItem);
        } else if (oItem instanceof IMAddrBookItem) {
            this.onClickContactItem((IMAddrBookItem)oItem);
        } else if (oItem instanceof IMSearchAdapter.ItemViewMore) {
            this.onClickSearchMore();
        }
    }

    private void onClickSearchMore() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (messenger.searchBuddyByKey(this.mFilter)) {
            this.mIsWebSearchMode = true;
            this.refreshSearchResult(false);
        }
    }

    public void onSearchBuddyByKey(String key, int result) {
        if (!TextUtils.equals((CharSequence)key, (CharSequence)this.mFilter)) {
            return;
        }
        this.refreshSearchResult(true);
    }

    private boolean onLongClickChatItem(final MMChatsListItem item) {
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null) {
            return false;
        }
        final ZMMenuAdapter menuAdapter = new ZMMenuAdapter((Context)activity, false);
        ArrayList<MMChatsListView.ChatsListContextMenuItem> items = new ArrayList<MMChatsListView.ChatsListContextMenuItem>();
        String title = "";
        if (item.isGroup()) {
            title = activity.getString(R.string.zm_mm_title_chatslist_context_menu_group_chat);
            items.add(new MMChatsListView.ChatsListContextMenuItem(activity.getString(R.string.zm_mm_lbl_delete_group_chat_20762), 0));
        } else {
            title = item.getTitle();
            items.add(new MMChatsListView.ChatsListContextMenuItem(activity.getString(R.string.zm_mm_lbl_delete_chat_20762), 0));
        }
        menuAdapter.addAll(items);
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setTitle(title).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MMChatsListView.ChatsListContextMenuItem mi = (MMChatsListView.ChatsListContextMenuItem)((Object)menuAdapter.getItem(which));
                IMSearchView.this.onSelectContextMenuItem(item, mi);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
        return true;
    }

    private void onSelectContextMenuItem(MMChatsListItem listItem, MMChatsListView.ChatsListContextMenuItem mi) {
        if (mi.getAction() == 0) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            String sessionId = listItem.getSessionId();
            if (messenger.deleteSession(sessionId)) {
                this.refreshSearchResult(true);
            }
        }
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
        Object oItem = this.mIMSearchAdapter.getItem(position);
        if (oItem == null) {
            return false;
        }
        if (oItem instanceof MMChatsListItem) {
            return this.onLongClickChatItem((MMChatsListItem)oItem);
        }
        return false;
    }
}

