/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.zipow.videobox.util.MemCache;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.mm.MMChatListFooter;
import com.zipow.videobox.view.mm.MMChatsListItem;
import java.util.ArrayList;
import java.util.List;
import us.zoom.videomeetings.R;

public class IMSearchAdapter
extends BaseAdapter {
    private Context mContext;
    private List<Object> searchData = new ArrayList<Object>();
    private MemCache<String, Drawable> mAvatarCache = new MemCache(10);

    public IMSearchAdapter(Context context) {
        this.mContext = context;
    }

    public void clear() {
        this.searchData.clear();
    }

    public void addAllItems(List<Object> items) {
        this.searchData.addAll(items);
    }

    public void removeCache(String id2) {
        this.mAvatarCache.removeItem(id2);
    }

    public void removeItem(Object item) {
        if (item instanceof MMChatsListItem) {
            MMChatsListItem itemNew = (MMChatsListItem)item;
            for (int i = 0; i < this.searchData.size(); ++i) {
                MMChatsListItem itemOld;
                Object obj = this.searchData.get(i);
                if (!(obj instanceof MMChatsListItem) || !TextUtils.equals((CharSequence)(itemOld = (MMChatsListItem)obj).getSessionId(), (CharSequence)itemNew.getSessionId())) continue;
                this.searchData.remove(i);
                break;
            }
        } else if (item instanceof IMAddrBookItem) {
            IMAddrBookItem itemNew = (IMAddrBookItem)item;
            for (int i = 0; i < this.searchData.size(); ++i) {
                IMAddrBookItem itemOld;
                Object obj = this.searchData.get(i);
                if (!(obj instanceof IMAddrBookItem) || !TextUtils.equals((CharSequence)(itemOld = (IMAddrBookItem)obj).getJid(), (CharSequence)itemNew.getJid())) continue;
                this.searchData.remove(i);
                break;
            }
        }
        this.notifyDataSetChanged();
    }

    public void updateItem(Object item) {
        boolean isSearched = false;
        if (item instanceof MMChatsListItem) {
            MMChatsListItem itemNew = (MMChatsListItem)item;
            for (int i = 0; i < this.searchData.size(); ++i) {
                MMChatsListItem itemOld;
                Object obj = this.searchData.get(i);
                if (!(obj instanceof MMChatsListItem) || !TextUtils.equals((CharSequence)(itemOld = (MMChatsListItem)obj).getSessionId(), (CharSequence)itemNew.getSessionId())) continue;
                this.searchData.set(i, itemNew);
                isSearched = true;
                break;
            }
        } else if (item instanceof IMAddrBookItem) {
            IMAddrBookItem itemNew = (IMAddrBookItem)item;
            for (int i = 0; i < this.searchData.size(); ++i) {
                IMAddrBookItem itemOld;
                Object obj = this.searchData.get(i);
                if (!(obj instanceof IMAddrBookItem) || !TextUtils.equals((CharSequence)(itemOld = (IMAddrBookItem)obj).getJid(), (CharSequence)itemNew.getJid())) continue;
                this.searchData.set(i, itemNew);
                isSearched = true;
                break;
            }
        }
        if (isSearched) {
            this.notifyDataSetChanged();
        }
    }

    public int getCount() {
        return this.searchData.size();
    }

    public Object getItem(int position) {
        if (position < 0 || position >= this.searchData.size()) {
            return null;
        }
        return this.searchData.get(position);
    }

    public int getItemViewType(int position) {
        Object item = this.getItem(position);
        if (item == null) {
            return 0;
        }
        if (item instanceof IMAddrBookItem) {
            return 0;
        }
        if (item instanceof MMChatsListItem) {
            return 1;
        }
        if (item instanceof ItemWebSearching) {
            return 2;
        }
        if (item instanceof MMChatListFooter) {
            return 3;
        }
        if (item instanceof ItemViewMore) {
            return 4;
        }
        return 5;
    }

    public int getViewTypeCount() {
        return 6;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Object item = this.getItem(position);
        if (item == null) {
            return null;
        }
        if (item instanceof MMChatsListItem) {
            return ((MMChatsListItem)item).getView(this.mContext, convertView, parent, this.mAvatarCache, false);
        }
        if (item instanceof IMAddrBookItem) {
            return ((IMAddrBookItem)item).getView(this.mContext, convertView, false, true);
        }
        if (item instanceof ItemWebSearching) {
            if (convertView == null || !"zm_search_web_searching".equals(convertView.getTag())) {
                convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_list_load_more_footer, null);
                convertView.findViewById(R.id.panelLoadMoreView).setVisibility(0);
                convertView.setTag((Object)"zm_search_web_searching");
            }
        } else {
            if (item instanceof MMChatListFooter) {
                return ((MMChatListFooter)item).getView(this.mContext, convertView, parent);
            }
            if (item instanceof ItemViewMore) {
                if (convertView == null || !"zm_search_view_more".equals(convertView.getTag())) {
                    convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_search_view_more, null);
                    convertView.setTag((Object)"zm_search_view_more");
                }
            } else {
                String str = item.toString();
                if (convertView == null || !"zm_search_category_item".equals(convertView.getTag())) {
                    convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_search_category_item, null);
                    convertView.setTag((Object)"zm_search_category_item");
                }
                TextView txtCategoryItem = (TextView)convertView.findViewById(R.id.txtCategoryItem);
                txtCategoryItem.setText((CharSequence)str);
                convertView.findViewById(R.id.viewPaddingTop).setVisibility(position == 0 ? 8 : 0);
            }
        }
        return convertView;
    }

    public static class ItemViewMore {
    }

    public static class ItemWebSearching {
    }
}

