/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.zipow.videobox.ptapp.IMHelper;
import com.zipow.videobox.ptapp.IMSession;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.view.IMMessageItem;
import com.zipow.videobox.view.IMMessageListAdapter;

public class IMMessageListView
extends ListView {
    private IMMessageListAdapter mAdapter;
    private String mBuddyJid;
    private String mBuddyName;
    private String mMyName;
    private long mPrevTime = 0L;

    public IMMessageListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public IMMessageListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public IMMessageListView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.mAdapter = new IMMessageListAdapter(this.getContext());
        if (this.isInEditMode()) {
            this._editmode_loadAllMessageItems(this.mAdapter);
        }
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    private void _editmode_loadAllMessageItems(IMMessageListAdapter adapter) {
        IMMessageItem date = new IMMessageItem();
        date.messageTime = System.currentTimeMillis();
        date.messageType = 10;
        adapter.addItem(date);
        for (int i = 0; i < 5; ++i) {
            IMMessageItem item = new IMMessageItem();
            item.fromScreenName = i % 2 == 0 ? "Zoom" : "Reed Yang";
            item.message = "Hi, Zoom! I like you!";
            item.messageTime = System.currentTimeMillis();
            item.messageType = i % 2 == 0 ? 0 : 1;
            adapter.addItem(item);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        final int lastVisiblePos = this.getLastVisiblePosition();
        super.onLayout(changed, l, t, r, b);
        if (!changed) {
            return;
        }
        if (lastVisiblePos >= 0) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    IMMessageListView.this.setSelection(lastVisiblePos);
                }
            });
        }
    }

    public void reloadMessages(String buddyJid, String buddyName, String myName) {
        this.mBuddyJid = buddyJid;
        this.mBuddyName = buddyName;
        this.mMyName = myName;
        if (this.mBuddyJid == null || this.mBuddyName == null || this.mMyName == null) {
            return;
        }
        IMHelper imHelper = PTApp.getInstance().getIMHelper();
        if (imHelper == null) {
            return;
        }
        IMSession session = imHelper.getSessionBySessionName(this.mBuddyJid);
        if (session == null) {
            return;
        }
        this.mAdapter.clear();
        IMMessageItem item = null;
        this.mPrevTime = 0L;
        for (int i = 0; i < session.getIMMessageCount(); ++i) {
            PTAppProtos.IMMessage message = session.getIMMessageByIndex(i);
            if (message == null) continue;
            imHelper.setIMMessageUnread(message, false);
            item = this.protoMessageToMessageItem(message);
            if (item == null) continue;
            long messageTime = item.messageTime;
            if (messageTime - this.mPrevTime > 300000L) {
                IMMessageItem dateItem = new IMMessageItem();
                dateItem.messageTime = messageTime;
                dateItem.messageType = 10;
                this.mAdapter.addItem(dateItem);
                this.mPrevTime = dateItem.messageTime;
            }
            this.mAdapter.addItem(item);
        }
        this.mAdapter.notifyDataSetChanged();
    }

    protected IMMessageItem protoMessageToMessageItem(PTAppProtos.IMMessage message) {
        IMMessageItem item = new IMMessageItem();
        item.fromJid = message.getFromScreenName();
        item.toJid = message.getToScreenName();
        item.messageTime = message.getMessageTime() * 1000L;
        item.nativeHandle = message.getNativeHandle();
        if (this.mBuddyJid.equals(message.getFromScreenName())) {
            item.fromScreenName = this.mBuddyName;
            item.toScreenName = this.mMyName;
        } else {
            item.fromScreenName = this.mMyName;
            item.toScreenName = this.mBuddyName;
        }
        item.messageType = this.protoMessageType2MessageItemType(message);
        item.message = message.getMessage();
        return item;
    }

    private int protoMessageType2MessageItemType(PTAppProtos.IMMessage message) {
        int type = 0;
        switch (message.getMessageType()) {
            case 0: {
                if (this.mBuddyJid.equals(message.getFromScreenName())) {
                    type = 0;
                    break;
                }
                type = 1;
                break;
            }
            case 1: {
                if (this.mBuddyJid.equals(message.getFromScreenName())) {
                    type = 2;
                    break;
                }
                type = 3;
                break;
            }
            case 2: {
                if (this.mBuddyJid.equals(message.getFromScreenName())) {
                    type = 4;
                    break;
                }
                type = 5;
                break;
            }
            case 3: {
                if (this.mBuddyJid.equals(message.getFromScreenName())) {
                    type = 6;
                    break;
                }
                type = 7;
                break;
            }
            case 4: {
                type = this.mBuddyJid.equals(message.getFromScreenName()) ? 8 : 9;
            }
        }
        return type;
    }

    public void onIMReceived(PTAppProtos.IMMessage message, boolean setAsRead) {
        IMMessageItem item;
        IMHelper imHelper = PTApp.getInstance().getIMHelper();
        if (imHelper != null && setAsRead) {
            imHelper.setIMMessageUnread(message, false);
        }
        if ((item = this.protoMessageToMessageItem(message)) == null) {
            return;
        }
        if (item.messageTime - this.mPrevTime > 300000L) {
            IMMessageItem dateItem = new IMMessageItem();
            dateItem.messageTime = item.messageTime;
            dateItem.messageType = 10;
            this.mAdapter.addItem(dateItem);
            this.mPrevTime = item.messageTime;
        }
        this.mAdapter.addItem(item);
        this.mAdapter.notifyDataSetChanged();
        this.scrollToBottom(false);
    }

    public void scrollToBottom(boolean force) {
        int lastVisiblePos = this.getLastVisiblePosition();
        int lastPos = this.getCount() - 1;
        if (force) {
            this.setSelection(lastPos);
        } else if (lastPos - lastVisiblePos < 5) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.smoothScrollToPosition(lastPos);
            } else {
                this.setSelection(lastPos);
            }
        }
    }
}

