/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.zipow.videobox.view.IMMessageItem;
import java.util.ArrayList;
import java.util.List;

public class IMMessageListAdapter
extends BaseAdapter {
    private List<IMMessageItem> items = new ArrayList<IMMessageItem>();
    private Context mContext;

    public IMMessageListAdapter(Context context) {
        assert (context != null);
        this.mContext = context;
    }

    public void clear() {
        this.items.clear();
    }

    public void addItem(IMMessageItem item) {
        assert (item != null);
        int position = this.findItem(item.nativeHandle);
        if (position >= 0) {
            this.items.set(position, item);
        } else {
            this.items.add(item);
        }
    }

    public int findItem(long nativeHandle) {
        if (nativeHandle == 0L) {
            return -1;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            IMMessageItem item = this.items.get(i);
            if (nativeHandle != item.nativeHandle) continue;
            return i;
        }
        return -1;
    }

    public int getCount() {
        return this.items.size();
    }

    public Object getItem(int position) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        return this.items.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        int type = 0;
        IMMessageItem item = (IMMessageItem)this.getItem(position);
        if (item != null) {
            type = item.messageType;
        }
        return type;
    }

    public int getViewTypeCount() {
        return 11;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        IMMessageItem item = (IMMessageItem)this.getItem(position);
        if (item == null) {
            return null;
        }
        return item.getView(this.mContext, convertView);
    }
}

