/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.ptapp.IMHelper;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.util.NotificationMgr;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.IMBuddyItem;
import com.zipow.videobox.view.IMMessageListView;
import com.zipow.videobox.view.IMView;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class IMChatView
extends LinearLayout
implements View.OnClickListener {
    private static final String TAG = IMChatView.class.getSimpleName();
    private IMMessageListView mMessageListView;
    private TextView mTxtBuddyChatTo;
    private ImageView mImgPresence;
    private EditText mEdtMessage;
    private Button mBtnSend;
    private Button mBtnStartConf;
    private Button mBtnBack;
    private IMBuddyItem mBuddyChatTo;
    private static final int CONF_BTN_STATUS_START = 0;
    private static final int CONF_BTN_STATUS_INVITE = 1;
    private static final int CONF_BTN_STATUS_RETURN = 2;
    private int mConfBtnStatus = 0;
    private Listener mListener;

    public IMChatView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public IMChatView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_im_chat_view, (ViewGroup)this);
        this.mMessageListView = (IMMessageListView)this.findViewById(R.id.messageListView);
        this.mTxtBuddyChatTo = (TextView)this.findViewById(R.id.txtBuddyChatTo);
        this.mImgPresence = (ImageView)this.findViewById(R.id.imgPresence);
        this.mEdtMessage = (EditText)this.findViewById(R.id.edtMessage);
        this.mBtnSend = (Button)this.findViewById(R.id.btnSend);
        this.mBtnStartConf = (Button)this.findViewById(R.id.btnStartConf);
        this.mBtnBack = (Button)this.findViewById(R.id.btnBack);
        this.mBtnSend.setOnClickListener((View.OnClickListener)this);
        this.mBtnStartConf.setOnClickListener((View.OnClickListener)this);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        if (UIMgr.isLargeMode(this.getContext())) {
            this.mBtnBack.setVisibility(8);
        }
    }

    public void scrollToBottom(boolean force) {
        this.mMessageListView.scrollToBottom(force);
    }

    public void setListener(Listener l) {
        this.mListener = l;
    }

    private void setBuddyNameChatTo(CharSequence name) {
        if (name != null) {
            this.mTxtBuddyChatTo.setText(name);
        }
    }

    public void reloadData(IMBuddyItem item, String myName) {
        if (item == null || myName == null) {
            return;
        }
        this.setBuddyChatTo(item);
        this.reloadMessages(item.userId, item.screenName, myName);
        this.updateStartConfBtn(PTApp.getInstance().getCallStatus());
    }

    private void updateStartConfBtn(int callStatus) {
        switch (callStatus) {
            case 2: {
                if (PTApp.getInstance().probeUserStatus(this.mBuddyChatTo.userId)) {
                    this.mBtnStartConf.setText(R.string.zm_btn_return_to_conf);
                    this.mConfBtnStatus = 2;
                } else {
                    this.mBtnStartConf.setText(R.string.zm_btn_invite_to_conf);
                    this.mConfBtnStatus = 1;
                }
                this.mBtnStartConf.setEnabled(true);
                break;
            }
            case 1: {
                this.mBtnStartConf.setText(R.string.zm_btn_start_conf);
                this.mConfBtnStatus = 0;
                this.mBtnStartConf.setEnabled(false);
                break;
            }
            default: {
                this.mBtnStartConf.setText(R.string.zm_btn_start_conf);
                this.mConfBtnStatus = 0;
                this.mBtnStartConf.setEnabled(this.checkStartButtonEnabled());
            }
        }
    }

    private boolean checkStartButtonEnabled() {
        PTApp ptApp = PTApp.getInstance();
        return ptApp.hasPrescheduleMeeting() || ptApp.canAccessZoomWebservice();
    }

    private void setBuddyChatTo(IMBuddyItem item) {
        if (item == null) {
            return;
        }
        this.mBuddyChatTo = item;
        this.setBuddyNameChatTo(item.screenName);
        this.setPresence(item.presence);
    }

    public void setPresence(int presence) {
        switch (presence) {
            case 0: {
                this.mImgPresence.setImageResource(R.drawable.zm_status_available);
                this.mImgPresence.setContentDescription((CharSequence)this.mImgPresence.getResources().getString(R.string.zm_description_mm_presence_available));
                break;
            }
            case 3: {
                this.mImgPresence.setImageResource(R.drawable.zm_status_idle);
                this.mImgPresence.setContentDescription((CharSequence)this.mImgPresence.getResources().getString(R.string.zm_description_mm_presence_dnd_19903));
                break;
            }
            case 4: {
                this.mImgPresence.setImageResource(R.drawable.zm_status_dnd);
                this.mImgPresence.setContentDescription((CharSequence)this.mImgPresence.getResources().getString(R.string.zm_description_mm_presence_xa_19903));
                break;
            }
            case 2: {
                this.mImgPresence.setImageResource(R.drawable.zm_status_idle);
                this.mImgPresence.setContentDescription((CharSequence)this.mImgPresence.getResources().getString(R.string.zm_description_mm_presence_idle));
                break;
            }
            default: {
                this.mImgPresence.setImageResource(R.drawable.zm_offline);
                this.mImgPresence.setContentDescription((CharSequence)this.mImgPresence.getResources().getString(R.string.zm_description_mm_presence_offline));
            }
        }
    }

    private void reloadMessages(String buddyJid, String buddyName, String myName) {
        this.mMessageListView.reloadMessages(buddyJid, buddyName, myName);
    }

    public void onIMReceived(PTAppProtos.IMMessage message) {
        boolean isMessageOfThisSession;
        if (this.mBuddyChatTo == null || this.mBuddyChatTo.userId == null) {
            return;
        }
        boolean isIncommingMessageOfThisSession = this.mBuddyChatTo.userId.equals(message.getFromScreenName());
        boolean isOutMessageOfThisSession = this.mBuddyChatTo.userId.equals(message.getToScreenName());
        boolean bl = isMessageOfThisSession = isIncommingMessageOfThisSession || isOutMessageOfThisSession;
        if (isMessageOfThisSession) {
            ZMActivity activity = (ZMActivity)this.getContext();
            if (activity == null) {
                return;
            }
            this.mMessageListView.onIMReceived(message, activity.isActive() || isOutMessageOfThisSession);
            if (message.getMessageType() == 0 && isIncommingMessageOfThisSession && !activity.isActive()) {
                NotificationMgr.showMessageNotificationMM(this.getContext(), message.getMessageType() == 0);
            }
        } else {
            NotificationMgr.showMessageNotificationMM(this.getContext(), message.getMessageType() == 0);
        }
    }

    public void onIMBuddyPresence(PTAppProtos.BuddyItem item) {
        if (item != null && this.mBuddyChatTo != null && this.mBuddyChatTo.userId != null && this.mBuddyChatTo.userId.equals(item.getJid())) {
            IMBuddyItem buddyChatTo = new IMBuddyItem(item);
            this.setBuddyChatTo(buddyChatTo);
        }
    }

    public void onIMBuddyPic(PTAppProtos.BuddyItem item) {
        if (item != null && this.mBuddyChatTo != null && this.mBuddyChatTo.userId != null && this.mBuddyChatTo.userId.equals(item.getJid())) {
            IMBuddyItem buddyChatTo = new IMBuddyItem(item);
            this.setBuddyChatTo(buddyChatTo);
        }
    }

    public void onWebLogin(long result) {
        this.updateStartConfBtn(PTApp.getInstance().getCallStatus());
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnSend) {
            this.onClickBtnSend();
        } else if (id2 == R.id.btnStartConf) {
            this.onClickBtnStartConf();
        } else if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        }
    }

    private void onClickBtnBack() {
        UIUtil.closeSoftKeyboard((Context)this.getContext(), (View)this);
        if (this.mListener != null) {
            this.mListener.onClickButtonBack();
        }
    }

    private void onClickBtnSend() {
        if (this.mBuddyChatTo == null || this.mBuddyChatTo.userId == null) {
            return;
        }
        String message = this.mEdtMessage.getText().toString().trim();
        if (message.length() == 0) {
            return;
        }
        IMHelper imHelper = PTApp.getInstance().getIMHelper();
        if (imHelper != null) {
            this.scrollToBottom(true);
            imHelper.sendIMMessage(this.mBuddyChatTo.userId, message, true);
            this.mEdtMessage.setText((CharSequence)"");
        }
    }

    private void onClickBtnStartConf() {
        UIUtil.closeSoftKeyboard((Context)this.getContext(), (View)this);
        switch (this.mConfBtnStatus) {
            case 0: {
                this.startConf();
                break;
            }
            case 1: {
                this.inviteToConf();
                break;
            }
            case 2: {
                this.returnToConf();
            }
        }
    }

    private void returnToConf() {
        ConfActivity.returnToConf(this.getContext());
    }

    private void inviteToConf() {
        PTApp ptApp = PTApp.getInstance();
        String meetingId = ptApp.getActiveCallId();
        if (StringUtil.isEmptyOrNull((String)meetingId)) {
            return;
        }
        int ret = ptApp.inviteBuddiesToConf(new String[]{this.mBuddyChatTo.userId}, null, meetingId, 0L, this.getContext().getString(R.string.zm_msg_invitation_message_template));
        if (ret == 0) {
            ConfActivity.returnToConf(this.getContext());
        }
    }

    private void startConf() {
        int ret = ConfActivity.inviteToVideoCall(this.getContext(), this.mBuddyChatTo.userId, 1);
        if (ret != 0) {
            IMView.StartHangoutFailedDialog.show(((ZMActivity)this.getContext()).getSupportFragmentManager(), IMView.StartHangoutFailedDialog.class.getName(), ret);
        }
    }

    public void onCallStatusChanged(long result) {
        this.updateStartConfBtn((int)result);
    }

    public void onCallPlistChanged() {
        this.updateStartConfBtn(PTApp.getInstance().getCallStatus());
    }

    public static interface Listener {
        public void onClickButtonBack();
    }
}

