/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListView;
import android.widget.TextView;
import com.zipow.videobox.AddrBookItemDetailsActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.fragment.IMAddrBookListFragment;
import com.zipow.videobox.fragment.IMBuddyListFragment;
import com.zipow.videobox.fragment.IMFavoriteListFragment;
import com.zipow.videobox.ptapp.ABContactsCache;
import com.zipow.videobox.ptapp.ABContactsHelper;
import com.zipow.videobox.ptapp.ContactsMatchHelper;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTSettingHelper;
import com.zipow.videobox.ptapp.mm.ZMBuddySyncInstance;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomBuddyGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.IMAddrBookItemView;
import com.zipow.videobox.view.IMAddrBookListAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.CountryCodeUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.PullDownRefreshListView;
import us.zoom.androidlib.widget.QuickSearchListView;
import us.zoom.videomeetings.R;

public class IMAddrBookListView
extends QuickSearchListView
implements AdapterView.OnItemClickListener,
AdapterView.OnItemLongClickListener,
PullDownRefreshListView.PullDownRefreshListener,
AbsListView.OnScrollListener {
    private static final String TAG = IMAddrBookListView.class.getSimpleName();
    private IMAddrBookListAdapter mAdapter;
    private String mFilter;
    private IMAddrBookListFragment mFragment;
    private int mScorllState;
    private List<String> mPendingPresenceChangeJids = new ArrayList<String>();
    private List<String> mPendingInfoChangeJids = new ArrayList<String>();
    private boolean mPendingNeedNotifyDataSetChange;
    private static HashMap<String, IMAddrBookItem> gCachedZoomOnlyItems = null;
    private static final int MSG_REFRESH_BUDDY_VCARDS = 1;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    IMAddrBookListView.this.refreshBuddyVcards();
                    this.sendEmptyMessageDelayed(1, 2000L);
                    break;
                }
            }
        }
    };

    public static void cacheItems(HashMap<String, IMAddrBookItem> items) {
        gCachedZoomOnlyItems = items;
    }

    public static void clearCaches() {
        gCachedZoomOnlyItems = null;
    }

    private static void updateCachedItemWithJid(String jid, IMAddrBookItem item) {
        if (StringUtil.isEmptyOrNull((String)jid) || gCachedZoomOnlyItems == null) {
            return;
        }
        IMAddrBookItem oldItem = gCachedZoomOnlyItems.get(jid);
        if (oldItem != null) {
            gCachedZoomOnlyItems.put(jid, item);
        }
    }

    private static void addCachedItemWithJid(String jid, IMAddrBookItem item) {
        if (StringUtil.isEmptyOrNull((String)jid) || gCachedZoomOnlyItems == null) {
            return;
        }
        gCachedZoomOnlyItems.put(jid, item);
    }

    public static boolean fillAdapterFromCache(IMAddrBookListAdapter adapter, String filter) {
        if (adapter == null) {
            return false;
        }
        if (gCachedZoomOnlyItems != null) {
            boolean showOfflineBuddies = true;
            PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
            if (settingHelper != null) {
                showOfflineBuddies = settingHelper.getShowOfflineBuddies();
            }
            adapter.addItems(gCachedZoomOnlyItems.values(), showOfflineBuddies, filter);
            adapter.clear();
            adapter.addItems(gCachedZoomOnlyItems.values());
            return true;
        }
        return false;
    }

    public static boolean removeCachedItemWithJid(String jid) {
        if (StringUtil.isEmptyOrNull((String)jid) || gCachedZoomOnlyItems == null) {
            return false;
        }
        return gCachedZoomOnlyItems.remove(jid) != null;
    }

    public IMAddrBookListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public IMAddrBookListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public IMAddrBookListView(Context context) {
        super(context);
        this.initView();
    }

    public void setParentFragment(IMAddrBookListFragment fragment) {
        this.mFragment = fragment;
    }

    private void refreshBuddyVcards() {
        List<String> jids = this.mAdapter.getWaitRefreshJids();
        HashSet<String> cache = new HashSet<String>();
        int maxNums = this.getListView().getChildCount() * 2;
        for (int i = jids.size() - 1; i >= 0; --i) {
            cache.add(jids.get(i));
            if (cache.size() >= maxNums) break;
        }
        if (cache.size() == 0) {
            return;
        }
        this.mAdapter.clearWaitRefreshJids();
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ArrayList<String> temp = new ArrayList<String>();
        temp.addAll(cache);
        for (String jid : cache) {
            messenger.refreshBuddyVCard(jid);
        }
        if (temp.size() > 0 && messenger.isAnyBuddyGroupLarge()) {
            messenger.getBuddiesPresence(temp, false);
        }
    }

    public void onBuddyListUpdate() {
        if (this.mFragment != null && !this.mFragment.isResumed()) {
            this.mPendingNeedNotifyDataSetChange = true;
        } else {
            this.loadAllBuddies(this.mAdapter);
        }
    }

    public void onBuddyInfoUpdate(List<String> presenceChangeJids, List<String> infoChangeJids) {
        if (this.mFragment != null && !this.mFragment.isResumed()) {
            this.mPendingInfoChangeJids.addAll(infoChangeJids);
            this.mPendingPresenceChangeJids.addAll(presenceChangeJids);
            return;
        }
        if (!(this.isShowOfflineBuddies() || CollectionsUtil.isListEmpty(infoChangeJids) && CollectionsUtil.isListEmpty(presenceChangeJids))) {
            this.loadAllBuddies(this.mAdapter);
            return;
        }
        if (CollectionsUtil.isListEmpty(infoChangeJids)) {
            if (this.mScorllState == 2 || CollectionsUtil.isListEmpty(presenceChangeJids)) {
                return;
            }
            if (this.mAdapter.getCount() < 10) {
                this.loadAllBuddies(this.mAdapter);
                return;
            }
            ListView listView = this.getListView();
            for (int i = 0; i < listView.getChildCount(); ++i) {
                IMAddrBookItemView view;
                IMAddrBookItem item;
                View childView = listView.getChildAt(i);
                if (!(childView instanceof IMAddrBookItemView) || (item = (view = (IMAddrBookItemView)childView).getDataItem()) == null || !presenceChangeJids.contains(item.getJid())) continue;
                view.setAddrBookItem(item, item.getNeedIndicateZoomUser(), false, false);
            }
        } else {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    private void initView() {
        this.mAdapter = new IMAddrBookListAdapter(this.getContext(), this);
        if (this.isInEditMode()) {
            this._editmode_loadAllItems(this.mAdapter);
        }
        this.setAdapter(this.mAdapter);
        this.setOnItemClickListener(this);
        this.setOnItemLongClickListener(this);
        this.setPullDownRefreshTextResources(R.string.zm_lbl_release_to_refresh, R.string.zm_lbl_pull_down_to_refresh, R.string.zm_msg_loading);
        this.setPullDownRefreshListener(this);
        this.getListView().setOnScrollListener((AbsListView.OnScrollListener)this);
        this.getListView().setDivider(null);
        this.getListView().setDividerHeight(0);
        this.addHeaderViews();
    }

    private void addHeaderViews() {
        View view = View.inflate((Context)this.getContext(), (int)R.layout.zm_addrbook_item, null);
        view.setPadding(0, UIUtil.dip2px((Context)this.getContext(), (float)10.0f), 0, UIUtil.dip2px((Context)this.getContext(), (float)10.0f));
        TextView txtScreenName = (TextView)view.findViewById(R.id.txtScreenName);
        TextView txtCustomMessage = (TextView)view.findViewById(R.id.txtCustomMessage);
        txtScreenName.setText(R.string.zm_lbl_my_contacts_33300);
        txtCustomMessage.setText(R.string.zm_lbl_my_contacts_des_33300);
        view.findViewById(R.id.presenceStateView).setVisibility(8);
        AvatarView avatarView = (AvatarView)view.findViewById(R.id.avatarView);
        avatarView.setAvatar(R.drawable.zm_ic_my_phone_contacts);
        this.getListView().addHeaderView(view);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (IMAddrBookListView.this.mFragment != null) {
                    IMAddrBookListView.this.mFragment.showPhoneContactsInZoom();
                }
            }
        });
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mHandler.sendEmptyMessageDelayed(1, 2000L);
    }

    protected void onDetachedFromWindow() {
        this.mHandler.removeMessages(1);
        super.onDetachedFromWindow();
    }

    private void _editmode_loadAllItems(IMAddrBookListAdapter adapter) {
        String isoCountryCode = CountryCodeUtil.getIsoCountryCode((Context)VideoBoxApplication.getInstance());
        String phoneCountryCode = CountryCodeUtil.isoCountryCode2PhoneCountryCode((String)isoCountryCode);
        for (int i = 0; i < 4; ++i) {
            IMAddrBookItem item = new IMAddrBookItem();
            item.setContactId(i + 20000);
            item.setScreenName("Zoom User " + i);
            item.setSortKey(item.getScreenName());
            item.addPhoneNumber("+861380000000" + String.valueOf(i), null, phoneCountryCode);
            item.setIsZoomUser(true);
            adapter.addItem(item);
        }
    }

    private void loadAllBuddies(IMAddrBookListAdapter adapter) {
        this.setFooterDividersEnabled(true);
        this.setPullDownRefreshEnabled(PTApp.getInstance().isPhoneNumberRegistered());
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        ABContactsCache cache = null;
        String myNumber = null;
        boolean isPhoneNumberRegistered = PTApp.getInstance().isPhoneNumberRegistered();
        if (isPhoneNumberRegistered) {
            cache = ABContactsCache.getInstance();
            if (!cache.isCached() && !cache.reloadAllContacts()) {
                return;
            }
            ABContactsHelper contactsHelper = PTApp.getInstance().getABContactsHelper();
            if (contactsHelper != null) {
                myNumber = contactsHelper.getVerifiedPhoneNumber();
            }
        }
        HashMap<String, IMAddrBookItem> listAllBuddies = new HashMap<String, IMAddrBookItem>();
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZMBuddySyncInstance instance = ZMBuddySyncInstance.getInsatance();
        List<IMAddrBookItem> data = instance.getAllBuddies();
        if (data == null) {
            return;
        }
        for (IMAddrBookItem item : data) {
            if (item.isZoomRoomContact() || !(item.isPropertyInit() ? messenger.isMyContactOrPending(item.getJid()) : item.isMyContact() || item.isPending()) || !StringUtil.isEmptyOrNull((String)myNumber) && StringUtil.isSameString((String)myNumber, (String)item.getBuddyPhoneNumber())) continue;
            int contactId = 0;
            if (cache != null) {
                ABContactsCache.Contact localContact = cache.getFirstContactByPhoneNumber(item.getBuddyPhoneNumber());
                if (localContact != null) {
                    contactId = localContact.contactId;
                }
                item.setIsMobileOnline(item.getIsMobileOnline() || contactId >= 0 && !item.getIsDesktopOnline() && !item.isMyContact());
            }
            if (!this.isShowOfflineBuddies() && !item.getIsDesktopOnline() && !item.getIsMobileOnline()) continue;
            listAllBuddies.put(item.getJid(), item);
        }
        IMAddrBookListView.cacheItems(listAllBuddies);
        IMAddrBookListView.fillAdapterFromCache(adapter, this.mFilter);
        this.mAdapter.notifyDataSetChanged();
    }

    private IMAddrBookItem newAddrBookItemFromZoomBuddy(ZoomMessenger messenger, ZoomBuddy buddy, String myNumber, ABContactsCache cache, boolean acceptNonBuddy, boolean isPhoneNumberRegistered) {
        IMAddrBookItem item = IMAddrBookItem.fromZoomBuddy(buddy);
        if (!StringUtil.isEmptyOrNull((String)myNumber) && myNumber.equals(buddy.getPhoneNumber())) {
            return null;
        }
        boolean isBuddy = messenger.isMyContact(buddy.getJid());
        if (!(acceptNonBuddy || isBuddy || isPhoneNumberRegistered && (item == null || item.getContactId() >= 0))) {
            return null;
        }
        return item;
    }

    public void addBuddyWithJid(String jid) {
        IMAddrBookItem item;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
        if (buddy == null) {
            return;
        }
        ABContactsCache cache = null;
        String myNumber = null;
        boolean isPhoneNumberRegistered = PTApp.getInstance().isPhoneNumberRegistered();
        if (isPhoneNumberRegistered) {
            cache = ABContactsCache.getInstance();
            ABContactsHelper contactsHelper = PTApp.getInstance().getABContactsHelper();
            if (contactsHelper != null) {
                myNumber = contactsHelper.getVerifiedPhoneNumber();
            }
        }
        if ((item = this.newAddrBookItemFromZoomBuddy(messenger, buddy, myNumber, cache, false, isPhoneNumberRegistered)) == null || item.isZoomRoomContact()) {
            return;
        }
        if (!(this.isShowOfflineBuddies() || item.getIsDesktopOnline() || item.getIsMobileOnline())) {
            return;
        }
        IMAddrBookListView.addCachedItemWithJid(jid, item);
        IMAddrBookListView.fillAdapterFromCache(this.mAdapter, this.mFilter);
    }

    public void onAddBuddyByJidSuccess(String jid) {
        this.addBuddyWithJid(jid);
    }

    public void updateBuddyInfoWithJid(String jid) {
        IMAddrBookItem item;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
        if (buddy == null) {
            return;
        }
        ABContactsCache cache = null;
        String myNumber = null;
        boolean isPhoneNumberRegistered = PTApp.getInstance().isPhoneNumberRegistered();
        if (isPhoneNumberRegistered) {
            cache = ABContactsCache.getInstance();
            ABContactsHelper contactsHelper = PTApp.getInstance().getABContactsHelper();
            if (contactsHelper != null) {
                myNumber = contactsHelper.getVerifiedPhoneNumber();
            }
        }
        if ((item = this.newAddrBookItemFromZoomBuddy(messenger, buddy, myNumber, cache, false, isPhoneNumberRegistered)) == null || item.isZoomRoomContact()) {
            return;
        }
        boolean showOffline = this.isShowOfflineBuddies();
        if (!showOffline) {
            if (item.getIsDesktopOnline() || item.getIsMobileOnline()) {
                boolean isGroupOn = PTApp.getInstance().isSyncUserGroupON();
                if (isGroupOn) {
                    ZoomBuddyGroup group = messenger.getBuddyGroupByType(1);
                    if (group != null && group.hasBuddy(item.getJid())) {
                        return;
                    }
                    group = messenger.getBuddyGroupByType(2);
                    if (group != null && group.hasBuddy(item.getJid())) {
                        return;
                    }
                }
                IMAddrBookListView.addCachedItemWithJid(jid, item);
            } else {
                IMAddrBookListView.removeCachedItemWithJid(jid);
            }
        } else {
            IMAddrBookListView.updateCachedItemWithJid(jid, item);
        }
        IMAddrBookListView.fillAdapterFromCache(this.mAdapter, this.mFilter);
    }

    public void reloadAllItems() {
        this.reloadAllItems(false);
    }

    public void reloadAllItems(boolean disableLazyLoadAvatar) {
        boolean needReloadAll;
        if (this.mFragment != null && !this.mFragment.isResumed()) {
            return;
        }
        boolean bl = needReloadAll = this.mAdapter.getCount() == 0 || this.mPendingNeedNotifyDataSetChange;
        if (needReloadAll) {
            this.mAdapter.clear();
            this.loadAllBuddies(this.mAdapter);
            this.mAdapter.notifyDataSetChanged();
        } else {
            this.onBuddyInfoUpdate(this.mPendingPresenceChangeJids, this.mPendingInfoChangeJids);
        }
        this.mPendingNeedNotifyDataSetChange = false;
        this.mPendingInfoChangeJids.clear();
        this.mPendingPresenceChangeJids.clear();
    }

    public int getContactsItemCount() {
        return this.mAdapter.getContactsItemCount();
    }

    public void onNotifySubscribeRequestUpdated(String jid) {
        if (StringUtil.isEmptyOrNull((String)jid)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (messenger.isMyContact(jid)) {
            this.addBuddyWithJid(jid);
        } else if (IMAddrBookListView.removeCachedItemWithJid(jid)) {
            IMAddrBookListView.fillAdapterFromCache(this.mAdapter, this.mFilter);
        }
    }

    public void onNotifySubscriptionDenied(String jid) {
        if (IMAddrBookListView.removeCachedItemWithJid(jid)) {
            IMAddrBookListView.fillAdapterFromCache(this.mAdapter, this.mFilter);
        }
    }

    public void onZoomMessengerConnectReturn() {
        boolean isBackground = this.mFragment != null && !this.mFragment.isResumed();
        ListView listView = this.getListView();
        for (int i = 0; i < listView.getChildCount(); ++i) {
            IMAddrBookItemView view;
            IMAddrBookItem item;
            View childView = listView.getChildAt(i);
            if (!(childView instanceof IMAddrBookItemView) || (item = (view = (IMAddrBookItemView)childView).getDataItem()) == null) continue;
            if (isBackground) {
                this.mPendingPresenceChangeJids.add(item.getJid());
                continue;
            }
            view.setAddrBookItem(item, item.getNeedIndicateZoomUser(), false, false);
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Object obj = this.getItemAtPosition(position);
        if (obj == null) {
            return;
        }
        if (obj instanceof IMAddrBookItem) {
            IMAddrBookItem item = (IMAddrBookItem)obj;
            this.onItemClick(item);
        } else if (obj instanceof IMAddrBookListAdapter.ItemOtherContacts) {
            IMAddrBookListAdapter.ItemOtherContacts item = (IMAddrBookListAdapter.ItemOtherContacts)obj;
            switch (item.type) {
                case 0: {
                    this.showZoomContacts();
                    break;
                }
                case 1: {
                    this.showGoogleContacts();
                    break;
                }
                case 2: {
                    this.showFacebookContacts();
                }
            }
        }
    }

    private void showFacebookContacts() {
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity != null) {
            IMBuddyListFragment.showAsActivity(activity);
        }
    }

    private void showGoogleContacts() {
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity != null) {
            IMBuddyListFragment.showAsActivity(activity);
        }
    }

    private void showZoomContacts() {
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity != null) {
            IMFavoriteListFragment.showAsActivity(activity);
        }
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
        return false;
    }

    private void onItemClick(IMAddrBookItem item) {
        if (item.isPending()) {
            return;
        }
        this.showUserActions(item);
    }

    public void showUserActions(IMAddrBookItem item) {
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        AddrBookItemDetailsActivity.show(activity, item, 106);
    }

    public void onRestoreInstanceState(Parcelable state) {
        Parcelable superState = null;
        if (state instanceof Bundle) {
            Bundle allState = (Bundle)state;
            superState = allState.getParcelable("IMAddrBookListView.superState");
            this.mFilter = allState.getString("IMAddrBookListView.mFilter");
        } else {
            superState = state;
        }
        super.onRestoreInstanceState(superState);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle bundle = new Bundle();
        bundle.putParcelable("IMAddrBookListView.superState", superState);
        bundle.putString("IMAddrBookListView.mFilter", this.mFilter);
        return bundle;
    }

    public void setFilter(String filter) {
        this.mFilter = filter;
    }

    public String getFilter() {
        return this.mFilter;
    }

    public void filter(String filter) {
        if (filter == null) {
            filter = "";
        }
        filter = filter.trim().toLowerCase(CompatUtils.getLocalDefault());
        String oldFilter = this.mFilter;
        this.mFilter = filter;
        if (oldFilter == null) {
            oldFilter = "";
        }
        if (oldFilter.equals(filter)) {
            return;
        }
        if (!StringUtil.isEmptyOrNull((String)filter)) {
            if (!StringUtil.isEmptyOrNull((String)oldFilter) && filter.contains(oldFilter)) {
                this.mAdapter.setHasWebSearchResults(false);
                this.mAdapter.filter(filter);
                this.mAdapter.notifyDataSetChanged();
            } else {
                this.reloadAllItems();
            }
        } else {
            this.reloadAllItems();
        }
    }

    public void onPullDownRefresh() {
        int ret = this.startABMatching();
        if (ret != 0) {
            this.notifyRefreshDone();
        }
    }

    public int startABMatching() {
        Context context = this.getContext();
        if (context == null) {
            return 11;
        }
        if (!PTApp.getInstance().isWebSignedOn()) {
            return 9;
        }
        return ContactsMatchHelper.getInstance().matchAllNumbers(context);
    }

    public void onPhoneABMatchUpdated(long result) {
        this.notifyRefreshDone();
    }

    public void updateUnreadMessageCountBubble() {
        this.mAdapter.notifyDataSetChanged();
    }

    public void onClickSearchMore() {
        if (StringUtil.isEmptyOrNull((String)this.mFilter)) {
            return;
        }
        if (this.mFragment == null) {
            return;
        }
        this.mFragment.searchMore(this.mFilter);
    }

    public void onClickSavedSession() {
        if (this.mFragment == null) {
            return;
        }
        this.mFragment.gotoSavedSessions();
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        this.mScorllState = scrollState;
        if (scrollState == 2) {
            this.mHandler.removeMessages(1);
        } else if (!this.mHandler.hasMessages(1)) {
            this.mHandler.sendEmptyMessageDelayed(1, 1000L);
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
    }

    private boolean isShowOfflineBuddies() {
        PTSettingHelper settingHelper;
        boolean showOfflineBuddies = true;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (!(messenger != null && messenger.isAnyBuddyGroupLarge() || (settingHelper = PTApp.getInstance().getSettingHelper()) == null)) {
            showOfflineBuddies = settingHelper.getShowOfflineBuddies();
        }
        return showOfflineBuddies;
    }
}

