/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.ZMBitmapFactory;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.PresenceStateView;
import java.io.File;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class IMAddrBookItemView
extends LinearLayout {
    protected IMAddrBookItem mItem;
    private TextView mTxtScreenName;
    private AvatarView mAvatarView;
    protected TextView mTxtCustomMessage;
    private TextView mWaitApproval;
    protected PresenceStateView mPresenceStateView;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    boolean needIndicateZoomUser = msg.arg1 == 1;
                    boolean disableLazyLoadAvatar = msg.arg2 == 1;
                    IMAddrBookItemView.this.refreshUI(needIndicateZoomUser, disableLazyLoadAvatar);
                    break;
                }
            }
        }
    };
    private static final int MSG_LAZY_REFRESH_UI = 1;

    public IMAddrBookItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public IMAddrBookItemView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.inflateLayout();
        this.mTxtScreenName = (TextView)this.findViewById(R.id.txtScreenName);
        this.mAvatarView = (AvatarView)this.findViewById(R.id.avatarView);
        this.mTxtCustomMessage = (TextView)this.findViewById(R.id.txtCustomMessage);
        this.mWaitApproval = (TextView)this.findViewById(R.id.waitApproval);
        this.mPresenceStateView = (PresenceStateView)this.findViewById(R.id.presenceStateView);
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_addrbook_item, (ViewGroup)this);
    }

    public void setScreenName(CharSequence name) {
        if (name != null) {
            this.mTxtScreenName.setText(name);
            this.mAvatarView.setName(name);
        }
    }

    public void setAvatar(String imgPathName) {
        this.mAvatarView.setAvatar(imgPathName);
    }

    public void setAvatar(Bitmap bitmap) {
        this.mAvatarView.setAvatar(bitmap);
    }

    public void setAvatar(Drawable drawable2) {
        this.mAvatarView.setAvatar(drawable2);
    }

    public IMAddrBookItem getDataItem() {
        return this.mItem;
    }

    private void refreshUI(boolean needIndicateZoomUser, boolean disableLazyLoadAvatar) {
        if (this.mItem == null) {
            return;
        }
        this.setScreenName(this.mItem.isPending() ? this.mItem.getAccountEmail() : this.mItem.getScreenName());
        if (this.mAvatarView != null) {
            this.mAvatarView.setBgColorSeedString(this.mItem.getJid());
        }
        if (this.isInEditMode()) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy buddy = messenger.getBuddyWithJID(this.mItem.getJid());
        if (buddy == null) {
            this.mWaitApproval.setVisibility(8);
            this.mTxtCustomMessage.setVisibility(8);
            this.mPresenceStateView.setVisibility(4);
            this.setAvatar((String)null);
            return;
        }
        this.mPresenceStateView.setState(this.mItem);
        if (this.mItem.isPending()) {
            this.mTxtCustomMessage.setVisibility(8);
            this.mPresenceStateView.setVisibility(8);
            this.mWaitApproval.setVisibility(0);
        } else {
            this.mWaitApproval.setVisibility(8);
        }
        String customMessage = this.mItem.getSignature();
        if (StringUtil.isEmptyOrNull((String)customMessage)) {
            this.mTxtCustomMessage.setVisibility(8);
        } else {
            this.mTxtCustomMessage.setVisibility(0);
            this.mTxtCustomMessage.setText((CharSequence)customMessage);
        }
        Context context = this.getContext();
        if (context == null) {
            this.setAvatar((String)null);
            return;
        }
        if (disableLazyLoadAvatar) {
            this.loadAvatar(this.mItem, buddy, context, false);
        } else if (!this.loadAvatar(this.mItem, buddy, context, true)) {
            this.lazyLoadContactAvatar(this.mItem, context);
        }
    }

    public void setAddrBookItem(IMAddrBookItem item, boolean needIndicateZoomUser, boolean disableLazyLoadAvatar, boolean disableLazyLoadBuddy) {
        if (item == null) {
            return;
        }
        this.mItem = item;
        this.setScreenName(this.mItem.isPending() ? this.mItem.getAccountEmail() : this.mItem.getScreenName());
        this.mHandler.removeMessages(1);
        if (item.isPropertyInit() || disableLazyLoadBuddy) {
            this.refreshUI(needIndicateZoomUser, disableLazyLoadAvatar);
        } else {
            this.updateViewWhenBuddyNotInit();
            Message msg = this.mHandler.obtainMessage(1, needIndicateZoomUser ? 1 : 0, disableLazyLoadAvatar ? 1 : 0);
            this.mHandler.sendMessageDelayed(msg, 150L);
        }
    }

    private void updateViewWhenBuddyNotInit() {
        if (this.mAvatarView != null) {
            this.mAvatarView.setBgColorSeedString(this.mItem.getJid());
        }
        this.mPresenceStateView.resetState();
    }

    private void lazyLoadContactAvatar(final IMAddrBookItem item, final Context context) {
        this.setAvatar((String)null);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (IMAddrBookItemView.this.mItem != item) {
                    return;
                }
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger == null) {
                    return;
                }
                ZoomBuddy buddy = messenger.getBuddyWithJID(IMAddrBookItemView.this.mItem.getJid());
                if (buddy == null) {
                    return;
                }
                IMAddrBookItemView.this.loadAvatar(item, buddy, context, false);
            }
        }, 300L);
    }

    private boolean loadAvatar(IMAddrBookItem item, ZoomBuddy buddy, Context context, boolean fromMemCacheOnly) {
        Bitmap bitmap;
        File file;
        String avatar;
        if (buddy != null && !StringUtil.isEmptyOrNull((String)(avatar = buddy.getLocalPicturePath())) && (file = new File(avatar)).exists() && file.isFile() && (bitmap = ZMBitmapFactory.decodeFile(avatar, fromMemCacheOnly)) != null) {
            this.setAvatar(bitmap);
            return true;
        }
        if (item != null) {
            Bitmap bitmap2 = item.getAvatarBitmap(context, fromMemCacheOnly);
            this.setAvatar(bitmap2);
            if (bitmap2 != null) {
                return true;
            }
        }
        return false;
    }
}

