/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.provider.ContactsContract;
import android.view.View;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.ABContactsCache;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.BuddyNameUtil;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.ContactsAvatarCache;
import com.zipow.videobox.util.ZMBitmapFactory;
import com.zipow.videobox.view.IMAddrBookItemView;
import com.zipow.videobox.view.sip.IMAddrSipItemView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.PhoneNumberUtil;
import us.zoom.androidlib.util.SortUtil;
import us.zoom.androidlib.util.StringUtil;

public class IMAddrBookItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TAG = IMAddrBookItem.class.getSimpleName();
    private String screenName = "";
    private String sortKey = "";
    private boolean isZoomUser = false;
    private int contactId = 0;
    private ArrayList<PhoneNumber> numbers = new ArrayList();
    private ArrayList<String> emails = new ArrayList();
    private boolean isEmailLoaded = false;
    private boolean needIndicateZoomUser = true;
    private String jid = "";
    private String avatarPath = null;
    private String accountEmail = null;
    private boolean isDesktopOnline = false;
    private boolean isMobileOnline = false;
    private int presence = 0;
    private String signature;
    private boolean isFromWebSearch = false;
    private boolean isPending;
    private boolean mIsZoomRoomContact = false;
    private boolean mIsInit = false;
    private boolean mIsBlocked = false;
    private String buddyPhoneNumber;
    private long pmi;
    private String personLink;
    private boolean isRobot;
    private String robotCmdPrefix;
    private String profileCountryCode;
    private String profilePhoneNumber;
    private String sipPhoneNumber;
    private boolean isMyContact;
    private boolean isManualInput;

    public IMAddrBookItem() {
    }

    public IMAddrBookItem(String jid, String screenName, String phoneNumber, boolean isMyContact, boolean isDesktopOnLine, boolean isMobileOnLine, String accountEmail, boolean isRoom, String sipPhoneNumber) {
        this.jid = jid;
        if (!StringUtil.isEmptyOrNull((String)screenName)) {
            screenName = screenName.trim();
        }
        this.screenName = screenName;
        this.sortKey = SortUtil.getSortKey((String)screenName, (Locale)CompatUtils.getLocalDefault());
        this.buddyPhoneNumber = phoneNumber;
        this.isDesktopOnline = isDesktopOnLine;
        this.isMobileOnline = isMobileOnLine;
        this.isMyContact = isMyContact;
        this.accountEmail = accountEmail;
        this.mIsZoomRoomContact = isRoom;
        this.sipPhoneNumber = sipPhoneNumber;
    }

    public static IMAddrBookItem fromZoomBuddy(ZoomBuddy buddy) {
        IMAddrBookItem item = new IMAddrBookItem();
        if (item.init(buddy)) {
            return item;
        }
        return null;
    }

    public boolean isPropertyInit() {
        return this.mIsInit;
    }

    public boolean refreshBuddy() {
        this.mIsInit = false;
        String oldSortKey = this.getSortKey();
        this.init();
        String newSortKey = this.getSortKey();
        return !StringUtil.isSameString((String)oldSortKey, (String)newSortKey);
    }

    private boolean init(ZoomBuddy buddy) {
        ZoomMessenger messenger;
        String number;
        if (buddy == null) {
            return false;
        }
        if (this.mIsInit) {
            return true;
        }
        ABContactsCache cache = ABContactsCache.getInstance();
        String jid = buddy.getJid();
        String name = BuddyNameUtil.getBuddyDisplayName(buddy, null);
        String normalizedNumber = number = buddy.getPhoneNumber();
        String email = buddy.getEmail();
        String sortKey = null;
        sortKey = buddy.isPending() && !buddy.isRobot() ? email : SortUtil.getSortKey((String)name, (Locale)CompatUtils.getLocalDefault());
        boolean isDesktopOnline = buddy.isDesktopOnline();
        boolean isMobileOnline = buddy.isMobileOnline() || buddy.isPadOnline();
        int presence = buddy.getPresence();
        String signature = buddy.getSignature();
        String avatarPath = buddy.getLocalPicturePath();
        int contactId = -1;
        ABContactsCache.Contact localContact = null;
        if (cache != null && (localContact = cache.getFirstContactByPhoneNumber(normalizedNumber)) != null) {
            contactId = localContact.contactId;
        }
        if ((messenger = PTApp.getInstance().getZoomMessenger()) == null) {
            return false;
        }
        this.setContactId(contactId);
        this.setScreenName(name);
        this.addPhoneNumber(number, normalizedNumber);
        this.setSortKey(sortKey);
        this.setNeedIndicateZoomUser(false);
        this.setBuddyPhoneNumber(number);
        this.setJid(jid);
        this.setAccoutEmail(email);
        this.setIsZoomUser(true);
        this.setIsDesktopOnline(isDesktopOnline);
        this.setIsMobileOnline(isMobileOnline || contactId >= 0 && !isDesktopOnline && !messenger.isMyContact(jid));
        this.setPresence(presence);
        this.setSignature(signature);
        this.setAvatarPath(avatarPath);
        this.setPending(buddy.isPending());
        this.setZoomRoomContact(buddy.isZoomRoom());
        this.setBlocked(messenger.blockUserIsBlocked(jid));
        this.setPmi(buddy.getMeetingNumber());
        this.setPersonLink(buddy.getVanityUrl());
        this.setIsRobot(buddy.isRobot());
        this.setRobotCmdPrefix(buddy.getRobotCmdPrefix());
        this.setProfileCountryCode(buddy.getProfileCountryCode());
        this.setProfilePhoneNumber(buddy.getProfilePhoneNumber());
        this.setSipPhoneNumber(buddy.getSipPhoneNumber());
        this.setIsMyContact(messenger.isMyContact(jid));
        this.mIsInit = true;
        return true;
    }

    private void init() {
        if (StringUtil.isEmptyOrNull((String)this.jid)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy buddy = messenger.getBuddyWithJID(this.jid);
        if (buddy == null) {
            return;
        }
        this.init(buddy);
    }

    public View getView(Context context, View convertView, boolean disableLazyLoadAvatar, boolean disableLazyLoadBuddy) {
        IMAddrBookItemView view = null;
        view = convertView instanceof IMAddrBookItemView ? (IMAddrBookItemView)convertView : new IMAddrBookItemView(context);
        this.bindView(view, disableLazyLoadAvatar, disableLazyLoadBuddy);
        return view;
    }

    public View getSipView(Context context, View convertView, boolean disableLazyLoadAvatar, boolean disableLazyLoadBuddy) {
        IMAddrSipItemView view = null;
        view = convertView instanceof IMAddrSipItemView ? (IMAddrSipItemView)convertView : new IMAddrSipItemView(context);
        this.bindView(view, disableLazyLoadAvatar, disableLazyLoadBuddy);
        return view;
    }

    private void bindView(IMAddrBookItemView view, boolean disableLazyLoadAvatar, boolean disableLazyLoadBuddy) {
        view.setAddrBookItem(this, this.needIndicateZoomUser, disableLazyLoadAvatar, disableLazyLoadBuddy);
    }

    public boolean isMyContact() {
        return this.isMyContact;
    }

    public void setIsMyContact(boolean isMyContact) {
        this.isMyContact = isMyContact;
    }

    public void checkIsMyContact(ZoomMessenger messenger) {
        if (messenger == null || StringUtil.isEmptyOrNull((String)this.jid)) {
            return;
        }
        this.isMyContact = messenger.isMyContact(this.jid);
    }

    public void updatePresence(ZoomMessenger messenger) {
        if (messenger == null || StringUtil.isEmptyOrNull((String)this.jid)) {
            return;
        }
        ZoomBuddy buddy = messenger.getBuddyWithJID(this.jid);
        if (buddy == null) {
            return;
        }
        this.setIsDesktopOnline(buddy.isDesktopOnline());
        this.setPresence(buddy.getPresence());
        this.setSignature(buddy.getSignature());
        if (buddy.isMobileOnline()) {
            this.setIsMobileOnline(true);
        } else {
            this.setIsMobileOnline(this.contactId >= 0 && !this.isDesktopOnline && !messenger.isMyContact(this.jid));
        }
    }

    public void updatePicture(ZoomMessenger messenger) {
        if (messenger == null || StringUtil.isEmptyOrNull((String)this.jid)) {
            return;
        }
        ZoomBuddy buddy = messenger.getBuddyWithJID(this.jid);
        if (buddy == null) {
            return;
        }
        String avatarPath = buddy.getLocalPicturePath();
        this.setAvatarPath(avatarPath);
    }

    public String getScreenName() {
        return this.screenName;
    }

    public void setScreenName(String screenName) {
        if (screenName == null) {
            screenName = "";
        }
        this.screenName = screenName;
    }

    public boolean isManualInput() {
        return this.isManualInput;
    }

    public void setManualInput(boolean manualInput) {
        this.isManualInput = manualInput;
    }

    public void setSortKey(String sortKey) {
        this.sortKey = sortKey;
    }

    public String getSortKey() {
        return this.sortKey;
    }

    public String getAccountEmail() {
        return this.accountEmail;
    }

    public void setAccoutEmail(String email) {
        this.accountEmail = email;
    }

    public int getPhoneNumberCount() {
        this.init();
        return this.numbers.size();
    }

    public String getPhoneNumber(int index) {
        this.init();
        if (index < 0 || index > this.numbers.size()) {
            return null;
        }
        PhoneNumber number = this.numbers.get(index);
        if (number == null) {
            return null;
        }
        return number.number;
    }

    public String getNormalizedPhoneNumber(int index) {
        this.init();
        if (index < 0 || index >= this.numbers.size()) {
            return null;
        }
        PhoneNumber number = this.numbers.get(index);
        if (number == null) {
            return null;
        }
        return number.normalizedNumber;
    }

    public String addPhoneNumber(String phoneNumber, String normalizedNumber, String phoneCountryCode) {
        if (StringUtil.isEmptyOrNull((String)phoneNumber)) {
            return phoneNumber;
        }
        if (StringUtil.isEmptyOrNull((String)normalizedNumber)) {
            normalizedNumber = this.getNormalizedNumber(phoneNumber, phoneCountryCode);
        }
        if (this.normalizedNumberExists(normalizedNumber)) {
            return normalizedNumber;
        }
        PhoneNumber numberItem = new PhoneNumber();
        numberItem.number = phoneNumber;
        numberItem.normalizedNumber = normalizedNumber;
        this.numbers.add(numberItem);
        return normalizedNumber;
    }

    public String addPhoneNumber(String phoneNumber, String normalizedNumber) {
        return this.addPhoneNumber(phoneNumber, normalizedNumber, null);
    }

    public void clearPhoneNumbers() {
        this.numbers.clear();
    }

    private boolean normalizedNumberExists(String normalizedNumber) {
        if (normalizedNumber == null) {
            return false;
        }
        for (PhoneNumber number : this.numbers) {
            if (number == null || !normalizedNumber.equals(number.normalizedNumber)) continue;
            return true;
        }
        return false;
    }

    private String getNormalizedNumber(String phoneNumber, String phoneCountryCode) {
        this.init();
        String normalizedPhoneNumber = PhoneNumberUtil.formatNumber((String)phoneNumber, (String)phoneCountryCode);
        return normalizedPhoneNumber;
    }

    public boolean getIsZoomUser() {
        this.init();
        return this.isZoomUser;
    }

    public void setIsZoomUser(boolean isZoomUser) {
        this.isZoomUser = isZoomUser;
    }

    public int getContactId() {
        this.init();
        return this.contactId;
    }

    public void setContactId(int contactId) {
        this.contactId = contactId;
    }

    public int getEmailCount() {
        this.init();
        if (this.isEmailLoaded) {
            return this.emails.size();
        }
        return this.loadEmails();
    }

    public String getEmail(int index) {
        this.init();
        if (index < 0 || index >= this.emails.size()) {
            return null;
        }
        return this.emails.get(index);
    }

    public String getJid() {
        return this.jid;
    }

    public void setJid(String jid) {
        this.jid = jid;
    }

    public void setNeedIndicateZoomUser(boolean needIndicateZoomUser) {
        this.needIndicateZoomUser = needIndicateZoomUser;
    }

    public boolean getNeedIndicateZoomUser() {
        return this.needIndicateZoomUser;
    }

    public String getAvatarPath() {
        this.init();
        return this.avatarPath;
    }

    public void setAvatarPath(String avatarPath) {
        this.avatarPath = avatarPath;
    }

    public boolean getIsDesktopOnline() {
        return this.isDesktopOnline;
    }

    public void setIsDesktopOnline(boolean isDesktopOnline) {
        this.isDesktopOnline = isDesktopOnline;
    }

    public boolean getIsMobileOnline() {
        return this.isMobileOnline;
    }

    public void setIsMobileOnline(boolean isMobileOnline) {
        this.isMobileOnline = isMobileOnline;
    }

    public int getPresence() {
        this.init();
        return this.presence;
    }

    public void setPresence(int presence) {
        this.presence = presence;
    }

    public String getSignature() {
        this.init();
        return this.signature;
    }

    public void setSignature(String message) {
        if (message != null) {
            message = message.trim();
        }
        this.signature = message;
    }

    public boolean isFromWebSearch() {
        this.init();
        return this.isFromWebSearch;
    }

    public void setIsFromWebSearch(boolean isFromWebSearch) {
        this.isFromWebSearch = isFromWebSearch;
    }

    private int loadEmails() {
        this.init();
        if (this.contactId == 0) {
            return 0;
        }
        VideoBoxApplication context = VideoBoxApplication.getInstance();
        String[] projection = new String[]{"_id", "data1", "data2"};
        String selection = "contact_id = ?";
        String[] selectionArgs = new String[]{String.valueOf(this.contactId)};
        Cursor cursor = context.getContentResolver().query(ContactsContract.CommonDataKinds.Email.CONTENT_URI, projection, selection, selectionArgs, null);
        if (cursor != null) {
            boolean hasItem = cursor.moveToFirst();
            while (hasItem) {
                String address = cursor.getString(1);
                if (!StringUtil.isEmptyOrNull((String)address) && !this.emailExists(address)) {
                    this.emails.add(address);
                }
                hasItem = cursor.moveToNext();
            }
            cursor.close();
        }
        this.isEmailLoaded = true;
        return this.emails.size();
    }

    private boolean emailExists(String address) {
        String lower = address.toLowerCase(CompatUtils.getLocalDefault());
        for (String email : this.emails) {
            if (!email.toLowerCase(CompatUtils.getLocalDefault()).equals(lower)) continue;
            return true;
        }
        return false;
    }

    public Bitmap getAvatarBitmap(Context context) {
        this.init();
        return this.getAvatarBitmap(context, false);
    }

    public Bitmap getAvatarBitmap(Context context, boolean fromMemCacheOnly) {
        Bitmap bmp;
        this.init();
        if (!StringUtil.isEmptyOrNull((String)this.avatarPath) && (bmp = ZMBitmapFactory.decodeFile(this.avatarPath, fromMemCacheOnly)) != null) {
            return bmp;
        }
        return ContactsAvatarCache.getInstance().getContactAvatar(context, this.getContactId(), fromMemCacheOnly);
    }

    public boolean equals(Object o) {
        this.init();
        if (o instanceof IMAddrBookItem) {
            return StringUtil.isSameString((String)this.jid, (String)((IMAddrBookItem)o).jid);
        }
        return false;
    }

    public int hashCode() {
        this.init();
        if (this.jid != null) {
            return this.jid.hashCode();
        }
        return super.hashCode();
    }

    public boolean isPending() {
        this.init();
        return this.isPending;
    }

    public void setPending(boolean isPending) {
        this.isPending = isPending;
    }

    public boolean isZoomRoomContact() {
        return this.mIsZoomRoomContact;
    }

    public void setZoomRoomContact(boolean isZoomRoomContact) {
        this.mIsZoomRoomContact = isZoomRoomContact;
    }

    public String getBuddyPhoneNumber() {
        this.init();
        return this.buddyPhoneNumber;
    }

    public void setBuddyPhoneNumber(String buddyPhoneNumber) {
        this.buddyPhoneNumber = buddyPhoneNumber;
    }

    public boolean isBlocked() {
        return this.mIsBlocked;
    }

    public void setBlocked(boolean isBlocked) {
        this.mIsBlocked = isBlocked;
    }

    public long getPmi() {
        return this.pmi;
    }

    public void setPmi(long pmi) {
        this.pmi = pmi;
    }

    public String getPersonLink() {
        return this.personLink;
    }

    public void setPersonLink(String personLink) {
        this.personLink = personLink;
    }

    public boolean getIsRobot() {
        return this.isRobot;
    }

    public void setIsRobot(boolean isRobot) {
        this.isRobot = isRobot;
    }

    public String getRobotCmdPrefix() {
        return this.robotCmdPrefix;
    }

    public void setRobotCmdPrefix(String robotCmdPrefix) {
        this.robotCmdPrefix = robotCmdPrefix;
    }

    public String getProfilePhoneNumber() {
        return this.profilePhoneNumber;
    }

    public void setProfilePhoneNumber(String profilePhoneNumber) {
        this.profilePhoneNumber = profilePhoneNumber;
    }

    public String getProfileCountryCode() {
        return this.profileCountryCode;
    }

    public void setProfileCountryCode(String profileCountryCode) {
        this.profileCountryCode = profileCountryCode;
    }

    public String getSipPhoneNumber() {
        return this.sipPhoneNumber;
    }

    public void setSipPhoneNumber(String sipPhoneNumber) {
        this.sipPhoneNumber = sipPhoneNumber;
    }

    static class PhoneNumber
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String number;
        String normalizedNumber;

        PhoneNumber() {
        }
    }
}

