/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.util.ImageLoader;
import com.zipow.videobox.view.ZMGifView;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class GiphyPreviewView
extends LinearLayout {
    private GridView mGridView;
    private TextView mBtnBack;
    private ProgressBar mProgressBar;
    private TextView mEmptyViewTxt;
    private EditText mSearchBar;
    private TextView mSearchBtn;
    private View mPreviewLinear;
    private GiphyPreviewAdapter mGiphyAdapter;
    private List<GiphyPreviewItem> mList = new ArrayList<GiphyPreviewItem>();
    public static final int MODE_EMPTY_VIEW_PROGRESS = 0;
    public static final int MODE_EMPTY_VIEW_NO_MATCH = 1;
    public static final int MODE_EMPTY_VIEW_NET_ERROR = 2;
    private int mMode = 0;
    private OnSearchListener mSearchListener;
    private OnGiphyPreviewItemClickListener mGiphyPreviewItemClickListener;
    private OnBackClickListener mOnBackClickListener;

    public GiphyPreviewView(Context context) {
        super(context);
        this.initView(context);
    }

    public GiphyPreviewView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public GiphyPreviewView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    public GiphyPreviewView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context);
    }

    public void setPreviewVisible(int visible) {
        this.mPreviewLinear.setVisibility(visible);
    }

    private void initView(Context context) {
        GiphyPreviewView.inflate((Context)context, (int)R.layout.zm_giphy_preview, (ViewGroup)this);
        this.mGridView = (GridView)this.findViewById(R.id.giphy_preview_gridView);
        this.mGridView.setEmptyView(this.findViewById(R.id.giphy_preview_emptyView));
        this.mBtnBack = (TextView)this.findViewById(R.id.giphy_preview_btn_back);
        this.mSearchBar = (EditText)this.findViewById(R.id.giphy_preview_search_bar);
        this.mSearchBtn = (TextView)this.findViewById(R.id.giphy_preview_search_btn);
        this.mPreviewLinear = this.findViewById(R.id.giphy_preview_linear);
        this.mEmptyViewTxt = (TextView)this.findViewById(R.id.giphy_preview_text);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.giphy_preview_progress);
        this.updateEmptyViewMode(this.mMode);
        if (this.hasData()) {
            this.mGridView.setVisibility(0);
            this.mGiphyAdapter = new GiphyPreviewAdapter(this.getContext(), this.mList);
            this.setAdapter((ListAdapter)this.mGiphyAdapter);
        }
        this.mBtnBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (GiphyPreviewView.this.mOnBackClickListener != null) {
                    GiphyPreviewView.this.mOnBackClickListener.onBackClick(v);
                }
            }
        });
        this.mSearchBar.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if ((actionId == 3 || event != null && event.getKeyCode() == 84) && (event == null || event.getAction() == 1)) {
                    String content = GiphyPreviewView.this.mSearchBar.getText().toString().trim();
                    GiphyPreviewView.this.onSearch(content);
                    return true;
                }
                return false;
            }
        });
        this.mSearchBar.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (TextUtils.isEmpty((CharSequence)s)) {
                    GiphyPreviewView.this.onSearch("");
                    GiphyPreviewView.this.mSearchBtn.setVisibility(8);
                } else {
                    GiphyPreviewView.this.mSearchBtn.setVisibility(0);
                }
            }
        });
        this.mSearchBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String content = GiphyPreviewView.this.mSearchBar.getText().toString().trim();
                GiphyPreviewView.this.onSearch(content);
            }
        });
        this.mGridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (GiphyPreviewView.this.mGiphyAdapter != null && GiphyPreviewView.this.mGiphyPreviewItemClickListener != null) {
                    GiphyPreviewView.this.mGiphyPreviewItemClickListener.onGiphyPreviewItemClick((GiphyPreviewItem)GiphyPreviewView.this.mGiphyAdapter.getItem(position));
                }
            }
        });
    }

    public void updateEmptyViewMode(int mode) {
        switch (mode) {
            case 0: {
                this.mMode = mode;
                this.mProgressBar.setVisibility(0);
                this.mEmptyViewTxt.setVisibility(8);
                break;
            }
            case 1: {
                this.mMode = mode;
                this.mProgressBar.setVisibility(8);
                this.mEmptyViewTxt.setVisibility(0);
                this.mEmptyViewTxt.setText((CharSequence)this.getResources().getString(R.string.zm_mm_giphy_preview_no_match_22379));
                break;
            }
            case 2: {
                this.mMode = mode;
                this.mProgressBar.setVisibility(8);
                this.mEmptyViewTxt.setVisibility(0);
                this.mEmptyViewTxt.setText((CharSequence)this.getResources().getString(R.string.zm_mm_giphy_preview_net_error_22379));
                break;
            }
            default: {
                this.mProgressBar.setVisibility(0);
                this.mEmptyViewTxt.setVisibility(8);
            }
        }
    }

    private void onSearch(String content) {
        if (NetworkUtil.hasDataNetwork((Context)this.getContext())) {
            this.updateEmptyViewMode(0);
        } else {
            this.updateEmptyViewMode(2);
        }
        this.mList.clear();
        if (this.mGiphyAdapter != null) {
            this.mGiphyAdapter.notifyDataSetChanged();
        }
        UIUtil.closeSoftKeyboard((Context)this.getContext(), (View)this.mSearchBar);
        if (this.mSearchListener != null) {
            this.mSearchListener.onSearch(content);
        }
    }

    public void setDatas(String giphyStr, List<PTAppProtos.GiphyMsgInfo> infos) {
        if (infos == null || infos.isEmpty()) {
            this.updateEmptyViewMode(1);
            return;
        }
        if (giphyStr == null) {
            giphyStr = "";
        }
        this.mGridView.setVisibility(0);
        this.mList.clear();
        for (PTAppProtos.GiphyMsgInfo info : infos) {
            GiphyPreviewItem item = new GiphyPreviewItem();
            item.setGiphyStr(giphyStr);
            item.setInfo(info);
            this.mList.add(item);
        }
        this.mGiphyAdapter = new GiphyPreviewAdapter(this.getContext(), this.mList);
        this.setAdapter((ListAdapter)this.mGiphyAdapter);
    }

    public boolean hasData() {
        return this.mList != null && !this.mList.isEmpty();
    }

    private void setAdapter(ListAdapter adapter) {
        this.mGridView.setAdapter(adapter);
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener listener) {
        this.mGridView.setOnItemClickListener(listener);
    }

    public void setOnSearchListener(OnSearchListener listener) {
        this.mSearchListener = listener;
    }

    public void setmGiphyPreviewItemClickListener(OnGiphyPreviewItemClickListener mGiphyPreviewItemClickListener) {
        this.mGiphyPreviewItemClickListener = mGiphyPreviewItemClickListener;
    }

    public void setmOnBackClickListener(OnBackClickListener mOnBackClickListener) {
        this.mOnBackClickListener = mOnBackClickListener;
    }

    private class GiphyPreviewAdapter
    extends BaseAdapter {
        private Context mContext;
        private List<GiphyPreviewItem> mList;
        private ZMGifView mGifView;

        public GiphyPreviewAdapter(Context context, List<GiphyPreviewItem> list) {
            this.mContext = context;
            this.mList = list;
        }

        public int getCount() {
            return this.mList == null ? 0 : this.mList.size();
        }

        public Object getItem(int position) {
            return this.mList == null ? null : this.mList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.zm_mm_giphy_preview_item, parent, false);
            }
            this.mGifView = (ZMGifView)convertView.findViewById(R.id.giphy_preview_item_gifView);
            this.mGifView.setImageResource(R.color.zm_gray_2);
            GiphyPreviewItem item = (GiphyPreviewItem)this.getItem(position);
            if (item != null) {
                int netWorkType = NetworkUtil.getDataNetworkType((Context)this.mContext);
                if (netWorkType == 1 || netWorkType == 4 || netWorkType == 3) {
                    ImageLoader.getInstance().displayGif(this.mGifView, null, item.getInfo().getPcUrl());
                } else {
                    File cacheFile = ImageLoader.getInstance().getCacheFile(item.getInfo().getPcUrl());
                    if (cacheFile != null && cacheFile.exists()) {
                        ImageLoader.getInstance().displayGif(this.mGifView, null, item.getInfo().getPcUrl());
                    } else {
                        ImageLoader.getInstance().displayGif(this.mGifView, null, item.getInfo().getMobileUrl());
                    }
                }
            }
            return convertView;
        }
    }

    public class GiphyPreviewItem {
        private String giphyStr;
        private PTAppProtos.GiphyMsgInfo info;

        public String getGiphyStr() {
            return this.giphyStr;
        }

        public void setGiphyStr(String giphyStr) {
            this.giphyStr = giphyStr;
        }

        public PTAppProtos.GiphyMsgInfo getInfo() {
            return this.info;
        }

        public void setInfo(PTAppProtos.GiphyMsgInfo info) {
            this.info = info;
        }
    }

    public static interface OnBackClickListener {
        public void onBackClick(View var1);
    }

    public static interface OnGiphyPreviewItemClickListener {
        public void onGiphyPreviewItemClick(GiphyPreviewItem var1);
    }

    public static interface OnSearchListener {
        public void onSearch(String var1);
    }
}

