/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.ptapp.FavoriteMgr;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomContact;
import com.zipow.videobox.view.FavoriteItem;
import com.zipow.videobox.view.FavoriteListAdapter;
import com.zipow.videobox.view.IMView;
import java.io.Serializable;
import java.util.ArrayList;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.IZMMenuItem;
import us.zoom.androidlib.widget.QuickSearchListView;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class FavoriteListView
extends QuickSearchListView
implements AdapterView.OnItemClickListener,
AdapterView.OnItemLongClickListener {
    private static final String TAG = FavoriteListView.class.getSimpleName();
    private FavoriteListAdapter mAdapter;
    private String mFilter;

    public FavoriteListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public FavoriteListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public FavoriteListView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.mAdapter = new FavoriteListAdapter(this.getContext());
        if (this.isInEditMode()) {
            this._editmode_loadAllFavoriteItems(this.mAdapter);
        } else {
            this.loadAllFavoriteItems(this.mAdapter);
        }
        this.setAdapter(this.mAdapter);
        this.setOnItemClickListener(this);
        this.setOnItemLongClickListener(this);
    }

    private void _editmode_loadAllFavoriteItems(FavoriteListAdapter adapter) {
        for (int i = 0; i < 20; ++i) {
            ZoomContact contact = new ZoomContact();
            contact.setFirstName("Buddy");
            contact.setLastName(String.valueOf(i));
            contact.setUserID(String.valueOf(i));
            FavoriteItem item = new FavoriteItem(contact);
            adapter.addItem(item);
        }
    }

    private void loadAllFavoriteItems(FavoriteListAdapter adapter) {
        FavoriteMgr favoriteMgr = PTApp.getInstance().getFavoriteMgr();
        if (favoriteMgr == null) {
            return;
        }
        String lowerFilter = "";
        if (this.mFilter != null && this.mFilter.length() > 0) {
            lowerFilter = this.mFilter.toLowerCase(CompatUtils.getLocalDefault());
        }
        ArrayList<ZoomContact> contacts = new ArrayList<ZoomContact>();
        adapter.clear();
        if (favoriteMgr.getFavoriteListWithFilter(null, contacts)) {
            for (ZoomContact contact : contacts) {
                String email;
                FavoriteItem item = new FavoriteItem(contact);
                String name = item.getScreenName();
                if (name == null) {
                    name = "";
                }
                if ((email = item.getEmail()) == null) {
                    email = "";
                }
                if (lowerFilter.length() > 0 && name.toLowerCase(CompatUtils.getLocalDefault()).indexOf(lowerFilter) < 0 && email.toLowerCase(CompatUtils.getLocalDefault()).indexOf(lowerFilter) < 0) continue;
                adapter.addItem(item);
            }
        }
        adapter.sort(false);
    }

    public void addZoomContact(ZoomContact contact) {
        if (contact == null) {
            return;
        }
        if (this.mFilter != null && this.mFilter.length() > 0) {
            this.reloadFavoriteItems();
        } else {
            FavoriteItem item = new FavoriteItem(contact);
            this.mAdapter.addItem(item);
            this.mAdapter.sort(true);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void updateZoomContact(ZoomContact contact) {
        if (contact == null) {
            return;
        }
        if (this.mFilter != null && this.mFilter.length() > 0) {
            this.reloadFavoriteItems();
        } else {
            FavoriteItem item = new FavoriteItem(contact);
            this.mAdapter.updateItem(item);
            this.mAdapter.sort(true);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void updateZoomContact(String userId) {
        FavoriteMgr favoriteMgr = PTApp.getInstance().getFavoriteMgr();
        if (favoriteMgr == null) {
            return;
        }
        ZoomContact contact = new ZoomContact();
        if (favoriteMgr.getFavoriteByUserID(userId, contact)) {
            this.updateZoomContact(contact);
        } else {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void reloadFavoriteItems() {
        this.mAdapter.clear();
        this.loadAllFavoriteItems(this.mAdapter);
        this.mAdapter.notifyDataSetChanged();
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Object obj = this.getItemAtPosition(position);
        if (!(obj instanceof FavoriteItem)) {
            return;
        }
        FavoriteItem item = (FavoriteItem)obj;
        ContextMenuFragment.show(((ZMActivity)this.getContext()).getSupportFragmentManager(), item);
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
        Object obj = this.getItemAtPosition(position);
        if (!(obj instanceof FavoriteItem)) {
            return false;
        }
        FavoriteItem item = (FavoriteItem)obj;
        ContextMenuFragment.show(((ZMActivity)this.getContext()).getSupportFragmentManager(), item);
        return true;
    }

    public void onRestoreInstanceState(Parcelable state) {
        Parcelable superState = null;
        if (state instanceof Bundle) {
            Bundle allState = (Bundle)state;
            superState = allState.getParcelable("IMBuddyListView.superState");
            this.mFilter = allState.getString("IMBuddyListView.mFilter");
        } else {
            superState = state;
        }
        super.onRestoreInstanceState(superState);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle bundle = new Bundle();
        bundle.putParcelable("IMBuddyListView.superState", superState);
        bundle.putString("IMBuddyListView.mFilter", this.mFilter);
        return bundle;
    }

    public void setFilter(String filter) {
        this.mFilter = filter;
    }

    public String getFilter() {
        return this.mFilter;
    }

    public void filter(String filter) {
        if (filter == null) {
            filter = "";
        }
        this.mFilter = filter = filter.trim().toLowerCase(CompatUtils.getLocalDefault());
        this.reloadFavoriteItems();
    }

    public void refreshContextMenu() {
        FragmentManager fm = ((ZMActivity)this.getContext()).getSupportFragmentManager();
        ContextMenuFragment contextMenu = (ContextMenuFragment)fm.findFragmentByTag(ContextMenuFragment.class.getName());
        if (contextMenu != null) {
            contextMenu.refresh();
        }
    }

    public static class RemoveBuddyConfirmDialog
    extends ZMDialogFragment {
        private static final String ARG_BUDDYITEM = "buddyItem";

        public RemoveBuddyConfirmDialog() {
            this.setCancelable(true);
        }

        public static void show(FragmentManager fm, @NonNull FavoriteItem buddyItem) {
            if (fm == null) {
                return;
            }
            Bundle args = new Bundle();
            args.putSerializable(ARG_BUDDYITEM, (Serializable)buddyItem);
            RemoveBuddyConfirmDialog f = new RemoveBuddyConfirmDialog();
            f.setArguments(args);
            f.show(fm, RemoveBuddyConfirmDialog.class.getName());
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            Bundle args = this.getArguments();
            FavoriteItem buddyItem = (FavoriteItem)args.getSerializable(ARG_BUDDYITEM);
            String name = buddyItem.getScreenName();
            if (StringUtil.isEmptyOrNull((String)name)) {
                name = buddyItem.getEmail();
            }
            String message = this.getActivity().getString(R.string.zm_msg_remove_favorite_confirm, new Object[]{name});
            return new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(message).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    RemoveBuddyConfirmDialog.this.onClickOK();
                }
            }).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.cancel();
                }
            }).create();
        }

        private void onClickOK() {
            Bundle args = this.getArguments();
            FavoriteItem buddyItem = (FavoriteItem)args.getSerializable(ARG_BUDDYITEM);
            FavoriteMgr favMgr = PTApp.getInstance().getFavoriteMgr();
            if (favMgr != null && buddyItem != null) {
                favMgr.removeFavorite(buddyItem.getUserID());
            }
        }
    }

    static class ContextMenuItem
    extends ZMSimpleMenuItem {
        public ContextMenuItem(int action, String label) {
            super(action, label);
        }
    }

    public static class ContextMenuFragment
    extends ZMDialogFragment {
        public static final int MI_VIDEO_CALL = 0;
        public static final int MI_PHONE_CALL = 1;
        public static final int MI_REMOVE_BUDDY = 2;
        private static final String ARG_BUDDYITEM = "buddyItem";
        private ZMMenuAdapter<ContextMenuItem> mAdapter;

        public static void show(FragmentManager fm, @NonNull FavoriteItem buddyItem) {
            if (fm == null) {
                return;
            }
            Bundle args = new Bundle();
            args.putSerializable(ARG_BUDDYITEM, (Serializable)buddyItem);
            ContextMenuFragment f = new ContextMenuFragment();
            f.setArguments(args);
            f.show(fm, ContextMenuFragment.class.getName());
        }

        public ContextMenuFragment() {
            this.setCancelable(true);
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            FavoriteItem buddyItem = (FavoriteItem)this.getArguments().getSerializable(ARG_BUDDYITEM);
            this.mAdapter = this.createUpdateAdapter();
            String title = buddyItem.getScreenName();
            if (StringUtil.isEmptyOrNull((String)title)) {
                title = buddyItem.getEmail();
            }
            ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(title).setAdapter(this.mAdapter, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ContextMenuFragment.this.onSelectItem(which);
                }
            }).create();
            dialog.setCanceledOnTouchOutside(true);
            return dialog;
        }

        private ZMMenuAdapter<ContextMenuItem> createUpdateAdapter() {
            FavoriteItem buddyItem = (FavoriteItem)this.getArguments().getSerializable(ARG_BUDDYITEM);
            ContextMenuItem[] items = null;
            items = this.isInCall() ? new ContextMenuItem[]{new ContextMenuItem(0, this.getActivity().getText(this.getConfMenuItemText(buddyItem)).toString()), new ContextMenuItem(2, this.getActivity().getText(R.string.zm_mi_remove_buddy).toString())} : new ContextMenuItem[]{new ContextMenuItem(0, this.getActivity().getText(R.string.zm_btn_video_call).toString()), new ContextMenuItem(1, this.getActivity().getText(R.string.zm_btn_audio_call).toString()), new ContextMenuItem(2, this.getActivity().getText(R.string.zm_mi_remove_buddy).toString())};
            if (this.mAdapter == null) {
                this.mAdapter = new ZMMenuAdapter((Context)((ZMActivity)this.getActivity()), false);
            } else {
                this.mAdapter.clear();
            }
            this.mAdapter.addAll((IZMMenuItem[])items);
            return this.mAdapter;
        }

        public void refresh() {
            this.createUpdateAdapter().notifyDataSetChanged();
        }

        private int getConfMenuItemText(FavoriteItem buddyItem) {
            int callStatus = PTApp.getInstance().getCallStatus();
            switch (callStatus) {
                case 2: {
                    if (PTApp.getInstance().probeUserStatus(buddyItem.getUserID())) {
                        return R.string.zm_mi_return_to_conf;
                    }
                    return R.string.zm_mi_invite_to_conf;
                }
                case 1: {
                    return R.string.zm_mi_return_to_conf;
                }
            }
            return R.string.zm_mi_start_conf;
        }

        private boolean isInCall() {
            int callStatus = PTApp.getInstance().getCallStatus();
            switch (callStatus) {
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        private void onSelectItem(int which) {
            ContextMenuItem menuItem = (ContextMenuItem)((Object)this.mAdapter.getItem(which));
            FavoriteItem buddyItem = (FavoriteItem)this.getArguments().getSerializable(ARG_BUDDYITEM);
            switch (menuItem.getAction()) {
                case 2: {
                    this.onSelectRemoveBuddy(buddyItem);
                    break;
                }
                case 0: {
                    this.onSelectVideoCall(buddyItem);
                    break;
                }
                case 1: {
                    this.onSelectPhoneCall(buddyItem);
                }
            }
        }

        private void onSelectVideoCall(FavoriteItem buddyItem) {
            int callStatus = PTApp.getInstance().getCallStatus();
            switch (callStatus) {
                case 2: {
                    if (PTApp.getInstance().probeUserStatus(buddyItem.getUserID())) {
                        this.returnToConf();
                        break;
                    }
                    this.inviteToConf(buddyItem);
                    break;
                }
                case 1: {
                    this.returnToConf();
                    break;
                }
                default: {
                    this.startConf(buddyItem, true);
                }
            }
        }

        private void onSelectPhoneCall(FavoriteItem buddyItem) {
            int callStatus = PTApp.getInstance().getCallStatus();
            switch (callStatus) {
                case 2: {
                    if (PTApp.getInstance().probeUserStatus(buddyItem.getUserID())) {
                        this.returnToConf();
                        break;
                    }
                    this.inviteToConf(buddyItem);
                    break;
                }
                case 1: {
                    this.returnToConf();
                    break;
                }
                default: {
                    this.startConf(buddyItem, false);
                }
            }
        }

        private void startConf(FavoriteItem buddyItem, boolean videoCall) {
            FragmentActivity activity = this.getActivity();
            if (activity == null) {
                return;
            }
            int ret = ConfActivity.inviteToVideoCall((Context)activity, buddyItem.getUserID(), videoCall ? 1 : 0);
            if (ret != 0) {
                IMView.StartHangoutFailedDialog.show(((ZMActivity)activity).getSupportFragmentManager(), IMView.StartHangoutFailedDialog.class.getName(), ret);
            }
        }

        private void inviteToConf(FavoriteItem buddyItem) {
            PTApp ptApp = PTApp.getInstance();
            String meetingId = ptApp.getActiveCallId();
            if (StringUtil.isEmptyOrNull((String)meetingId)) {
                return;
            }
            FragmentActivity activity = this.getActivity();
            if (activity == null) {
                return;
            }
            int ret = ptApp.inviteBuddiesToConf(new String[]{buddyItem.getUserID()}, null, meetingId, 0L, activity.getString(R.string.zm_msg_invitation_message_template));
            if (ret == 0) {
                ConfActivity.returnToConf((Context)activity);
            }
        }

        private void returnToConf() {
            FragmentActivity activity = this.getActivity();
            if (activity == null) {
                return;
            }
            ConfActivity.returnToConf((Context)activity);
        }

        private void onSelectRemoveBuddy(FavoriteItem buddyItem) {
            RemoveBuddyConfirmDialog.show(this.getFragmentManager(), buddyItem);
        }
    }
}

