/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.FavoriteItem;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

class FavoriteItemView
extends LinearLayout {
    private FavoriteItem mItem;
    private TextView mTxtScreenName;
    private TextView mTxtEmail;
    private AvatarView mAvatarView;

    public FavoriteItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public FavoriteItemView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.inflateLayout();
        this.mTxtScreenName = (TextView)this.findViewById(R.id.txtScreenName);
        this.mTxtEmail = (TextView)this.findViewById(R.id.txtEmail);
        this.mAvatarView = (AvatarView)this.findViewById(R.id.avatarView);
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_favorite_item, (ViewGroup)this);
    }

    public void setScreenName(CharSequence name) {
        if (this.mTxtScreenName != null && name != null) {
            this.mTxtScreenName.setText(name);
        }
    }

    public void setEmail(String email) {
        if (this.mTxtEmail != null) {
            if (email != null) {
                this.mTxtEmail.setText((CharSequence)email);
                this.mTxtEmail.setVisibility(0);
            } else {
                this.mTxtEmail.setVisibility(8);
            }
        }
    }

    public void setAvatar(String imgPathName) {
        this.mAvatarView.setAvatar(imgPathName, 0);
    }

    public void setFavoriteItem(FavoriteItem item) {
        if (item == null) {
            return;
        }
        this.mItem = item;
        String name = this.mItem.getScreenName();
        if (StringUtil.isEmptyOrNull((String)name)) {
            name = this.mItem.getEmail();
            this.setEmail(null);
        } else {
            this.setEmail(this.mItem.getEmail());
        }
        this.setScreenName(name);
        this.setAvatar(this.mItem.getAvatar());
    }
}

