/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.graphics.Canvas;
import android.text.SpannableStringBuilder;
import android.text.style.ImageSpan;
import android.util.AttributeSet;
import com.zipow.videobox.view.mm.sticker.CommonEmojiHelper;
import us.zoom.androidlib.widget.ZMMaterialEditText;

public class EmojiEditText
extends ZMMaterialEditText
implements CommonEmojiHelper.OnEmojiPackageInstallListener {
    public EmojiEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public EmojiEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public EmojiEditText(Context context) {
        super(context);
        this.init();
    }

    private void init() {
    }

    private void formatSelection() {
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd();
        SpannableStringBuilder value = new SpannableStringBuilder((CharSequence)this.getText());
        ImageSpan[] spans = (ImageSpan[])value.getSpans(0, value.length(), ImageSpan.class);
        if (spans != null && spans.length > 0) {
            for (ImageSpan span : spans) {
                int spanStart = value.getSpanStart((Object)span);
                int spanEnd = value.getSpanEnd((Object)span);
                if (start > spanStart && start < spanEnd) {
                    start = spanStart;
                }
                if (end <= spanStart || end >= spanEnd) continue;
                end = spanEnd;
            }
            this.setSelection(start, end);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        CommonEmojiHelper.getInstance().addListener(this);
    }

    protected void onDetachedFromWindow() {
        CommonEmojiHelper.getInstance().removeListener(this);
        super.onDetachedFromWindow();
    }

    public boolean onTextContextMenuItem(int id2) {
        int selector = this.getSelectionEnd();
        int count = this.getText().length();
        boolean res = false;
        switch (id2) {
            case 0x1020022: {
                this.formatSelection();
                res = super.onTextContextMenuItem(id2);
                CommonEmojiHelper helper = CommonEmojiHelper.getInstance();
                this.setText(helper.formatImgEmojiSize(this.getTextSize(), (CharSequence)this.getText(), true));
                this.setSelection(selector + this.getText().length() - count);
                break;
            }
            case 0x1020021: {
                this.formatSelection();
                res = super.onTextContextMenuItem(id2);
                break;
            }
            default: {
                res = super.onTextContextMenuItem(id2);
            }
        }
        return res;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    @Override
    public void onEmojiPkgDownload(int progress) {
    }

    @Override
    public void onEmojiPkgInstalled() {
        int selector = this.getSelectionEnd();
        int count = this.getText().length();
        this.formatSelection();
        CommonEmojiHelper helper = CommonEmojiHelper.getInstance();
        this.setText(helper.formatImgEmojiSize(this.getTextSize(), (CharSequence)this.getText(), true));
        selector = selector + this.getText().length() - count;
        this.setSelection(selector < 0 ? 0 : selector);
    }

    @Override
    public void onEmojiPkgDownloadFailed() {
    }
}

