/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.RelativeLayout;
import com.zipow.videobox.view.ConfToolbar;
import us.zoom.videomeetings.R;

public class ConfToolsPanel
extends RelativeLayout {
    protected static final int DISPLAY_ANIM_DURATION = 0;
    private Listener mListener;
    protected transient boolean mbVisible = true;

    public ConfToolsPanel(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public ConfToolsPanel(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public ConfToolsPanel(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.setFocusable(false);
    }

    public void setListener(Listener l) {
        this.mListener = l;
    }

    public Listener getListener() {
        return this.mListener;
    }

    public boolean isVisible() {
        return this.mbVisible;
    }

    public void showToolbar(boolean show, boolean animation) {
        View panelBottom = this.findViewById(R.id.panelBottom);
        View panelTop = this.findViewById(R.id.panelTop);
        View panelTop2 = this.findViewById(R.id.panelTop2);
        final ConfToolbar toolbar = (ConfToolbar)this.findViewById(R.id.confToolbar);
        if (panelBottom == null || toolbar == null || panelTop == null || panelTop2 == null) {
            return;
        }
        if (toolbar.getVisibility() == 0 == show && panelTop.getVisibility() == 0 == show) {
            this.mbVisible = show;
            if (this.mListener != null) {
                this.mListener.onToolbarVisiblilyChanged(show);
            }
            return;
        }
        if (!animation) {
            toolbar.setVisibility(show ? 0 : 8);
            this.setVisibilityForTopToolbar(show ? 0 : 8);
            this.mbVisible = show;
            if (this.mListener != null) {
                this.mListener.onToolbarVisiblilyChanged(show);
            }
            return;
        }
        if (!show) {
            this.mbVisible = false;
            if (this.mListener != null) {
                this.mListener.onToolbarVisiblilyChanged(false);
            }
        }
        TranslateAnimation animBottom = null;
        TranslateAnimation animTop = null;
        if (show) {
            this.setVisibilityForTopToolbar(0);
            animTop = new TranslateAnimation(0.0f, 0.0f, (float)(-panelTop.getHeight()), 0.0f);
            toolbar.setVisibility(0);
            animBottom = new TranslateAnimation(0.0f, 0.0f, (float)toolbar.getHeight(), 0.0f);
            animBottom.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    ConfToolsPanel.this.mbVisible = true;
                    if (ConfToolsPanel.this.mListener != null) {
                        ConfToolsPanel.this.mListener.onToolbarVisiblilyChanged(true);
                    }
                }
            });
        } else {
            animBottom = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)toolbar.getHeight());
            animBottom.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    toolbar.setVisibility(8);
                }
            });
            animTop = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)(-panelTop.getHeight()));
            animTop.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    ConfToolsPanel.this.setVisibilityForTopToolbar(8);
                }
            });
        }
        animBottom.setInterpolator((Interpolator)new DecelerateInterpolator());
        animBottom.setDuration(0L);
        panelBottom.startAnimation((Animation)animBottom);
        animTop.setInterpolator((Interpolator)new DecelerateInterpolator());
        animTop.setDuration(0L);
        panelTop.startAnimation((Animation)animTop);
    }

    public void setConfNumber(long confNumber) {
    }

    public void setVisibilityForTopToolbar(int visibility) {
        View panelTop = this.findViewById(R.id.panelTop);
        View panelTop2 = this.findViewById(R.id.panelTop2);
        if (panelTop != null) {
            panelTop.setVisibility(visibility);
        }
        if (panelTop2 != null) {
            panelTop2.setVisibility(visibility);
        }
    }

    public static interface Listener {
        public void onToolbarVisiblilyChanged(boolean var1);
    }
}

