/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ZoomRaiseHandInWebinar;
import com.zipow.videobox.confapp.qa.ZoomQABuddy;
import com.zipow.videobox.view.ConfChatAttendeeItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;

public class ConfRaiseHandListView
extends ListView {
    private static final String TAG = ConfRaiseHandListView.class.getSimpleName();
    private ConfRaiseHandAdapter mAdapter;

    public ConfRaiseHandListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    public ConfRaiseHandListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public ConfRaiseHandListView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.mAdapter = new ConfRaiseHandAdapter(this.getContext());
        if (!this.isInEditMode()) {
            this.loadAllItems(this.mAdapter);
        }
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    private void loadAllItems(ConfRaiseHandAdapter adapter) {
        ZoomRaiseHandInWebinar raiseHandInWebinar = ConfMgr.getInstance().getRaiseHandAPIObj();
        if (raiseHandInWebinar == null) {
            return;
        }
        List<ZoomQABuddy> buddies = raiseHandInWebinar.getRaisedHandAttendees();
        if (buddies != null) {
            for (ZoomQABuddy buddy : buddies) {
                adapter.addWebinarAttendeeItem(buddy);
            }
        }
    }

    public void reloadAllItems() {
        this.mAdapter.clear();
        this.loadAllItems(this.mAdapter);
        this.mAdapter.notifyDataSetChanged();
    }

    public void addWebinarAttendeeItem(long nodeID) {
        this.mAdapter.addWebinarAttendeeItem(nodeID);
    }

    public void onConfAllowRaiseHandStatusChanged() {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (myself == null || !myself.isHost() && !myself.isCoHost() || confStatus == null || !confStatus.isAllowRaiseHand()) {
            this.mAdapter.clear();
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void removeWebinarAttendeeItem(long nodeID) {
        this.mAdapter.removeWebinarAttendeeItem(nodeID);
    }

    public void removeWebinarAttendeeItem(String jid) {
        this.mAdapter.removeWebinarAttendeeItem(jid);
    }

    static class ConfRaiseHandAdapter
    extends BaseAdapter {
        private ArrayList<ConfChatAttendeeItem> mItems = new ArrayList();
        private Context mContext;

        public ConfRaiseHandAdapter(Context context) {
            this.mContext = context;
        }

        public void addWebinarAttendeeItem(ZoomQABuddy buddy) {
            ConfChatAttendeeItem item = new ConfChatAttendeeItem(buddy);
            this.addWebinarAttendeeItem(item);
        }

        public void addWebinarAttendeeItem(long nodeID) {
            ConfChatAttendeeItem item = ConfChatAttendeeItem.getWebinarAttendeeItemByNodeId(nodeID);
            if (item == null) {
                return;
            }
            this.addWebinarAttendeeItem(item);
        }

        private void addWebinarAttendeeItem(ConfChatAttendeeItem item) {
            if (item == null) {
                return;
            }
            int index = this.searchAttendee(item);
            if (index < 0) {
                this.mItems.add(-index - 1, item);
            } else {
                this.mItems.set(index, item);
            }
            this.notifyDataSetChanged();
        }

        public void clear() {
            this.mItems.clear();
        }

        public void removeWebinarAttendeeItem(long nodeID) {
            for (int i = 0; i < this.mItems.size(); ++i) {
                if (this.mItems.get((int)i).nodeID != nodeID) continue;
                this.mItems.remove(i);
                this.notifyDataSetChanged();
                break;
            }
        }

        public void removeWebinarAttendeeItem(String jid) {
            for (int i = 0; i < this.mItems.size(); ++i) {
                if (!TextUtils.equals((CharSequence)jid, (CharSequence)this.mItems.get((int)i).jid)) continue;
                this.mItems.remove(i);
                this.notifyDataSetChanged();
                break;
            }
        }

        private int searchAttendee(ConfChatAttendeeItem item) {
            ConfChatAttendeeItem itemTmp;
            int i;
            int index = Collections.binarySearch(this.mItems, item, new ConfChatAttendeeItem.WebinarAttendeeItemComparator(CompatUtils.getLocalDefault()));
            if (index < 0) {
                return index;
            }
            for (i = index; i < this.mItems.size(); ++i) {
                itemTmp = this.mItems.get(i);
                if (StringUtil.isSameString((String)itemTmp.jid, (String)item.jid)) {
                    return i;
                }
                if (!StringUtil.isSameString((String)itemTmp.getSortKey(), (String)item.getSortKey())) break;
            }
            for (i = index; i >= 0; --i) {
                itemTmp = this.mItems.get(i);
                if (StringUtil.isSameString((String)itemTmp.jid, (String)item.jid)) {
                    return i;
                }
                if (!StringUtil.isSameString((String)itemTmp.getSortKey(), (String)item.getSortKey())) break;
            }
            return -index - 1;
        }

        public int getCount() {
            return this.mItems.size();
        }

        public Object getItem(int position) {
            return this.mItems.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            Object obj = this.getItem(position);
            if (obj == null || !(obj instanceof ConfChatAttendeeItem)) {
                return null;
            }
            return ((ConfChatAttendeeItem)obj).getView(this.mContext, convertView);
        }
    }
}

