/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.text.Editable;
import android.text.Selection;
import com.zipow.videobox.CmmSavedMeeting;
import com.zipow.videobox.ptapp.PTApp;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;

public class ConfNumberMgr {
    private static final int MAX_CONF_NUMBER_CAPACITY = 10;
    private static final String DELIMITER = ",";

    public static List<CmmSavedMeeting> loadConfNumberFromDB() {
        ArrayList<CmmSavedMeeting> data = new ArrayList<CmmSavedMeeting>();
        ArrayList<CmmSavedMeeting> list = PTApp.getInstance().getSavedMeetingList();
        if (list.size() == 0) {
            return data;
        }
        for (CmmSavedMeeting item : list) {
            String id2 = item.getmConfID();
            if (StringUtil.isEmptyOrNull((String)id2) || ConfNumberMgr.isValidVanityUrl(id2)) continue;
            data.add(item);
        }
        return data;
    }

    public static List<CmmSavedMeeting> loadVanityUrlFromDB() {
        ArrayList<CmmSavedMeeting> data = new ArrayList<CmmSavedMeeting>();
        ArrayList<CmmSavedMeeting> list = PTApp.getInstance().getSavedMeetingList();
        if (list.size() == 0) {
            return data;
        }
        for (CmmSavedMeeting item : list) {
            String id2 = item.getmConfID();
            if (StringUtil.isEmptyOrNull((String)id2) || !ConfNumberMgr.isValidVanityUrl(id2)) continue;
            data.add(item);
        }
        return data;
    }

    public static boolean isValidVanityUrl(String url) {
        if (url == null || url.length() > 40 || url.length() < 5) {
            return false;
        }
        char first = url.charAt(0);
        return first <= 'z' && first >= 'a';
    }

    public static ArrayList<CmmSavedMeeting> loadConfUrlFromDB() {
        return PTApp.getInstance().getSavedMeetingList();
    }

    private static boolean checkEditTextRange(int len, int start, int end) {
        return start >= 0 && end >= 0 && end >= start && start <= len && end <= len;
    }

    public static void formatText(Editable et, int formatType) {
        int len;
        if (et == null) {
            return;
        }
        for (int i = 0; i < et.length(); ++i) {
            char c = et.charAt(i);
            if (ConfNumberMgr.isNumber(c)) continue;
            et.delete(i, i + 1);
            --i;
        }
        int start = Selection.getSelectionStart((CharSequence)et);
        int end = Selection.getSelectionEnd((CharSequence)et);
        while (et.length() > 11 && ConfNumberMgr.checkEditTextRange(et.length(), start - 1, end)) {
            et.delete(start - 1, end);
            --start;
            --end;
        }
        int firstSpacePos = 3;
        int secondSpacePos = 7;
        if (formatType == 2) {
            firstSpacePos = 4;
        }
        secondSpacePos = formatType == 1 || formatType == 2 ? 8 : ((len = et.length()) < 11 ? 7 : 8);
        for (int i = 0; i < et.length(); ++i) {
            char c = et.charAt(i);
            if (i == et.length() - 1 && !ConfNumberMgr.isNumber(c)) {
                et.delete(i, i + 1);
                break;
            }
            if (i == firstSpacePos || i == secondSpacePos) {
                if (ConfNumberMgr.isNumber(c)) {
                    et.insert(i, (CharSequence)" ");
                    continue;
                }
                if (c == ' ') continue;
                et.replace(i, i + 1, (CharSequence)" ");
                continue;
            }
            if (ConfNumberMgr.isNumber(c)) continue;
            et.delete(i, i + 1);
            --i;
        }
    }

    private static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }
}

