/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextWatcher;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.util.AttributeSet;
import android.widget.EditText;

public class ConfNumberEditText
extends EditText {
    private static MyKeyListener mKeyListener = new MyKeyListener();
    public static final int FORMAT_TYPE_DEFAULT = 0;
    public static final int FORMAT_TYPE_34X = 1;
    public static final int FORMAT_TYPE_43X = 2;
    private int mFormatType = 0;
    private TextWatcher mTextChangedListener;

    public ConfNumberEditText(Context context) {
        super(context);
        this.init();
    }

    public ConfNumberEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public ConfNumberEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public void setFormatType(int formatType) {
        this.mFormatType = formatType;
        if (this.mTextChangedListener != null) {
            this.removeTextChangedListener(this.mTextChangedListener);
        }
        Editable et = this.getEditableText();
        this.formatText(et);
        if (this.mTextChangedListener != null) {
            this.addTextChangedListener(this.mTextChangedListener);
        }
    }

    public int getFormatType() {
        return this.mFormatType;
    }

    private void init() {
        this.setKeyListener((KeyListener)mKeyListener);
        this.mTextChangedListener = new TextWatcher(){
            boolean bAppend = false;
            boolean bDelete = false;

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                this.bAppend = s.length() == start && count == 0;
                this.bDelete = count > 0 && after == 0;
            }

            public void afterTextChanged(Editable s) {
                ConfNumberEditText.this.removeTextChangedListener(this);
                int selection = Selection.getSelectionEnd((CharSequence)s);
                Editable et = ConfNumberEditText.this.getEditableText();
                ConfNumberEditText.this.formatText(et);
                int newLen = et.length();
                if (this.bAppend || selection < 0 || selection > newLen) {
                    Selection.setSelection((Spannable)et, (int)newLen);
                } else {
                    if (!this.bDelete && selection > 0 && selection <= et.length() && et.charAt(selection - 1) == ' ') {
                        ++selection;
                    }
                    Selection.setSelection((Spannable)et, (int)selection);
                }
                ConfNumberEditText.this.addTextChangedListener(this);
            }
        };
        this.addTextChangedListener(this.mTextChangedListener);
    }

    private void formatText(Editable et) {
        int len;
        if (et == null) {
            return;
        }
        for (int i = 0; i < et.length(); ++i) {
            char c = et.charAt(i);
            if (ConfNumberEditText.isNumber(c)) continue;
            et.delete(i, i + 1);
            --i;
        }
        int firstSpacePos = 3;
        int secondSpacePos = 7;
        if (this.mFormatType == 2) {
            firstSpacePos = 4;
        }
        secondSpacePos = this.mFormatType == 1 || this.mFormatType == 2 ? 8 : ((len = et.length()) < 11 ? 7 : 8);
        for (int i = 0; i < et.length(); ++i) {
            char c = et.charAt(i);
            if (i == et.length() - 1 && !ConfNumberEditText.isNumber(c)) {
                et.delete(i, i + 1);
                break;
            }
            if (i == firstSpacePos || i == secondSpacePos) {
                if (ConfNumberEditText.isNumber(c)) {
                    et.insert(i, (CharSequence)" ");
                    continue;
                }
                if (c == ' ') continue;
                et.replace(i, i + 1, (CharSequence)" ");
                continue;
            }
            if (ConfNumberEditText.isNumber(c)) continue;
            et.delete(i, i + 1);
            --i;
        }
    }

    private static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    private static class MyKeyListener
    extends DigitsKeyListener {
        private static final char[] mAcceptedChars = "0123456789 ".toCharArray();

        public MyKeyListener() {
            super(false, false);
        }

        protected char[] getAcceptedChars() {
            return mAcceptedChars;
        }
    }
}

