/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.view.ConfChatListViewOld;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class ConfChatViewOld
extends LinearLayout
implements View.OnClickListener,
AbsListView.OnScrollListener {
    private ConfChatListViewOld mChatListView;
    private EditText mEdtMessage;
    private Button mBtnSend;
    private Button mBtnBack;
    private TextView mTxtTitle;
    private long mUserId;
    private Listener mListener;

    public ConfChatViewOld(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public ConfChatViewOld(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_conf_chat_view, (ViewGroup)this);
        this.mTxtTitle = (TextView)this.findViewById(R.id.txtTitle);
        this.mChatListView = (ConfChatListViewOld)this.findViewById(R.id.chatListView);
        this.mEdtMessage = (EditText)this.findViewById(R.id.edtMessage);
        this.mBtnSend = (Button)this.findViewById(R.id.btnSend);
        this.mBtnBack = (Button)this.findViewById(R.id.btnBack);
        this.mBtnSend.setOnClickListener((View.OnClickListener)this);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mChatListView.setOnScrollListener(this);
    }

    public void setListener(Listener l) {
        this.mListener = l;
    }

    public long getUserId() {
        return this.mUserId;
    }

    public void loadData(long userId) {
        this.mUserId = userId;
        String title = "";
        if (this.mUserId == 0L) {
            title = this.getContext().getString(R.string.zm_lbl_everyone);
        } else {
            String userName = "";
            CmmUser user = ConfMgr.getInstance().getUserById(userId);
            if (user != null) {
                userName = user.getScreenName();
            }
            title = userName;
        }
        this.mTxtTitle.setText((CharSequence)title);
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null && confContext.isPrivateChatOFF() && userId != 0L) {
            this.mBtnSend.setEnabled(false);
            this.mEdtMessage.setHint(R.string.zm_hint_private_chat_disabled);
        }
        this.loadMessages(this.mUserId);
    }

    public void reloadData() {
        this.loadData(this.mUserId);
    }

    private void loadMessages(long userId) {
        this.mChatListView.loadMessages(userId);
    }

    public void onChatMessageReceived(String msgID, long sender, String senderDisplayName, long receiver, String receiverDisplayName, String content, long time) {
        if (sender == this.mUserId || receiver == this.mUserId || this.mUserId == 0L) {
            this.mChatListView.onChatMessageReceived(msgID, sender, senderDisplayName, receiver, receiverDisplayName, content, time);
            ConfMgr.getInstance().setChatMessageAsReaded(msgID);
        }
    }

    public void scrollToBottom(boolean force) {
        this.mChatListView.scrollToBottom(force);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnSend) {
            this.onClickBtnSend();
        } else if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        }
    }

    private void onClickBtnSend() {
        String message = this.mEdtMessage.getText().toString().trim();
        if (message.length() == 0) {
            return;
        }
        this.scrollToBottom(true);
        ConfMgr.getInstance().sendChatMessageTo(this.mUserId, message, false, false, 0L);
        this.mEdtMessage.setText((CharSequence)"");
    }

    private void onClickBtnBack() {
        if (this.mListener != null) {
            this.mListener.onClickBack();
        }
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (scrollState == 1) {
            UIUtil.closeSoftKeyboard((Context)this.getContext(), (View)this.mEdtMessage);
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
    }

    public static interface Listener {
        public void onClickBack();
    }
}

