/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.zipow.videobox.ConfActivityNormal;
import com.zipow.videobox.confapp.ChatMessage;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.util.ZMWebLinkFilter;
import com.zipow.videobox.view.ConfChatItem;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.AccessibilityUtil;
import us.zoom.videomeetings.R;

public class ConfChatListView
extends ListView {
    private static final int TIME_NEW_MESSAGE_REFRESH_DELAY = 2000;
    private WebinarChatAdapter mWebinarChatAdapter;
    private boolean mHasNewMessageDuringPaused = true;
    private static final int MSG_SCROLL_BOTTOM = 1;
    private List<String> mPendingItems = new ArrayList<String>();
    private Runnable mNewMsgRefreshTask;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ConfChatListView.this.scrollToBottom(false);
                    break;
                }
            }
        }
    };

    public ConfChatListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public ConfChatListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ConfChatListView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.mWebinarChatAdapter = new WebinarChatAdapter(this.getContext());
        this.setAdapter((ListAdapter)this.mWebinarChatAdapter);
        this.loadAllItems();
    }

    public boolean onChatMessageReceived(String msgID, long sender, String senderDisplayName, long receiver, String receiverDisplayName, String content, long time) {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        boolean fromMe = confStatus != null && confStatus.isMyself(sender);
        this.addChatMessage(msgID, fromMe);
        return true;
    }

    private void addChatMessage(String msgId, boolean isMeSend) {
        this.mPendingItems.add(msgId);
        if (this.mNewMsgRefreshTask == null) {
            this.mNewMsgRefreshTask = new Runnable(){

                @Override
                public void run() {
                    ConfChatListView.this.refreshMsg();
                }
            };
            this.mHandler.post(this.mNewMsgRefreshTask);
        } else if (isMeSend) {
            this.mHandler.removeCallbacks(this.mNewMsgRefreshTask);
            this.mNewMsgRefreshTask.run();
            this.mHandler.postDelayed(this.mNewMsgRefreshTask, 2000L);
            return;
        }
    }

    public boolean onUserEvent(int eventType, long userId, int flag) {
        return false;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        final int lastVisiblePos = this.getLastVisiblePosition();
        super.onLayout(changed, l, t, r, b);
        if (!changed) {
            return;
        }
        if (lastVisiblePos >= 0) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    ConfChatListView.this.setSelection(lastVisiblePos);
                }
            });
        }
    }

    public ConfChatItem addChatMsgToAdapter(int idx, String msgID) {
        ConfChatItem item = ConfChatItem.getConfChatItemFromMsgID(msgID, true);
        if (item != null) {
            if (idx < 0) {
                this.mWebinarChatAdapter.addItem(item);
            } else if (idx == 0) {
                this.mWebinarChatAdapter.addItemAtFirst(item);
            }
        }
        return item;
    }

    public void loadAllItems() {
        ConfMgr confMgr = ConfMgr.getInstance();
        int count = confMgr.getChatMessageCount();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                ChatMessage chatMessage = confMgr.getChatMessageAt(i);
                if (chatMessage == null) continue;
                this.addChatMsgToAdapter(-1, chatMessage.getId());
            }
        }
        this.mWebinarChatAdapter.notifyDataSetChanged();
        this.mHasNewMessageDuringPaused = true;
    }

    public void updateUI() {
        this.mWebinarChatAdapter.notifyDataSetChanged();
        if (this.mHasNewMessageDuringPaused) {
            this.scrollToBottom(true);
        }
    }

    public void onParentFragmentPause() {
        this.mHasNewMessageDuringPaused = false;
    }

    public void delayScrollToBottom() {
        if (this.mHandler.hasMessages(1)) {
            this.mHandler.removeMessages(1);
        }
        this.mHandler.sendEmptyMessageDelayed(1, 200L);
    }

    protected void onDetachedFromWindow() {
        this.mHandler.removeMessages(1);
        if (this.mNewMsgRefreshTask != null) {
            this.mHandler.removeCallbacks(this.mNewMsgRefreshTask);
            this.mNewMsgRefreshTask = null;
        }
        super.onDetachedFromWindow();
    }

    public void scrollToBottom(boolean force) {
        int lastVisiblePos = this.getLastVisiblePosition();
        int lastPos = this.getCount() - 1;
        if (force) {
            this.setSelection(lastPos);
        } else if (lastPos - lastVisiblePos < 5) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.smoothScrollToPosition(lastPos);
            } else {
                this.setSelection(lastPos);
            }
        }
    }

    public void setOnClickMessageListener(OnClickMessageListener mOnClickMessageListener) {
        this.mWebinarChatAdapter.setOnClickMessageListener(mOnClickMessageListener);
    }

    private void refreshMsg() {
        if (!this.mPendingItems.isEmpty()) {
            ConfChatItem confChatItemFromOther = null;
            for (String msgId : this.mPendingItems) {
                ConfChatItem confChatItem = this.addChatMsgToAdapter(-1, msgId);
                if (confChatItem == null || confChatItem.isSelfSend) continue;
                confChatItemFromOther = confChatItem;
            }
            if (confChatItemFromOther != null && AccessibilityUtil.isSpokenFeedbackEnabled((Context)this.getContext())) {
                AccessibilityUtil.announceForAccessibilityCompat((View)this, (CharSequence)ConfActivityNormal.getConfChatAccessibilityDescription(this.getContext(), confChatItemFromOther), (boolean)true);
            }
            if (this.mWebinarChatAdapter.isLastItem(this.mPendingItems.get(this.mPendingItems.size() - 1))) {
                this.delayScrollToBottom();
            }
            this.mWebinarChatAdapter.notifyDataSetChanged();
            this.mHasNewMessageDuringPaused = true;
        }
        this.mPendingItems.clear();
        this.mHandler.postDelayed(this.mNewMsgRefreshTask, 2000L);
    }

    static class WebinarChatAdapter
    extends BaseAdapter {
        private List<ConfChatItem> mitems = new ArrayList<ConfChatItem>();
        private Context mContext;
        private OnClickMessageListener mOnClickMessageListener;

        public void setOnClickMessageListener(OnClickMessageListener mOnClickMessageListener) {
            this.mOnClickMessageListener = mOnClickMessageListener;
        }

        WebinarChatAdapter(Context context) {
            this.mContext = context;
        }

        public boolean isLastItem(String messageId) {
            if (messageId == null) {
                return false;
            }
            for (int i = 0; i < this.mitems.size(); ++i) {
                ConfChatItem item = this.mitems.get(i);
                if (!TextUtils.equals((CharSequence)messageId, (CharSequence)item.id)) continue;
                return i == this.mitems.size() - 1;
            }
            return false;
        }

        public int getCount() {
            return this.mitems.size();
        }

        public void addItem(ConfChatItem item) {
            if (item == null) {
                return;
            }
            this.mitems.add(item);
        }

        public void addItemAtFirst(ConfChatItem item) {
            if (item == null) {
                return;
            }
            this.mitems.add(0, item);
        }

        public Object getItem(int position) {
            return this.mitems.get(position);
        }

        public int getViewTypeCount() {
            return 2;
        }

        public int getItemViewType(int position) {
            ConfChatItem item = (ConfChatItem)this.getItem(position);
            return item != null && item.isSelfSend ? 0 : 1;
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            int type = this.getItemViewType(position);
            String tag = type == 0 ? "messageto" : "messagefrom";
            int res = type == 0 ? R.layout.zm_webinar_chat_to : R.layout.zm_webinar_chat_from;
            View view = null;
            if (convertView != null && tag.equals(convertView.getTag())) {
                view = convertView;
            } else {
                LayoutInflater factory = LayoutInflater.from((Context)this.mContext);
                view = factory.inflate(res, parent, false);
                view.setTag((Object)tag);
            }
            final ConfChatItem item = (ConfChatItem)this.getItem(position);
            if (item != null) {
                TextView txtMsgLabel = (TextView)view.findViewById(R.id.txtMsgLabel);
                TextView txtPrivateStatus = (TextView)view.findViewById(R.id.txtPrivateStatus);
                TextView txtMsgValue = (TextView)view.findViewById(R.id.txtMsgValue);
                View layoutMsgHead = view.findViewById(R.id.layoutMsgHead);
                String receiveName = item.receiverName;
                CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
                if (confStatus != null && confStatus.isMyself(item.receiver)) {
                    receiveName = this.mContext.getString(R.string.zm_webinar_txt_me);
                }
                switch (item.msgType) {
                    case 0: {
                        CmmConfContext cmmConfContext = ConfMgr.getInstance().getConfContext();
                        if (cmmConfContext != null && cmmConfContext.isWebinar()) {
                            receiveName = this.mContext.getString(R.string.zm_mi_panelists_and_attendees_11380);
                            break;
                        }
                        receiveName = this.mContext.getString(R.string.zm_webinar_txt_everyone);
                        break;
                    }
                    case 2: {
                        receiveName = this.mContext.getString(R.string.zm_webinar_txt_label_ccPanelist, new Object[]{receiveName, this.mContext.getString(R.string.zm_webinar_txt_all_panelists)});
                        break;
                    }
                    case 1: {
                        receiveName = this.mContext.getString(R.string.zm_webinar_txt_all_panelists);
                        break;
                    }
                }
                if (type == 0) {
                    txtMsgLabel.setText((CharSequence)this.mContext.getString(R.string.zm_webinar_txt_label_to, new Object[]{receiveName}));
                } else {
                    txtMsgLabel.setText((CharSequence)this.mContext.getString(R.string.zm_webinar_txt_label_from, new Object[]{item.senderName, receiveName}));
                }
                if (position > 0) {
                    ConfChatItem preItem = (ConfChatItem)this.getItem(position - 1);
                    if (preItem.msgType == item.msgType && preItem.receiver == item.receiver && preItem.sender == item.sender) {
                        layoutMsgHead.setVisibility(8);
                        txtMsgValue.setBackgroundResource(type == 0 ? R.drawable.zm_webinar_message_out_notitle : R.drawable.zm_webinar_message_in_notitle);
                    } else {
                        layoutMsgHead.setVisibility(0);
                        txtMsgValue.setBackgroundResource(type == 0 ? R.drawable.zm_webinar_message_out : R.drawable.zm_webinar_message_in);
                    }
                } else {
                    layoutMsgHead.setVisibility(0);
                    txtMsgValue.setBackgroundResource(type == 0 ? R.drawable.zm_webinar_message_out : R.drawable.zm_webinar_message_in);
                }
                txtPrivateStatus.setVisibility(item.msgType == 3 ? 0 : 8);
                txtMsgValue.setText((CharSequence)item.content);
                txtMsgValue.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (WebinarChatAdapter.this.mOnClickMessageListener != null) {
                            WebinarChatAdapter.this.mOnClickMessageListener.onClickMessage(item);
                        }
                    }
                });
                txtMsgValue.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View v) {
                        if (WebinarChatAdapter.this.mOnClickMessageListener != null) {
                            WebinarChatAdapter.this.mOnClickMessageListener.onLongClickMessage(item);
                        }
                        return false;
                    }
                });
                ZMWebLinkFilter.filter(txtMsgValue);
            }
            return view;
        }
    }

    public static interface OnClickMessageListener {
        public void onClickMessage(ConfChatItem var1);

        public void onLongClickMessage(ConfChatItem var1);
    }
}

