/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.util.TimeFormatUtil;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.ConfChatItem;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.IZMMenuItem;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class ConfChatItemView
extends LinearLayout {
    private static final String TAG = ConfChatItemView.class.getName();
    private TextView mTxtScreenName;
    private TextView mTxtTime;
    private TextView mTxtMessage;
    private AvatarView mAvatarView;
    private String mMessage;

    public ConfChatItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public ConfChatItemView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.inflateLayout();
        this.mTxtScreenName = (TextView)this.findViewById(R.id.txtScreenName);
        this.mTxtTime = (TextView)this.findViewById(R.id.txtTime);
        this.mTxtMessage = (TextView)this.findViewById(R.id.txtMessage);
        this.mAvatarView = (AvatarView)this.findViewById(R.id.avatarView);
        this.mTxtMessage.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                ConfChatItemView.this.showMessageContextMenu();
                return true;
            }
        });
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_conf_chat_item_public, (ViewGroup)this);
    }

    public void setScreenName(CharSequence name) {
        if (name != null) {
            this.mTxtScreenName.setText(name);
        }
    }

    public void setTime(long time) {
        String sTime = null;
        sTime = this.isInEditMode() ? "00:00 am" : TimeFormatUtil.formatTime(this.getContext(), time);
        this.mTxtTime.setText((CharSequence)sTime);
    }

    public void setMessage(CharSequence message) {
        if (message != null) {
            this.mMessage = message.toString();
            this.mTxtMessage.setText(message);
            this.mTxtMessage.setMovementMethod((MovementMethod)new LinkMovementMethod(){

                public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
                    try {
                        return super.onTouchEvent(widget, buffer, event);
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            });
        }
    }

    public void setAvatar(String avatar) {
        this.mAvatarView.setAvatar(avatar);
    }

    public void setChatItem(ConfChatItem item) {
        CmmUser user;
        if (item.type == 0) {
            this.setScreenName(this.getContext().getString(R.string.zm_title_conf_chat_public, new Object[]{item.senderName}));
        } else {
            boolean fromMe;
            CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
            boolean bl = fromMe = confStatus != null && confStatus.isMyself(item.sender);
            if (fromMe) {
                this.setScreenName(this.getContext().getString(R.string.zm_title_conf_chat_private_to, new Object[]{item.receiverName}));
            } else {
                this.setScreenName(this.getContext().getString(R.string.zm_title_conf_chat_private_from, new Object[]{item.senderName}));
            }
        }
        this.setTime(item.time);
        this.setMessage(item.content);
        this.mAvatarView.setName(item.senderName);
        if (!this.isInEditMode() && (user = ConfMgr.getInstance().getUserById(item.sender)) != null) {
            this.setAvatar(user.getSmallPicPath());
        }
    }

    private void showMessageContextMenu() {
        Activity activity = (Activity)this.getContext();
        if (activity == null) {
            return;
        }
        final ZMMenuAdapter menuAdapter = new ZMMenuAdapter((Context)activity, false);
        menuAdapter.addItem((IZMMenuItem)new MessageContextMenuItem(activity.getString(R.string.zm_mm_lbl_copy_message), 0));
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MessageContextMenuItem item = (MessageContextMenuItem)((Object)menuAdapter.getItem(which));
                ConfChatItemView.this.onSelectContextMenuItem(item);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
    }

    private void onSelectContextMenuItem(MessageContextMenuItem item) {
        switch (item.getAction()) {
            case 0: {
                if (StringUtil.isEmptyOrNull((String)this.mMessage)) break;
                AndroidAppUtil.copyText((Context)this.getContext(), (CharSequence)this.mMessage);
            }
        }
    }

    public static class ConfChatPrivateItemView
    extends ConfChatItemView {
        public ConfChatPrivateItemView(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public ConfChatPrivateItemView(Context context) {
            super(context);
        }

        @Override
        protected void inflateLayout() {
            View.inflate((Context)this.getContext(), (int)R.layout.zm_conf_chat_item_private, (ViewGroup)this);
        }
    }

    public static class ConfChatPublicItemView
    extends ConfChatItemView {
        public ConfChatPublicItemView(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public ConfChatPublicItemView(Context context) {
            super(context);
        }

        @Override
        protected void inflateLayout() {
            View.inflate((Context)this.getContext(), (int)R.layout.zm_conf_chat_item_public, (ViewGroup)this);
        }
    }

    static class MessageContextMenuItem
    extends ZMSimpleMenuItem {
        public static final int ACTION_COPY = 0;

        public MessageContextMenuItem(String label, int action) {
            super(action, label);
        }
    }
}

