/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import com.zipow.videobox.confapp.ConfChatMessage;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.view.ConfChatItemView;

public class ConfChatItem {
    public String id = "";
    public long sender;
    public long receiver;
    public String senderName = "";
    public String receiverName = "";
    public String senderJid;
    public String receiverJid;
    public String content = "";
    public long time;
    public boolean isNotification;
    public int type;
    public boolean isSelfSend;
    public int msgType = -1;

    public ConfChatItem() {
    }

    public static ConfChatItem getConfChatItemFromMsgID(String msgID, boolean isRead) {
        if (TextUtils.isEmpty((CharSequence)msgID)) {
            return null;
        }
        ConfMgr confMgr = ConfMgr.getInstance();
        ConfChatMessage message = confMgr.getChatMessageItemByID(msgID);
        if (message == null) {
            return null;
        }
        if (isRead) {
            confMgr.setChatMessageAsReaded(msgID);
        }
        return new ConfChatItem(message);
    }

    public ConfChatItem(ConfChatMessage msg) {
        this.update(msg.getMessageID(), msg.getSenderID(), msg.getSenderDisplayName(), msg.getReceiverID(), msg.getReceiverDisplayName(), msg.getMessageContent(), msg.getTimeStamp(), msg.isSelfSend(), msg.getMsgType(), msg.getSenderJid(), msg.getRecieverJid());
    }

    private ConfChatItem update(String msgId, long sender, String senderDisplayName, long receiver, String receiverDisplayName, String content, long time, boolean selfSend, int msgType, String sendJid, String receiveJid) {
        this.id = msgId;
        this.sender = sender;
        this.receiver = receiver;
        this.senderName = senderDisplayName;
        this.receiverName = receiverDisplayName;
        this.content = content;
        this.time = time;
        this.isSelfSend = selfSend;
        this.msgType = msgType;
        this.type = receiver != 0L ? 1 : 0;
        this.senderJid = sendJid;
        this.receiverJid = receiveJid;
        return this;
    }

    public View getView(Context context, View convertView) {
        switch (this.type) {
            case 1: {
                return this.getPrivateItemView(context, convertView);
            }
            case 0: {
                return this.getPublicItemView(context, convertView);
            }
        }
        return null;
    }

    private View getPublicItemView(Context context, View convertView) {
        ConfChatItemView.ConfChatPublicItemView view = null;
        view = convertView instanceof ConfChatItemView.ConfChatPublicItemView ? (ConfChatItemView.ConfChatPublicItemView)convertView : new ConfChatItemView.ConfChatPublicItemView(context);
        this.bindView(view);
        return view;
    }

    private View getPrivateItemView(Context context, View convertView) {
        ConfChatItemView.ConfChatPrivateItemView view = null;
        view = convertView instanceof ConfChatItemView.ConfChatPrivateItemView ? (ConfChatItemView.ConfChatPrivateItemView)convertView : new ConfChatItemView.ConfChatPrivateItemView(context);
        this.bindView(view);
        return view;
    }

    private void bindView(ConfChatItemView view) {
        view.setChatItem(this);
    }
}

