/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.text.Editable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.BuddyNameUtil;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.TextCommandHelper;
import com.zipow.videobox.view.EmojiEditText;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.mm.sticker.CommonEmojiHelper;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class CommandEditText
extends EmojiEditText {
    public static final String TAG = CommandEditText.class.getSimpleName();
    private String mSessionId;
    private OnCommandActionListener onCommandActionListener;
    private TextWatcher mEditMsgWatcher = new TextWatcher(){
        private int originLength;

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            this.originLength = s.length();
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (TextCommandHelper.getInstance().slashCommandAction(s, start, before, count, (Spanned)CommandEditText.this.getText())) {
                if (CommandEditText.this.onCommandActionListener != null) {
                    CommandEditText.this.onCommandActionListener.onCommandAction(1);
                }
            } else if (TextCommandHelper.getInstance().atCommandAction(s, start, before, count, (Spanned)CommandEditText.this.getText(), this.originLength) && CommandEditText.this.onCommandActionListener != null) {
                CommandEditText.this.onCommandActionListener.onCommandAction(2);
            }
        }

        public void afterTextChanged(Editable s) {
            if (TextUtils.isEmpty((CharSequence)s)) {
                TextCommandHelper.getInstance().clearTextCommand(CommandEditText.this.mSessionId);
            } else if (TextCommandHelper.getInstance().isSlashCommand((Spanned)s)) {
                TextCommandHelper.getInstance().checkAndStoreSlashCommand(CommandEditText.this.mSessionId, s);
            } else if (TextCommandHelper.getInstance().isAtCommand((Spanned)s)) {
                TextCommandHelper.getInstance().checkAndStoreAtCommand(CommandEditText.this.mSessionId, s);
            } else {
                TextCommandHelper.getInstance().storeText(CommandEditText.this.mSessionId, s.toString());
            }
        }
    };

    public CommandEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public CommandEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CommandEditText(Context context) {
        super(context);
    }

    private void restoreCommandText() {
        TextCommandHelper.DraftBean draftBean = TextCommandHelper.getInstance().restoreTextCommand(this.mSessionId);
        if (draftBean != null) {
            SpannableString spannableString = new SpannableString((CharSequence)(draftBean.getLabel() == null ? "" : draftBean.getLabel()));
            if (draftBean.getSpans() != null && !TextUtils.isEmpty((CharSequence)spannableString)) {
                for (TextCommandHelper.SpanBean spanBean : draftBean.getSpans()) {
                    int type = spanBean.getType();
                    if (type == 1) {
                        TextCommandHelper.SlashSpan slashSpan = new TextCommandHelper.SlashSpan(spanBean);
                        spannableString.setSpan((Object)slashSpan, spanBean.getStart(), spanBean.getEnd(), 33);
                        continue;
                    }
                    if (type != 2) continue;
                    TextCommandHelper.AtSpan span = new TextCommandHelper.AtSpan(spanBean);
                    spannableString.setSpan((Object)span, spanBean.getStart(), spanBean.getEnd(), 33);
                }
            }
            this.setText(CommonEmojiHelper.getInstance().formatImgEmojiSize(this.getTextSize(), (CharSequence)spannableString, true));
            this.setSelection(this.getText().length());
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.addTextChangedListener(this.mEditMsgWatcher);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeTextChangedListener(this.mEditMsgWatcher);
    }

    public List<TextCommandHelper.SpanBean> getTextCommand(int type) {
        ArrayList<TextCommandHelper.SpanBean> result;
        block4: {
            TextCommandHelper.AtSpan[] spans;
            Editable editable;
            block3: {
                result = new ArrayList<TextCommandHelper.SpanBean>();
                editable = this.getEditableText();
                if (type != 1) break block3;
                TextCommandHelper.SlashSpan[] spans2 = (TextCommandHelper.SlashSpan[])editable.getSpans(0, editable.length(), TextCommandHelper.SlashSpan.class);
                if (spans2 == null || spans2.length <= 0) break block4;
                for (TextCommandHelper.SlashSpan slashSpan : spans2) {
                    result.add(new TextCommandHelper.SpanBean(editable.getSpanStart((Object)slashSpan), editable.getSpanEnd((Object)slashSpan), slashSpan));
                }
                break block4;
            }
            if (type == 2 && (spans = (TextCommandHelper.AtSpan[])editable.getSpans(0, editable.length(), TextCommandHelper.AtSpan.class)) != null && spans.length > 0) {
                for (TextCommandHelper.AtSpan atSpan : spans) {
                    result.add(new TextCommandHelper.SpanBean(editable.getSpanStart((Object)atSpan), editable.getSpanEnd((Object)atSpan), atSpan));
                }
            }
        }
        return result;
    }

    public void addAtCommandByJid(String jid) {
        String label;
        if (TextUtils.isEmpty((CharSequence)jid)) {
            return;
        }
        int index = -1;
        if (jid.equalsIgnoreCase("jid_select_everyone")) {
            String tmp;
            label = '@' + this.getResources().getString(R.string.zm_lbl_select_everyone) + " ";
            String content = this.getText().toString();
            index = content.indexOf(label);
            if (index < 0 && (index = content.indexOf(tmp = '@' + this.getResources().getString(R.string.zm_lbl_select_everyone))) >= 0) {
                this.getEditableText().insert(index + tmp.length(), (CharSequence)" ");
            }
        } else {
            String tmp;
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
            String name = BuddyNameUtil.getBuddyDisplayName(buddy, IMAddrBookItem.fromZoomBuddy(buddy));
            if (TextUtils.isEmpty((CharSequence)name)) {
                return;
            }
            label = '@' + name + " ";
            String content = this.getText().toString();
            index = content.indexOf(label);
            if (index < 0 && (index = content.indexOf(tmp = '@' + name)) >= 0) {
                this.getEditableText().insert(index + tmp.length(), (CharSequence)" ");
            }
        }
        if (index >= 0) {
            Editable edittable = this.getEditableText();
            TextCommandHelper.AtSpan span = new TextCommandHelper.AtSpan();
            span.jId = jid;
            span.label = label;
            edittable.setSpan((Object)span, index, index + label.length(), 33);
        }
    }

    public void addTextCommand(int type, String label, String jId, int start) {
        this.addTextCommand(type, label, "", jId, start);
    }

    public void addTextCommand(int type, String label, String content, String jId, int start) {
        if (start < 0 || TextUtils.isEmpty((CharSequence)label)) {
            return;
        }
        if (type == 1) {
            TextCommandHelper.SlashSpan slashSpan = new TextCommandHelper.SlashSpan();
            slashSpan.jId = jId;
            slashSpan.label = label;
            Editable edittable = this.getEditableText();
            edittable.clear();
            edittable.append((CharSequence)slashSpan.label).append((CharSequence)" ").append((CharSequence)content);
            edittable.setSpan((Object)slashSpan, start, start + label.length() + 1, 33);
            this.setText((CharSequence)edittable);
            this.setSelection(edittable.length());
        } else if (type == 2) {
            Editable edittable = this.getEditableText();
            TextCommandHelper.AtSpan span = new TextCommandHelper.AtSpan();
            span.jId = jId;
            span.label = label;
            SpannableString spannableString = new SpannableString((CharSequence)label);
            edittable.insert(start, (CharSequence)spannableString);
            edittable.setSpan((Object)span, start, start + label.length(), 33);
        }
    }

    public void enableStoreCommand(String sessionid) {
        this.mSessionId = sessionid;
        this.restoreCommandText();
    }

    public void setOnCommandActionListener(OnCommandActionListener onCommandActionListener) {
        this.onCommandActionListener = onCommandActionListener;
    }

    public SendMsgType judgeSlashCommand(String sessionId, boolean checkPainText) {
        ZoomBuddy buddy;
        if (TextUtils.isEmpty((CharSequence)this.getText())) {
            return SendMsgType.MESSAGE;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return SendMsgType.MESSAGE;
        }
        ZoomChatSession session = messenger.getSessionById(sessionId);
        if (session == null) {
            return SendMsgType.MESSAGE;
        }
        boolean isGroup = session.isGroup();
        if (!isGroup && messenger != null && (buddy = session.getSessionBuddy()) != null && buddy.isRobot()) {
            this.addTextCommand(1, buddy.getRobotCmdPrefix(), this.getText().toString(), buddy.getJid(), 0);
            return SendMsgType.SLASH_COMMAND;
        }
        List<TextCommandHelper.SpanBean> list = this.getTextCommand(1);
        if (list == null || list.isEmpty()) {
            if (checkPainText) {
                if (this.hasSlashCommand(sessionId)) {
                    return SendMsgType.SLASH_COMMAND;
                }
                return SendMsgType.MESSAGE;
            }
            return SendMsgType.MESSAGE;
        }
        TextCommandHelper.SpanBean spanBean = list.get(0);
        String label = this.getText().subSequence(spanBean.getStart(), spanBean.getEnd()).toString();
        if (!TextUtils.isEmpty((CharSequence)spanBean.getJid()) && StringUtil.isSameString((String)label.trim(), (String)spanBean.getLabel().trim())) {
            return SendMsgType.SLASH_COMMAND;
        }
        if (StringUtil.isSameString((String)"/giphy", (String)spanBean.getLabel().trim())) {
            return SendMsgType.GIPHY;
        }
        return SendMsgType.MESSAGE;
    }

    private boolean hasSlashCommand(String sessionId) {
        String content = this.getText().toString().trim();
        if (TextUtils.isEmpty((CharSequence)content)) {
            return false;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return false;
        }
        ZoomChatSession session = messenger.getSessionById(sessionId);
        if (session == null) {
            return false;
        }
        boolean isGroup = session.isGroup();
        if (isGroup) {
            ZoomGroup group = session.getSessionGroup();
            if (group == null) {
                return false;
            }
            List<String> robotBuddies = messenger.getAllRobotBuddies(group.getGroupID());
            if (robotBuddies == null || robotBuddies.isEmpty()) {
                return false;
            }
            for (int i = 0; i < robotBuddies.size(); ++i) {
                ZoomBuddy buddy = messenger.getBuddyWithJID(robotBuddies.get(i));
                if (buddy == null || !buddy.isRobot() || TextUtils.isEmpty((CharSequence)buddy.getRobotCmdPrefix()) || !content.startsWith(buddy.getRobotCmdPrefix().trim())) continue;
                String[] tmp = content.split(" ");
                this.addTextCommand(1, buddy.getRobotCmdPrefix(), tmp.length > 1 ? tmp[1] : "", buddy.getJid(), 0);
                return true;
            }
        } else {
            ZoomBuddy buddy = session.getSessionBuddy();
            if (buddy == null) {
                return false;
            }
            if (!buddy.isRobot() || TextUtils.isEmpty((CharSequence)buddy.getRobotCmdPrefix())) {
                return false;
            }
            if (content.startsWith(buddy.getRobotCmdPrefix())) {
                String[] tmp = content.split(" ");
                this.addTextCommand(1, buddy.getRobotCmdPrefix(), tmp.length > 1 ? tmp[1] : "", buddy.getJid(), 0);
                return true;
            }
        }
        return false;
    }

    public static interface OnCommandActionListener {
        public void onCommandAction(int var1);
    }

    public static enum SendMsgType {
        MESSAGE,
        SLASH_COMMAND,
        GIPHY;

    }
}

