/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.ConfChatMessage;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.fragment.ConfChatFragment;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.AvatarView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMTipFragment;
import us.zoom.androidlib.widget.ZMTip;
import us.zoom.videomeetings.R;

public class ChatTip
extends ZMTipFragment
implements View.OnClickListener {
    private static final int MAX_CHAT_TIP_NUMBER = 2;
    public static final String ARG_NAME = "name";
    public static final String ARG_AVATAR = "avatar";
    public static final String ARG_MESSAGE = "message";
    public static final String ARG_ANCHOR_ID = "anchorId";
    public static final String ARG_SENDER = "sender";
    public static final String ARG_RECEIVER = "receiver";
    public static final String ARG_CHAT_TIP_INDEX = "chatTipIndex";
    public static final String ARG_MESSAGE_ID = "messageId";
    private static int gChatTipIndex = 0;

    public static void show(FragmentManager fragmentMgr, String avatar, String name, String message, long sender, long receiver, int anchorId, String messageId) {
        if (fragmentMgr == null) {
            return;
        }
        ChatTip.dismissExceedChatTips(fragmentMgr);
        Bundle args = new Bundle();
        args.putString(ARG_AVATAR, avatar);
        args.putString(ARG_NAME, name);
        args.putString(ARG_MESSAGE, message);
        args.putLong(ARG_SENDER, sender);
        args.putLong(ARG_RECEIVER, receiver);
        args.putInt(ARG_ANCHOR_ID, anchorId);
        args.putInt(ARG_CHAT_TIP_INDEX, gChatTipIndex++);
        args.putString(ARG_MESSAGE_ID, messageId);
        ChatTip tip = new ChatTip();
        tip.setArguments(args);
        tip.show(fragmentMgr, ChatTip.class.getName(), 6000L);
        fragmentMgr.executePendingTransactions();
    }

    private static void dismissExceedChatTips(FragmentManager fragmentMgr) {
        List frags = fragmentMgr.getFragments();
        if (frags != null) {
            ArrayList<ChatTip> chatFrags = new ArrayList<ChatTip>();
            int count = 0;
            for (Fragment f : frags) {
                if (!(f instanceof ChatTip)) continue;
                ++count;
                chatFrags.add((ChatTip)f);
                ((ChatTip)f).setTransparent();
            }
            if (count >= 2) {
                Collections.sort(chatFrags, new ChatTipComparator());
                for (int i = 0; i < chatFrags.size(); ++i) {
                    Fragment f;
                    f = (Fragment)chatFrags.get(i);
                    ((ChatTip)f).dismiss();
                    if (--count < 2) break;
                }
            }
        }
    }

    public static boolean isShown(FragmentManager fragmentMgr) {
        if (fragmentMgr == null) {
            return false;
        }
        ChatTip tip = (ChatTip)fragmentMgr.findFragmentByTag(ChatTip.class.getName());
        return tip != null;
    }

    public static boolean dismiss(FragmentManager fragmentMgr) {
        if (fragmentMgr == null) {
            return false;
        }
        List frags = fragmentMgr.getFragments();
        if (frags == null) {
            return false;
        }
        boolean found = false;
        for (Fragment f : frags) {
            if (!(f instanceof ChatTip)) continue;
            ((ChatTip)f).dismiss();
            found = true;
        }
        return found;
    }

    public ZMTip onCreateTip(Context context, LayoutInflater layoutInflater, Bundle savedInstanceState) {
        CmmConfContext confContext;
        View view = layoutInflater.inflate(R.layout.zm_chat_tip, null);
        View contentView = view.findViewById(R.id.content);
        AvatarView avatar = (AvatarView)view.findViewById(R.id.avatarView);
        TextView txtScreenName = (TextView)view.findViewById(R.id.txtScreenName);
        TextView txtMessage = (TextView)view.findViewById(R.id.txtMessage);
        Bundle args = this.getArguments();
        String avatarSrc = args.getString(ARG_AVATAR);
        avatar.setAvatar(avatarSrc);
        long receiver = args.getLong(ARG_RECEIVER);
        String msgID = args.getString(ARG_MESSAGE_ID);
        boolean isWebinar = false;
        if (ConfMgr.getInstance().isConfConnected() && (confContext = ConfMgr.getInstance().getConfContext()) != null && confContext.isWebinar()) {
            isWebinar = true;
        }
        String title = null;
        if (isWebinar) {
            ConfMgr confMgr = ConfMgr.getInstance();
            ConfChatMessage message = confMgr.getChatMessageItemByID(msgID);
            if (message == null) {
                return null;
            }
            String receiveName = message.getReceiverDisplayName();
            CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
            if (confStatus != null && confStatus.isMyself(message.getReceiverID())) {
                receiveName = this.getString(R.string.zm_webinar_txt_me);
            }
            switch (message.getMsgType()) {
                case 0: {
                    receiveName = this.getString(R.string.zm_webinar_txt_everyone);
                    break;
                }
                case 2: {
                    receiveName = this.getString(R.string.zm_webinar_txt_label_ccPanelist, new Object[]{receiveName, this.getString(R.string.zm_webinar_txt_all_panelists)});
                    break;
                }
                case 1: {
                    receiveName = this.getString(R.string.zm_webinar_txt_all_panelists);
                    break;
                }
            }
            title = this.getString(R.string.zm_webinar_txt_label_from, new Object[]{message.getSenderDisplayName(), receiveName});
            if (TextUtils.isEmpty((CharSequence)avatarSrc)) {
                avatar.setVisibility(8);
            }
        } else {
            title = this.getString(receiver == 0L ? R.string.zm_title_conf_chat_public : R.string.zm_title_conf_chat_private_from, new Object[]{args.getString(ARG_NAME)});
        }
        txtScreenName.setText((CharSequence)title);
        txtMessage.setText((CharSequence)args.getString(ARG_MESSAGE));
        ZMTip tip = new ZMTip(context);
        tip.addView(view);
        int anchorId = args.getInt(ARG_ANCHOR_ID, 0);
        if (anchorId > 0) {
            View anchor = this.getActivity().findViewById(anchorId);
            if (anchor != null) {
                tip.setAnchor(anchor, UIMgr.isLargeMode((Context)this.getActivity()) ? 1 : 3);
            }
        } else {
            tip.setOverlyingType(1);
        }
        contentView.setOnClickListener((View.OnClickListener)this);
        tip.setBackgroundColor(context.getResources().getColor(R.color.zm_message_tip_background));
        tip.setBorderColor(context.getResources().getColor(R.color.zm_message_tip_border));
        tip.setShadow(4.0f, 0, 0, context.getResources().getColor(R.color.zm_message_tip_shadow));
        return tip;
    }

    public void onClick(View v) {
        this.dismiss();
        this.showInChatUI();
    }

    public void setTransparent() {
        ZMTip zmTip = this.getTip();
        if (zmTip != null && this.getShowsTip()) {
            zmTip.setAlpha(0.5f);
        }
    }

    private void showInChatUI() {
        CmmConfContext confContext;
        boolean isWebinar = false;
        if (ConfMgr.getInstance().isConfConnected() && (confContext = ConfMgr.getInstance().getConfContext()) != null && confContext.isWebinar()) {
            isWebinar = true;
        }
        Bundle args = this.getArguments();
        long sender = args.getLong(ARG_SENDER);
        long receiver = args.getLong(ARG_RECEIVER);
        long userId = isWebinar || receiver != 0L ? sender : 0L;
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        if (UIMgr.isLargeMode((Context)activity)) {
            ConfChatFragment.showAsFragment(this.getFragmentManager(), userId);
        } else {
            ConfChatFragment.showAsActivity((ZMActivity)activity, 1002, userId);
        }
        ChatTip.dismiss(this.getFragmentManager());
    }

    public static class ChatTipComparator
    implements Comparator<ChatTip> {
        @Override
        public int compare(ChatTip lhs, ChatTip rhs) {
            Bundle argR;
            long idxL = 0L;
            long idxR = 0L;
            Bundle argL = lhs.getArguments();
            if (argL != null) {
                idxL = argL.getInt(ChatTip.ARG_CHAT_TIP_INDEX, 0);
            }
            if ((argR = rhs.getArguments()) != null) {
                idxR = argR.getInt(ChatTip.ARG_CHAT_TIP_INDEX, 0);
            }
            return (int)(idxL - idxR);
        }
    }
}

