/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.zipow.videobox.ptapp.IMHelper;
import com.zipow.videobox.ptapp.IMSubscription;
import com.zipow.videobox.ptapp.PTApp;
import java.util.ArrayList;
import java.util.List;
import us.zoom.videomeetings.R;

public class BuddyInviteListView
extends ListView {
    private BuddyInviteListAdapter mAdapter;

    public BuddyInviteListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public BuddyInviteListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public BuddyInviteListView(Context context) {
        super(context);
        this.initView();
    }

    public void reloadAllItems() {
        this.mAdapter.clear();
        this.loadAllItems(this.mAdapter);
        this.mAdapter.notifyDataSetChanged();
        this.setVisibility(this.mAdapter.isEmpty() ? 4 : 0);
    }

    private void initView() {
        this.mAdapter = new BuddyInviteListAdapter(this.getContext(), this);
        if (this.isInEditMode()) {
            this._editmode_loadAllItems(this.mAdapter);
        } else {
            this.loadAllItems(this.mAdapter);
        }
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    private void _editmode_loadAllItems(BuddyInviteListAdapter adapter) {
        for (int i = 0; i < 10; ++i) {
            IMSubscription item = new IMSubscription("buddy" + i + "@zoom.us", "test", 0);
            adapter.addItem(item);
        }
    }

    private void loadAllItems(BuddyInviteListAdapter adapter) {
        IMHelper imHelper = PTApp.getInstance().getIMHelper();
        if (imHelper == null) {
            return;
        }
        IMSubscription[] subscriptions = imHelper.getUnhandledSubscriptions();
        if (subscriptions == null) {
            return;
        }
        for (IMSubscription item : subscriptions) {
            adapter.addItem(item);
        }
    }

    static class BuddyInviteListAdapter
    extends BaseAdapter {
        private static final int ITEM_TYPE_NORMAL = 0;
        private List<IMSubscription> mItems = new ArrayList<IMSubscription>();
        private Context mContext;
        private BuddyInviteListView mListView;

        public BuddyInviteListAdapter(Context context, BuddyInviteListView listView) {
            assert (context != null);
            this.mContext = context;
            this.mListView = listView;
        }

        public void clear() {
            this.mItems.clear();
        }

        public void addItem(IMSubscription item) {
            this.updateItem(item);
        }

        public void updateItem(IMSubscription item) {
            assert (item != null);
            int position = this.findItem(item.getJid());
            if (position >= 0) {
                this.mItems.set(position, item);
            } else {
                this.mItems.add(item);
            }
        }

        public int findItem(String jid) {
            if (jid == null) {
                return -1;
            }
            for (int i = 0; i < this.mItems.size(); ++i) {
                IMSubscription item = this.mItems.get(i);
                if (!jid.equals(item.getJid())) continue;
                return i;
            }
            return -1;
        }

        public void removeItem(String jid) {
            int position = this.findItem(jid);
            if (position >= 0) {
                this.removeItemAt(position);
            }
        }

        public void removeItemAt(int position) {
            if (position < 0 || position >= this.mItems.size()) {
                return;
            }
            this.mItems.remove(position);
        }

        public int getCount() {
            return this.mItems.size();
        }

        public Object getItem(int position) {
            if (position < 0 || position >= this.getCount()) {
                return null;
            }
            return this.mItems.get(position);
        }

        public IMSubscription getItemByJid(String jid) {
            for (IMSubscription item : this.mItems) {
                if (!item.getJid().equals(jid)) continue;
                return item;
            }
            return null;
        }

        public long getItemId(int position) {
            return position;
        }

        public int getItemViewType(int position) {
            return 0;
        }

        public int getViewTypeCount() {
            return 1;
        }

        public View getView(final int position, View convertView, ViewGroup parent) {
            if (position < 0 || position >= this.getCount()) {
                return null;
            }
            IMSubscription item = (IMSubscription)this.getItem(position);
            View view = null;
            if (convertView != null && "BuddyInviteItem".equals(convertView.getTag())) {
                view = convertView;
            } else {
                view = View.inflate((Context)this.mContext, (int)R.layout.zm_buddy_invite_item, null);
                view.setTag((Object)"BuddyInviteItem");
            }
            TextView txtJid = (TextView)view.findViewById(R.id.txtJid);
            Button btnAccept = (Button)view.findViewById(R.id.btnAccept);
            Button btnDecline = (Button)view.findViewById(R.id.btnDecline);
            txtJid.setText((CharSequence)item.getJid());
            btnAccept.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BuddyInviteListAdapter.this.acknowledgeSubscription(position, true);
                }
            });
            btnDecline.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BuddyInviteListAdapter.this.acknowledgeSubscription(position, false);
                }
            });
            return view;
        }

        private void acknowledgeSubscription(int position, boolean accept) {
            IMSubscription item = (IMSubscription)this.getItem(position);
            if (item == null) {
                return;
            }
            IMHelper imHelper = PTApp.getInstance().getIMHelper();
            if (imHelper == null) {
                return;
            }
            imHelper.acknowledgeSubscription(item.getJid(), accept);
            this.mListView.reloadAllItems();
        }
    }
}

