/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.JoinConfActivity;
import com.zipow.videobox.ScheduleActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.fragment.HostMeetingFragment_v2;
import com.zipow.videobox.fragment.IMMyMeetingsFragment;
import com.zipow.videobox.fragment.JoinConfFragment;
import com.zipow.videobox.fragment.MMChatsListFragment;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.ToolbarButton;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.videomeetings.R;

public abstract class BaseMeetingToolbar
extends LinearLayout
implements View.OnClickListener {
    protected ToolbarButton mBtnJoin;
    protected ToolbarButton mBtnStart;
    protected ToolbarButton mBtnUpcoming;
    private MMChatsListFragment mParentFragment;

    public BaseMeetingToolbar(Context context) {
        this(context, null);
    }

    public BaseMeetingToolbar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
        this.setFocusable(false);
    }

    protected abstract void initView(Context var1);

    public abstract void refresh();

    public void setParentFragment(MMChatsListFragment fragment) {
        this.mParentFragment = fragment;
    }

    public void onClick(View v) {
        long id2 = v.getId();
        if (id2 == (long)R.id.btnJoin) {
            if (PTApp.getInstance().hasActiveCall() && VideoBoxApplication.getInstance().isConfProcessRunning()) {
                this.onClickActionItemBackToMeeting();
            } else {
                this.onClickActionItemJoinById();
            }
        } else if (id2 == (long)R.id.btnStart) {
            this.onClickActionItemHostMeeting();
        } else if (id2 == (long)R.id.btnSchedule) {
            this.onClickBtnScheduleMeeting();
        } else if (id2 == (long)R.id.btnUpcoming) {
            this.onClickBtnUpcomingMeetings();
        }
    }

    protected void setToolbar(ToolbarButton toolbarButton, int wh, int bgResId) {
        toolbarButton.setTextStyle(1);
        toolbarButton.setIconBackgroundResource(bgResId);
        toolbarButton.setIconScaleType(ImageView.ScaleType.CENTER);
        toolbarButton.setIconSize(wh, wh);
    }

    private void onClickActionItemJoinById() {
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null) {
            return;
        }
        if (UIMgr.isLargeMode((Context)activity)) {
            FragmentManager fm = activity.getSupportFragmentManager();
            if (fm == null) {
                return;
            }
            JoinConfFragment.showJoinByNumber(fm, null, null);
        } else {
            JoinConfActivity.showJoinByNumber((Context)activity, null, null);
        }
    }

    private void onClickActionItemBackToMeeting() {
        if (!PTApp.getInstance().hasActiveCall()) {
            this.refresh();
            return;
        }
        ConfActivity.returnToConf(this.getContext());
    }

    private void onClickActionItemHostMeeting() {
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null) {
            return;
        }
        HostMeetingFragment_v2.showAsActivity(activity);
    }

    private void onClickBtnUpcomingMeetings() {
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null) {
            return;
        }
        IMMyMeetingsFragment.showAsActivity(activity);
    }

    private void onClickBtnScheduleMeeting() {
        ScheduleActivity.show((Fragment)this.mParentFragment, 1002);
    }
}

