/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.util.ImageLoader;
import com.zipow.videobox.util.LazyLoadDrawable;
import com.zipow.videobox.util.NameAbbrAvatarDrawable;
import com.zipow.videobox.util.RoundDrawable;
import com.zipow.videobox.util.zmurl.avatar.ZMAvatarCornerParams;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class AvatarView
extends LinearLayout {
    private ImageView mImgAvatar;
    private float mCornerRadiusRatio = 0.0f;
    private String mName = null;
    private String mBgColorSeedString = null;
    private boolean mIsEmptyAvatar = true;
    private int mBorderColor = -1;
    private int mBorderSize;
    private boolean mbContentDescriptionEnable = true;

    public AvatarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    public AvatarView(Context context) {
        super(context);
        this.initView(context, null);
    }

    private void initView(Context context, AttributeSet attrs) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
        this.inflateLayout();
        this.mImgAvatar = (ImageView)this.findViewById(R.id.imgAvator);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AvatarView);
        this.mCornerRadiusRatio = a.getFloat(R.styleable.AvatarView_zm_cornerRadiusRatio, 0.5f);
        this.mBorderColor = a.getColor(R.styleable.AvatarView_zm_avatarBorderColor, this.mBorderColor);
        this.mbContentDescriptionEnable = a.getBoolean(R.styleable.AvatarView_zm_description_enable, true);
        a.recycle();
        this.mBorderSize = UIUtil.dip2px((Context)VideoBoxApplication.getInstance(), (float)1.0f);
        this.setAvatar(this.getEmptyAvatar());
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_avatar, (ViewGroup)this);
    }

    public void setBorderSize(int size) {
        this.mBorderSize = size;
        Drawable drawable2 = this.mImgAvatar.getDrawable();
        if (drawable2 instanceof RoundDrawable) {
            ((RoundDrawable)drawable2).setBorderSize(size);
        }
        if (this.isShown()) {
            this.invalidate();
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        Drawable drawable2;
        if (this.hasRoundCorner() && (drawable2 = this.mImgAvatar.getDrawable()) instanceof RoundDrawable && ((RoundDrawable)drawable2).setClientSize(r - l, b - t)) {
            this.mImgAvatar.setImageDrawable(null);
            this.mImgAvatar.setImageDrawable(drawable2);
        }
        super.onLayout(changed, l, t, r, b);
    }

    public void setName(CharSequence name) {
        this.mName = name == null ? null : name.toString();
        if (this.mBgColorSeedString == null) {
            this.mBgColorSeedString = this.mName;
        }
        if (this.mIsEmptyAvatar) {
            this.setAvatar(this.getEmptyAvatar());
        }
        if (this.mbContentDescriptionEnable && null != this.mName) {
            this.mImgAvatar.setContentDescription((CharSequence)this.mName);
        }
    }

    public void setBgColorSeedString(String str) {
        if (str != null) {
            this.mBgColorSeedString = str;
        }
    }

    public void setCornerRadiusRatio(float ratio) {
        this.mCornerRadiusRatio = ratio;
        if (this.isShown()) {
            this.invalidate();
        }
    }

    public void setBorderColor(int color2) {
        this.mBorderColor = color2;
        Drawable drawable2 = this.mImgAvatar.getDrawable();
        if (drawable2 instanceof RoundDrawable) {
            ((RoundDrawable)drawable2).setBorderColor(this.mBorderColor);
        }
        if (this.isShown()) {
            this.invalidate();
        }
    }

    public void setAvatar(String imgPathName) {
        this.setAvatar(imgPathName, 0);
    }

    private boolean hasRoundCorner() {
        return (int)(this.mCornerRadiusRatio * 1000.0f) > 0;
    }

    public void setAvatar(String imgPathName, int presence) {
        LazyLoadDrawable drawable2;
        boolean set = false;
        if (imgPathName != null && (drawable2 = new LazyLoadDrawable(imgPathName)).isValidDrawable()) {
            if (this.hasRoundCorner()) {
                this.mImgAvatar.setImageDrawable((Drawable)new RoundDrawable(drawable2, this.mCornerRadiusRatio, this.mBorderColor, true, this.getWidth(), this.getHeight(), this.mBorderSize));
            } else {
                this.mImgAvatar.setImageDrawable((Drawable)drawable2);
            }
            set = true;
            this.mIsEmptyAvatar = false;
        }
        if (!set) {
            if (this.hasRoundCorner()) {
                this.mImgAvatar.setImageDrawable((Drawable)new RoundDrawable(this.getEmptyAvatar(), this.mCornerRadiusRatio, this.mBorderColor, true, this.getWidth(), this.getHeight(), this.mBorderSize));
            } else {
                this.mImgAvatar.setImageDrawable(this.getEmptyAvatar());
            }
            this.mIsEmptyAvatar = true;
        }
    }

    public void setAvatar(Bitmap bitmap) {
        this.setAvatar(bitmap, 0);
    }

    public void setAvatar(Bitmap bitmap, int presence) {
        this.setAvatar((Drawable)(bitmap != null ? new BitmapDrawable(this.getResources(), bitmap) : null), presence);
    }

    public void setAvatar(int resId) {
        this.setAvatar(resId, 0);
    }

    public void setAvatar(int resId, int presence) {
        if (this.hasRoundCorner()) {
            this.mImgAvatar.setImageDrawable((Drawable)new RoundDrawable(this.getResources().getDrawable(resId), this.mCornerRadiusRatio, this.mBorderColor, true, this.getWidth(), this.getHeight(), this.mBorderSize));
        } else {
            this.mImgAvatar.setImageResource(resId);
        }
        this.mIsEmptyAvatar = false;
    }

    public void setAvatar(Drawable drawable2) {
        this.setAvatar(drawable2, 0);
    }

    public void setAvatar(Drawable drawable2, int presence) {
        if (drawable2 != null) {
            if (this.hasRoundCorner()) {
                this.mImgAvatar.setImageDrawable((Drawable)new RoundDrawable(drawable2, this.mCornerRadiusRatio, this.mBorderColor, true, this.getWidth(), this.getHeight(), this.mBorderSize));
            } else {
                this.mImgAvatar.setImageDrawable(drawable2);
            }
            this.mIsEmptyAvatar = false;
        } else {
            ZMAvatarCornerParams params = null;
            if (this.hasRoundCorner()) {
                params = new ZMAvatarCornerParams(this.mCornerRadiusRatio, this.mBorderColor, true, this.getWidth(), this.getHeight(), this.mBorderSize);
            }
            ImageLoader.getInstance().displayAvatar(this.mImgAvatar, this.mName, this.mBgColorSeedString, params, this.mImgAvatar.getDrawable());
            this.mIsEmptyAvatar = true;
        }
    }

    private Drawable getEmptyAvatar() {
        if (StringUtil.isEmptyOrNull((String)this.mName)) {
            return this.getResources().getDrawable(R.drawable.zm_no_avatar);
        }
        return new NameAbbrAvatarDrawable(this.mName, this.mBgColorSeedString);
    }
}

