/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.zipow.videobox.CallInActivity;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.confapp.AudioSessionMgr;
import com.zipow.videobox.confapp.CmmAudioStatus;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.fragment.CallMeByPhoneFragment;
import com.zipow.videobox.fragment.SwitchAudioSourceDialog;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.util.UIMgr;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMTipFragment;
import us.zoom.androidlib.util.AccessibilityUtil;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.ParamsList;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMTip;
import us.zoom.androidlib.widget.ZMTipLayer;
import us.zoom.videomeetings.R;

public class AudioTip
extends ZMTipFragment
implements View.OnClickListener {
    private static final String TAG = AudioTip.class.getSimpleName();
    public static final String ARG_ANCHOR_ID = "anchorId";
    private static final int REQUEST_AUDIO_PERMISSION_CALL_VIOP = 8000;
    private boolean mIsCallingVoIP = false;
    private View mProgressCallVoIP;
    private View mBtnCallViaVoIP;
    private View mBtnDialIn;
    private View mBtnCallMe;
    private View mBtnDisconnectVoIP;
    private View mBtnSwitchAudioSource;
    private TextView mBtnMutePhone;
    private TextView mTxtCallViaVoIP;
    private boolean mIsMuted = false;

    public static void show(FragmentManager fragmentMgr, int anchorId) {
        if (fragmentMgr == null) {
            return;
        }
        Bundle args = new Bundle();
        args.putInt(ARG_ANCHOR_ID, anchorId);
        AudioTip tip = new AudioTip();
        tip.setArguments(args);
        tip.show(fragmentMgr, AudioTip.class.getName());
    }

    public static void updateIfExists(FragmentManager fragmentMgr) {
        if (fragmentMgr == null) {
            return;
        }
        AudioTip tip = (AudioTip)fragmentMgr.findFragmentByTag(AudioTip.class.getName());
        if (tip != null) {
            tip.updateUI();
        }
    }

    public static boolean isShown(FragmentManager fragmentMgr) {
        if (fragmentMgr == null) {
            return false;
        }
        AudioTip tip = (AudioTip)fragmentMgr.findFragmentByTag(AudioTip.class.getName());
        return tip != null;
    }

    public static boolean dismiss(FragmentManager fragmentMgr) {
        if (fragmentMgr == null) {
            return false;
        }
        AudioTip tip = (AudioTip)fragmentMgr.findFragmentByTag(AudioTip.class.getName());
        if (tip != null) {
            tip.dismiss();
            return true;
        }
        return false;
    }

    public ZMTip onCreateTip(Context context, LayoutInflater layoutInflater, Bundle savedInstanceState) {
        View anchor;
        View view = layoutInflater.inflate(R.layout.zm_audio_tip, null);
        this.mBtnCallViaVoIP = view.findViewById(R.id.btnCallViaVoIP);
        this.mBtnDialIn = view.findViewById(R.id.btnDialIn);
        this.mBtnCallMe = view.findViewById(R.id.btnCallMe);
        this.mProgressCallVoIP = view.findViewById(R.id.progressCallVoIP);
        this.mBtnDisconnectVoIP = view.findViewById(R.id.btnDisconnectVoIP);
        this.mBtnSwitchAudioSource = view.findViewById(R.id.btnSwitchAudioSource);
        this.mBtnMutePhone = (TextView)view.findViewById(R.id.btnMutePhone);
        this.mTxtCallViaVoIP = (TextView)view.findViewById(R.id.txtCallViaVoIP);
        Bundle args = this.getArguments();
        ZMTip tip = new ZMTip(context);
        tip.addView(view);
        int anchorId = args.getInt(ARG_ANCHOR_ID, 0);
        if (anchorId > 0 && (anchor = this.getActivity().findViewById(anchorId)) != null) {
            tip.setAnchor(anchor, UIMgr.isLargeMode((Context)this.getActivity()) ? 1 : 3);
        }
        if (savedInstanceState != null) {
            this.mIsCallingVoIP = savedInstanceState.getBoolean("mIsCallingVoIP");
        }
        this.updateUI();
        this.mBtnCallViaVoIP.setOnClickListener((View.OnClickListener)this);
        this.mBtnDialIn.setOnClickListener((View.OnClickListener)this);
        this.mBtnCallMe.setOnClickListener((View.OnClickListener)this);
        this.mBtnDisconnectVoIP.setOnClickListener((View.OnClickListener)this);
        this.mBtnSwitchAudioSource.setOnClickListener((View.OnClickListener)this);
        this.mBtnMutePhone.setOnClickListener((View.OnClickListener)this);
        return tip;
    }

    public void onResume() {
        super.onResume();
        this.updateUI();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (outState != null) {
            outState.putBoolean("mIsCallingVoIP", this.mIsCallingVoIP);
        }
    }

    private void updateUI() {
        ZMTip tip;
        if (!ConfMgr.getInstance().isConfConnected()) {
            this.dismiss();
            return;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            this.dismiss();
            return;
        }
        CmmAudioStatus audioStatus = myself.getAudioStatusObj();
        if (audioStatus == null) {
            this.dismiss();
            return;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            this.dismiss();
            return;
        }
        long audioType = audioStatus.getAudiotype();
        this.mIsMuted = audioStatus.getIsMuted();
        if (2L == audioType) {
            this.mProgressCallVoIP.setVisibility(this.mIsCallingVoIP ? 0 : 8);
            this.mBtnDisconnectVoIP.setVisibility(8);
            this.mBtnSwitchAudioSource.setVisibility(8);
            this.mBtnMutePhone.setVisibility(8);
            this.mBtnCallViaVoIP.setVisibility(this.isVoIPEnabled() ? 0 : 8);
            this.mTxtCallViaVoIP.setText(R.string.zm_btn_call_via_voip);
            if (this.isTelephonyEnabled()) {
                this.showDialInButtonIfAvailable(confContext);
            } else {
                this.mBtnDialIn.setVisibility(8);
            }
            if (this.isTelephonyEnabled()) {
                this.showCallMeIfAvailable(confContext);
            } else {
                this.mBtnCallMe.setVisibility(8);
            }
            if (AccessibilityUtil.isSpokenFeedbackEnabled((Context)this.getActivity())) {
                if (this.mProgressCallVoIP.getVisibility() == 0) {
                    this.mProgressCallVoIP.sendAccessibilityEvent(8);
                } else if (this.mBtnCallViaVoIP.getVisibility() == 0) {
                    this.mBtnCallViaVoIP.sendAccessibilityEvent(8);
                } else if (this.mBtnDialIn.getVisibility() == 0) {
                    this.mBtnDialIn.sendAccessibilityEvent(8);
                } else if (this.mBtnCallMe.getVisibility() == 0) {
                    this.mBtnCallMe.sendAccessibilityEvent(8);
                }
            }
        } else if (0L == audioType) {
            this.dismiss();
        } else if (1L == audioType) {
            if (audioStatus.getIsMuted()) {
                this.mBtnMutePhone.setText(R.string.zm_btn_unmute_phone);
            } else {
                this.mBtnMutePhone.setText(R.string.zm_btn_mute_phone);
            }
            this.mBtnDisconnectVoIP.setVisibility(8);
            this.mBtnSwitchAudioSource.setVisibility(8);
            this.mBtnMutePhone.setVisibility(0);
            this.mBtnCallViaVoIP.setVisibility(this.isVoIPEnabled() ? 0 : 8);
            this.mTxtCallViaVoIP.setText(R.string.zm_btn_switch_to_voip);
            this.mProgressCallVoIP.setVisibility(this.mIsCallingVoIP ? 0 : 8);
            this.mBtnDialIn.setVisibility(8);
            this.mBtnCallMe.setVisibility(8);
            this.mBtnMutePhone.sendAccessibilityEvent(8);
        }
        if ((tip = this.getTip()) != null) {
            ZMTipLayer parent = (ZMTipLayer)tip.getParent();
            if (parent == null) {
                return;
            }
            parent.requestLayout();
        }
    }

    private void showDialInButtonIfAvailable(CmmConfContext confContext) {
        boolean hasPhoneCallInInfo;
        if (confContext == null) {
            return;
        }
        ParamsList params = confContext.getAppContextParams();
        if (params.getBoolean("no_dial_in_via_phone", false)) {
            this.mBtnDialIn.setVisibility(8);
            return;
        }
        String phoneCallInNumber = confContext.getPhoneCallInNumber();
        String tollFreeNumber = confContext.getTollFreeCallInNumber();
        boolean bl = hasPhoneCallInInfo = !StringUtil.isEmptyOrNull((String)phoneCallInNumber) || !StringUtil.isEmptyOrNull((String)tollFreeNumber);
        if (!hasPhoneCallInInfo) {
            this.mBtnDialIn.setVisibility(8);
        } else {
            this.mBtnDialIn.setVisibility(0);
        }
    }

    private void showCallMeIfAvailable(CmmConfContext confContext) {
        if (confContext == null) {
            return;
        }
        ParamsList params = confContext.getAppContextParams();
        if (params.getBoolean("no_dial_out_to_phone", false)) {
            this.mBtnCallMe.setVisibility(8);
            return;
        }
        MeetingInfo meetingItem = confContext.getMeetingItem();
        if (meetingItem == null) {
            return;
        }
        int supportCallOutType = meetingItem.getSupportCallOutType();
        if (0 == supportCallOutType) {
            this.mBtnCallMe.setVisibility(8);
        } else {
            this.mBtnCallMe.setVisibility(0);
        }
    }

    private boolean isVoIPEnabled() {
        MeetingInfo meetingItem;
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null && (meetingItem = confContext.getMeetingItem()) != null) {
            return !meetingItem.getVoipOff();
        }
        return true;
    }

    private boolean isTelephonyEnabled() {
        MeetingInfo meetingItem;
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null && (meetingItem = confContext.getMeetingItem()) != null) {
            return !meetingItem.getTelephonyOff();
        }
        return true;
    }

    public void onClick(View v) {
        if (v == this.mBtnCallViaVoIP) {
            if (Build.VERSION.SDK_INT >= 23 && this.checkSelfPermission("android.permission.RECORD_AUDIO") != 0) {
                this.zm_requestPermissions(new String[]{"android.permission.RECORD_AUDIO"}, 8000);
            } else {
                this.onClickBtnCallViaVoIP();
            }
        } else if (v == this.mBtnDialIn) {
            this.onClickBtnDialIn();
        } else if (v == this.mBtnDisconnectVoIP) {
            this.onClickDisconnectVoIP();
        } else if (v == this.mBtnSwitchAudioSource) {
            this.onClickBtnSwitchAudioSource();
        } else if (v == this.mBtnMutePhone) {
            this.onClickBtnMute();
        } else if (v == this.mBtnCallMe) {
            this.onClickBtnCallMe();
        }
    }

    public void onRequestPermissionsResult(final int requestCode, final String[] permissions, final int[] grantResults) {
        this.getNonNullEventTaskManagerOrThrowException().pushLater("AudioTipPermissionResult", new EventAction("AudioTipPermissionResult"){

            public void run(IUIElement ui) {
                ((AudioTip)ui).handleRequestPermissionResult(requestCode, permissions, grantResults);
            }
        });
    }

    public void handleRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) {
        if (permissions == null || grantResults == null) {
            return;
        }
        for (int i = 0; i < permissions.length; ++i) {
            if ("android.permission.RECORD_AUDIO".equals(permissions[i]) && grantResults[i] == 0 && requestCode == 8000) {
                this.onClickBtnCallViaVoIP();
            }
            this.dismiss();
        }
    }

    private void onClickBtnCallViaVoIP() {
        AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
        if (audioMgr == null) {
            return;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return;
        }
        CmmAudioStatus audioStatus = myself.getAudioStatusObj();
        if (audioStatus == null) {
            return;
        }
        long audioType = audioStatus.getAudiotype();
        if (0L != audioType) {
            CmmConfStatus confStatus;
            if (1L == audioType && (confStatus = ConfMgr.getInstance().getConfStatusObj()) != null) {
                confStatus.hangUp();
            }
            this.mIsCallingVoIP = audioMgr.turnOnOffAudioSession(true);
        }
        this.mProgressCallVoIP.setVisibility(this.mIsCallingVoIP ? 0 : 8);
    }

    private void onClickBtnDialIn() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity != null) {
            CallInActivity.show(activity, 1003);
        }
        this.dismiss();
    }

    private void onClickBtnMute() {
        ConfActivity activity = (ConfActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        activity.muteAudio(!this.mIsMuted);
        this.dismiss();
    }

    private void onClickDisconnectVoIP() {
        AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
        if (audioMgr == null) {
            return;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return;
        }
        CmmAudioStatus audioStatus = myself.getAudioStatusObj();
        if (audioStatus == null) {
            return;
        }
        long audioType = audioStatus.getAudiotype();
        if (0L == audioType) {
            audioMgr.turnOnOffAudioSession(false);
        }
        this.dismiss();
    }

    private void onClickBtnCallMe() {
        ConfActivity activity = (ConfActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        Intent intent = new Intent(activity.getPackageName() + ".intent.action.CallMyPhone");
        if (AndroidAppUtil.hasActivityForIntent((Context)activity, (Intent)intent)) {
            try {
                this.startActivityForResult(intent, 1008);
            }
            catch (Exception exception) {}
        } else {
            CallMeByPhoneFragment.showAsActivity(activity, 1008);
        }
    }

    private void onClickBtnSwitchAudioSource() {
        SwitchAudioSourceDialog.showDialog(this.getFragmentManager());
        this.dismiss();
    }
}

