/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.support.annotation.NonNull;
import com.zipow.videobox.fragment.MyProfileFragment;
import com.zipow.videobox.ptapp.AlterHost;
import com.zipow.videobox.ptapp.MeetingHelper;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUserProfile;
import com.zipow.videobox.ptapp.UrlActionInfo;
import com.zipow.videobox.ptapp.ZoomProductHelper;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.view.ScheduledMeetingItem;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.FingerprintUtil;
import us.zoom.androidlib.util.OsUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.TimeUtil;

public class ZmPtUtils {
    private static final String TAG = ZmPtUtils.class.getName();

    public static int parseVendorFromUrl(String url) {
        UrlActionInfo urlActionInfo = new UrlActionInfo();
        int switchToVendor = -999;
        boolean success = PTApp.getInstance().parseAppProtocol(urlActionInfo, url, false);
        if (success) {
            if (urlActionInfo.isCnMeeting() && !urlActionInfo.isCurrHostCnMeeting()) {
                switchToVendor = 1;
            } else if (!urlActionInfo.isCnMeeting() && urlActionInfo.isCurrHostCnMeeting()) {
                switchToVendor = 0;
            }
        }
        return switchToVendor;
    }

    public static void switchToVendor(int vendor) {
        if (vendor == 1 || vendor == 0) {
            boolean isSwitchCn;
            PTApp ptApp = PTApp.getInstance();
            boolean bl = isSwitchCn = vendor == 1;
            if (!ptApp.hasActiveCall()) {
                ZoomProductHelper zoomProductHelper;
                if (ptApp.isWebSignedOn()) {
                    ptApp.logout(0, !isSwitchCn);
                }
                if ((zoomProductHelper = ptApp.getZoomProductHelper()) != null) {
                    zoomProductHelper.vendorSwitchTo(vendor);
                    ptApp.setmNeedSwitchVendor(!isSwitchCn);
                }
            }
        }
    }

    public static int getDefaultAudioOption(PTUserProfile profile) {
        int audioOption = 2;
        audioOption = profile.isDisablePSTN() ? 0 : (profile.alwaysUseTelephonyAsDefaultAudio() ? 1 : (profile.alwaysUseBothAsDefaultAudio() ? 2 : (profile.alwaysUse3rdPartyAsDefaultAudio() ? 3 : PreferenceUtil.readIntValue("schedule_opt.audio_option", audioOption))));
        if (audioOption == 3 && !profile.hasSelfTelephony()) {
            audioOption = profile.isDisablePSTN() ? 0 : 2;
        } else if (audioOption == 1 && profile.isDisablePSTN()) {
            audioOption = 0;
        }
        return audioOption;
    }

    public static int getMeetingDefaultAudioOption(PTUserProfile profile, ScheduledMeetingItem meetingForOptions) {
        int audioOption = meetingForOptions.isSelfTelephoneOn() ? (profile.hasSelfTelephony() ? 3 : (profile.isDisablePSTN() ? 0 : 2)) : (meetingForOptions.isTelephonyOff() || profile.isDisablePSTN() ? 0 : (meetingForOptions.isVoipOff() ? 1 : 2));
        return audioOption;
    }

    public static boolean isImageFile(int fileType) {
        return fileType == 1 || fileType == 5 || fileType == 1 || fileType == 4;
    }

    public static boolean isSupportFingerprintAndEnableFingerprintWithUserInfo(ZMActivity context) {
        FingerprintUtil fingerprintUtil;
        if (OsUtil.isAtLeastN() && (fingerprintUtil = new FingerprintUtil(context)).isSupportFingerprint()) {
            MyProfileFragment.FingerprintOption fingerprintOption = MyProfileFragment.FingerprintOption.readFromPreference();
            return fingerprintOption != null && fingerprintOption.isEnableFingerprintWithUserInfo();
        }
        return false;
    }

    public static boolean isSupportFingerprintAndDisableFingerprintWithUserInfo(ZMActivity context) {
        FingerprintUtil fingerprintUtil;
        if (OsUtil.isAtLeastN() && (fingerprintUtil = new FingerprintUtil(context)).isSupportFingerprint()) {
            MyProfileFragment.FingerprintOption fingerprintOption = MyProfileFragment.FingerprintOption.readFromPreference();
            return fingerprintOption != null && fingerprintOption.isDisableFingerprintWithUserInfo();
        }
        return false;
    }

    public static boolean isCalendarServiceReady() {
        PTUserProfile ptUserProfile = PTApp.getInstance().getCurrentUserProfile();
        return ptUserProfile != null && ptUserProfile.isEnableZoomCalendar() && (ptUserProfile.canAccessGoogleCalendar() || ptUserProfile.canAccessOutlookExchange());
    }

    public static boolean isShouldHideAddCalendar() {
        PTUserProfile ptUserProfile = PTApp.getInstance().getCurrentUserProfile();
        return ptUserProfile != null && (!ptUserProfile.isEnableZoomCalendar() || ptUserProfile.canAccessGoogleCalendar() || ptUserProfile.canAccessOutlookExchange());
    }

    private static ScheduledMeetingItem getScheduleItemFromCalEvent(PTAppProtos.GoogCalendarEvent event, String userEmail) {
        boolean success;
        ArrayList<AlterHost> list;
        if (event == null) {
            return null;
        }
        if (event.getMeetNo() == 0L) {
            return null;
        }
        if (StringUtil.isEmptyOrNull((String)event.getStartTime()) || StringUtil.isEmptyOrNull((String)event.getEndTime())) {
            return null;
        }
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        MeetingInfo meetingInfo = null;
        if (meetingHelper != null) {
            meetingInfo = meetingHelper.getMeetingItemByNumber(event.getMeetNo());
        }
        boolean bOwnerIsAssistant = false;
        if (meetingInfo != null && !CollectionsUtil.isListEmpty(list = meetingInfo.getAlterHostList())) {
            for (AlterHost alterHost : list) {
                bOwnerIsAssistant = StringUtil.isSameStringForNotAllowNull((String)event.getCreatorEmail(), (String)alterHost.getEmail());
                if (!bOwnerIsAssistant) continue;
                break;
            }
        }
        boolean isCurrentUserCreate = StringUtil.isSameStringForNotAllowNull((String)userEmail, (String)event.getCreatorEmail());
        boolean bl = success = meetingInfo != null && (isCurrentUserCreate || bOwnerIsAssistant) && meetingInfo.getType() != MeetingInfo.MeetingType.REPEAT;
        if (!success) {
            return ScheduledMeetingItem.fromGoogCalendarEvent(event, bOwnerIsAssistant);
        }
        return null;
    }

    public static List<ScheduledMeetingItem> getMeetingListFromCalEvents(PTAppProtos.GoogCalendarEventList eventList) {
        if (eventList == null || eventList.getGoogCalendarEventCount() == 0) {
            return null;
        }
        PTUserProfile ptUserProfile = PTApp.getInstance().getCurrentUserProfile();
        if (ptUserProfile == null) {
            return null;
        }
        String userEmail = ptUserProfile.getEmail();
        if (StringUtil.isEmptyOrNull((String)userEmail)) {
            return null;
        }
        ArrayList<ScheduledMeetingItem> meetingItems = new ArrayList<ScheduledMeetingItem>();
        int count = eventList.getGoogCalendarEventCount();
        for (int i = 0; i < count; ++i) {
            ScheduledMeetingItem scheduledMeetingItem = ZmPtUtils.getScheduleItemFromCalEvent(eventList.getGoogCalendarEvent(i), userEmail);
            if (scheduledMeetingItem == null) continue;
            meetingItems.add(scheduledMeetingItem);
        }
        return meetingItems;
    }

    public static List<ScheduledMeetingItem> getLatestUpcomingMeetingItems() {
        List<ScheduledMeetingItem> calendarMeetings;
        List<ScheduledMeetingItem> scheduledMeetingItems;
        Long delta;
        long curDelta;
        long within10Minutes = -600000L;
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        if (meetingHelper == null) {
            return null;
        }
        int cnt = meetingHelper.getMeetingCount();
        long preMinDelta = -1L;
        TreeMap sortedMap = new TreeMap();
        TreeMap sortedBeforeMap = new TreeMap();
        long currentTime = System.currentTimeMillis();
        if (cnt > 0) {
            for (int i = 0; i < cnt; ++i) {
                MeetingInfo mi = meetingHelper.getMeetingItemByIndex(i);
                ScheduledMeetingItem item = ScheduledMeetingItem.fromMeetingInfo(mi);
                if (item == null || item.getExtendMeetingType() == 1 || item.isRecurring() && (item.getRepeatType() == 0 || item.getRepeatEndTime() > 0L && item.getRepeatEndTime() - currentTime < -600000L)) continue;
                long startTime = item.getStartTime();
                if (item.isRecurring()) {
                    startTime = ZmPtUtils.getStartTimeBaseCurrentTime(currentTime, item);
                }
                if (!TimeUtil.isSameDate((long)startTime, (long)currentTime)) continue;
                curDelta = startTime - currentTime;
                if (curDelta >= 0L && (preMinDelta == -1L || preMinDelta >= 0L && curDelta <= preMinDelta)) {
                    delta = new Long(curDelta);
                    scheduledMeetingItems = (List)sortedMap.get(curDelta);
                    if (scheduledMeetingItems == null) {
                        scheduledMeetingItems = new ArrayList();
                        sortedMap.put(curDelta, scheduledMeetingItems);
                    }
                    scheduledMeetingItems.add(item);
                    preMinDelta = curDelta;
                    continue;
                }
                if (curDelta >= 0L || curDelta < -600000L) continue;
                delta = new Long(curDelta);
                scheduledMeetingItems = (List)sortedBeforeMap.get(curDelta);
                if (scheduledMeetingItems == null) {
                    scheduledMeetingItems = new ArrayList();
                    sortedBeforeMap.put(curDelta, scheduledMeetingItems);
                }
                scheduledMeetingItems.add(item);
            }
        }
        if (ZmPtUtils.isCalendarServiceReady() && !CollectionsUtil.isListEmpty(calendarMeetings = ZmPtUtils.getMeetingListFromCalEvents(meetingHelper.getCalendarEvents()))) {
            for (ScheduledMeetingItem scheduledMeetingItem : calendarMeetings) {
                if (scheduledMeetingItem == null || !TimeUtil.isSameDate((long)scheduledMeetingItem.getStartTime(), (long)currentTime)) continue;
                curDelta = scheduledMeetingItem.getStartTime() - currentTime;
                if (curDelta >= 0L && (preMinDelta == -1L || preMinDelta >= 0L && curDelta <= preMinDelta)) {
                    delta = new Long(curDelta);
                    scheduledMeetingItems = (ArrayList<ScheduledMeetingItem>)sortedMap.get(curDelta);
                    if (scheduledMeetingItems == null) {
                        scheduledMeetingItems = new ArrayList<ScheduledMeetingItem>();
                        sortedMap.put(curDelta, scheduledMeetingItems);
                    }
                    scheduledMeetingItems.add(scheduledMeetingItem);
                    preMinDelta = curDelta;
                    continue;
                }
                if (curDelta >= 0L || curDelta < -600000L) continue;
                delta = new Long(curDelta);
                scheduledMeetingItems = (List)sortedBeforeMap.get(curDelta);
                if (scheduledMeetingItems == null) {
                    scheduledMeetingItems = new ArrayList();
                    sortedBeforeMap.put(curDelta, scheduledMeetingItems);
                }
                scheduledMeetingItems.add(scheduledMeetingItem);
            }
        }
        ArrayList<ScheduledMeetingItem> results = new ArrayList<ScheduledMeetingItem>();
        if (sortedBeforeMap.size() > 0) {
            results.addAll((Collection)sortedBeforeMap.get(sortedBeforeMap.lastKey()));
        }
        if (sortedMap.size() > 0) {
            if (!CollectionsUtil.isListEmpty(results)) {
                delta = (Long)sortedMap.firstKey();
                if (delta <= 600000L) {
                    results.addAll((Collection)sortedMap.get(sortedMap.firstKey()));
                }
            } else {
                results.addAll((Collection)sortedMap.get(sortedMap.firstKey()));
            }
        }
        return results;
    }

    public static boolean isEnableIM() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        return PTApp.getInstance().hasZoomMessenger() && messenger != null && messenger.imChatGetOption() != 2;
    }

    private static long getStartTimeBaseCurrentTime(long currentTime, @NonNull ScheduledMeetingItem item) {
        long scheduleTime = item.getStartTime();
        int repeatType = item.getRepeatType();
        if (repeatType == 1) {
            return (long)TimeUtil.dateDiff((long)currentTime, (long)scheduleTime) * 86400000L + scheduleTime;
        }
        if (repeatType == 2) {
            int deltaDay = TimeUtil.dateDiff((long)currentTime, (long)scheduleTime);
            if (deltaDay % 7 == 0) {
                return (long)deltaDay * 86400000L + scheduleTime;
            }
            return (long)(7 * (deltaDay / 7 + 1)) * 86400000L + scheduleTime;
        }
        if (repeatType == 3) {
            int deltaDay = TimeUtil.dateDiff((long)currentTime, (long)scheduleTime);
            if (deltaDay % 14 == 0) {
                return (long)deltaDay * 86400000L + scheduleTime;
            }
            return (long)(14 * (deltaDay / 14 + 1)) * 86400000L + scheduleTime;
        }
        if (repeatType == 4) {
            int deltaMonths = TimeUtil.monthsDiff((long)scheduleTime, (long)currentTime);
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(scheduleTime);
            calendar.add(2, deltaMonths);
            return calendar.getTimeInMillis();
        }
        int deltaYears = TimeUtil.yearsDiff((long)scheduleTime, (long)currentTime);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(scheduleTime);
        calendar.add(1, deltaYears);
        return calendar.getTimeInMillis();
    }
}

