/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.URLSpan;
import android.widget.TextView;

public class ZMWebLinkFilter {
    private static String[] mFilter = new String[]{"ftp://", "telnet://", "file://"};

    public static void filter(TextView textView) {
        ZMWebLinkFilter.filter(textView, mFilter);
    }

    public static void filter(TextView textView, String[] filter) {
        if (textView == null || filter == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)textView.getText()) || filter.length <= 0) {
            return;
        }
        CharSequence text = textView.getText();
        if (text instanceof SpannableString) {
            ZMWebLinkFilter.filter((SpannableString)text, filter);
        }
    }

    private static void filter(SpannableString string2, String[] filter) {
        if (TextUtils.isEmpty((CharSequence)string2) || filter == null) {
            return;
        }
        if (filter.length <= 0) {
            return;
        }
        URLSpan[] old = (URLSpan[])string2.getSpans(0, string2.length(), URLSpan.class);
        if (old != null && old.length > 0) {
            for (URLSpan span : old) {
                if (!ZMWebLinkFilter.matchFilter(string2, span, filter)) continue;
                string2.removeSpan((Object)span);
            }
        }
    }

    private static boolean matchFilter(SpannableString string2, URLSpan span, String[] filter) {
        if (TextUtils.isEmpty((CharSequence)string2) || span == null || filter == null || filter.length <= 0) {
            return false;
        }
        int start = string2.getSpanStart((Object)span);
        int end = string2.getSpanEnd((Object)span);
        if (end <= start || start - end > string2.length()) {
            return false;
        }
        for (String ft : filter) {
            String sub;
            if (TextUtils.isEmpty((CharSequence)ft)) continue;
            String matchUrl = string2.subSequence(start, end).toString();
            if (!TextUtils.isEmpty((CharSequence)matchUrl) && matchUrl.length() >= ft.length() && ft.equalsIgnoreCase(matchUrl.substring(0, ft.length()))) {
                return true;
            }
            if (start < ft.length() || TextUtils.isEmpty((CharSequence)(sub = string2.subSequence(start - ft.length(), start).toString())) || !ft.equalsIgnoreCase(sub)) continue;
            return true;
        }
        return false;
    }
}

