/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ZMBaseService;
import us.zoom.androidlib.app.ForegroundTask;
import us.zoom.androidlib.app.ForegroundTaskManager;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.OsUtil;
import us.zoom.androidlib.util.StringUtil;

public class ZMServiceHelper {
    public static void doServiceActionInFront(final String action, final @NonNull Class<? extends ZMBaseService> serviceClass) {
        String name;
        if (!OsUtil.isAtLeastO() || VideoBoxApplication.getInstance() == null || VideoBoxApplication.getInstance().isSDKMode()) {
            ZMServiceHelper.doServiceAction(action, serviceClass);
        }
        if (StringUtil.isEmptyOrNull((String)(name = action))) {
            name = serviceClass.getName();
        }
        ForegroundTask task = new ForegroundTask(name){

            public boolean isValidActivity(String activityClass) {
                return true;
            }

            public boolean isOtherProcessSupported() {
                return false;
            }

            public void run(ZMActivity activity) {
                ZMServiceHelper.doServiceAction(action, serviceClass);
            }
        };
        ForegroundTaskManager.getInstance().runInForeground(task);
    }

    public static void doServiceAction(String action, @NonNull Class<? extends ZMBaseService> serviceClass) {
        VideoBoxApplication context = VideoBoxApplication.getInstance();
        if (context == null) {
            return;
        }
        Intent i = new Intent();
        if (action != null) {
            i.setAction(action);
        }
        i.setClassName(context.getPackageName(), serviceClass.getName());
        CompatUtils.startService((Context)context, (Intent)i, (!context.isAtFront() ? 1 : 0) != 0, (boolean)context.isMultiProcess());
    }
}

