/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Vibrator;
import com.zipow.videobox.view.AudioClip;
import java.util.Timer;
import java.util.TimerTask;

public class ZMNotificationPlayer {
    private static final String TAG = ZMNotificationPlayer.class.getSimpleName();
    private Timer mTimer = null;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private AudioClip mClip = null;
    private Vibrator mVibrator = null;
    private static final long[] VIBRATES = new long[]{2000L, 1000L, 2000L, 1000L};
    private static final int TIMEOUT_VALUE = 60000;
    private static ZMNotificationPlayer mInstance = null;
    private static OnPlayTimeOutListener mListener = null;

    public static void setOnPlayTimeoutListener(OnPlayTimeOutListener listener) {
        mListener = listener;
    }

    private ZMNotificationPlayer() {
    }

    public static synchronized ZMNotificationPlayer getInstance() {
        if (mInstance == null) {
            mInstance = new ZMNotificationPlayer();
        }
        return mInstance;
    }

    public void play(Context context, int rawDataResId, int streamType) {
        this.play(context, rawDataResId, streamType, -1L);
    }

    public void play(Context context, long[] vibrator) {
        this.play(context, vibrator, -1L);
    }

    public void play(Context context, long[] vibrator, long timeout) {
        this.play(context, -1, -1, vibrator, timeout);
    }

    public void play(Context context, int rawDataResId, int streamType, long timeout) {
        this.play(context, rawDataResId, streamType, null, timeout);
    }

    public void play(Context context, int rawDataResId, int streamType, long[] vibrator, long timeout) {
        this.stop();
        if (rawDataResId > 0) {
            this.mClip = new AudioClip(rawDataResId, streamType);
            this.mClip.startPlay();
        }
        if (vibrator != null) {
            this.mVibrator = (Vibrator)context.getSystemService("vibrator");
            if (this.mVibrator != null) {
                this.mVibrator.vibrate(vibrator, 0);
            }
        }
        if (timeout > 0L) {
            this.mTimer = new Timer();
            this.mTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    ZMNotificationPlayer.this.onTimeOut();
                }
            }, timeout);
        }
    }

    private void onTimeOut() {
        this.stop();
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (mListener != null) {
                    mListener.onPlayTimeout();
                }
            }
        });
    }

    public void stop() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
        if (this.mVibrator != null) {
            this.mVibrator.cancel();
            this.mVibrator = null;
        }
        if (this.mClip != null) {
            if (this.mClip.isPlaying()) {
                this.mClip.stopPlay();
            }
            this.mClip = null;
        }
    }

    static interface OnPlayTimeOutListener {
        public void onPlayTimeout();
    }
}

