/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.URLSpan;
import android.widget.TextView;
import com.zipow.videobox.util.LinkSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZMLinkPatterns {
    public static final String GOOD_IRI_CHAR = "a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef";
    public static final Pattern IP_ADDRESS = Pattern.compile("((25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9])\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[0-9]))");
    private static final String IRI = "[a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]([a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef\\-]{0,61}[a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]){0,1}";
    private static final String GOOD_GTLD_CHAR = "a-zA-Z\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef";
    private static final String GTLD = "[a-zA-Z\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]{2,63}";
    private static final String HOST_NAME = "([a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]([a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef\\-]{0,61}[a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]){0,1}\\.)+[a-zA-Z\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]{2,63}";
    public static final Pattern DOMAIN_NAME = Pattern.compile("(([a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]([a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef\\-]{0,61}[a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]){0,1}\\.)+[a-zA-Z\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]{2,63}|" + IP_ADDRESS + ")");
    public static final Pattern WEB_URL = Pattern.compile("((?:(http|https|Http|Https|rtsp|Rtsp):\\/\\/(?:(?:[a-zA-Z0-9\\$\\-\\_\\.\\+\\!\\*\\'\\(\\)\\,\\;\\?\\&\\=]|(?:\\%[a-fA-F0-9]{2})){1,64}(?:\\:(?:[a-zA-Z0-9\\$\\-\\_\\.\\+\\!\\*\\'\\(\\)\\,\\;\\?\\&\\=]|(?:\\%[a-fA-F0-9]{2})){1,25})?\\@)?)?(?:" + DOMAIN_NAME + ")(?:\\:\\d{1,5})?)(\\/(?:(?:[" + "a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef" + "\\;\\/\\?\\:\\@\\&\\=\\#\\~\\-\\.\\+\\!\\*\\'\\(\\)\\,\\_])|(?:\\%[a-fA-F0-9]{2}))*)?(?:\\b|$)");

    public static void hookWebPage(TextView text) {
        if (text == null || TextUtils.isEmpty((CharSequence)text.getText())) {
            return;
        }
        CharSequence t = text.getText();
        if (t instanceof Spannable) {
            if (ZMLinkPatterns.addLinks((Spannable)t)) {
                ZMLinkPatterns.addLinkMovementMethod(text);
            }
        } else {
            SpannableString s = SpannableString.valueOf((CharSequence)t);
            if (ZMLinkPatterns.addLinks((Spannable)s)) {
                ZMLinkPatterns.addLinkMovementMethod(text);
                text.setText((CharSequence)s);
            }
        }
    }

    public static final boolean addLinks(Spannable text) {
        URLSpan[] old = (URLSpan[])text.getSpans(0, text.length(), URLSpan.class);
        for (int i = old.length - 1; i >= 0; --i) {
            text.removeSpan((Object)old[i]);
        }
        ArrayList<LinkSpec> links = new ArrayList<LinkSpec>();
        Matcher m = WEB_URL.matcher((CharSequence)text);
        while (m.find()) {
            String url;
            int start = m.start();
            int end = m.end();
            LinkSpec spec = new LinkSpec();
            spec.url = url = ZMLinkPatterns.makeUrl(m.group(0), new String[]{"http://", "https://", "rtsp://"}, m);
            spec.start = start;
            spec.end = end;
            links.add(spec);
        }
        ZMLinkPatterns.pruneOverlaps(links);
        if (links.size() == 0) {
            return false;
        }
        for (LinkSpec link : links) {
            ZMLinkPatterns.applyLink(link.url, link.start, link.end, text);
        }
        return true;
    }

    private static final String makeUrl(String url, String[] prefixes, Matcher m) {
        boolean hasPrefix = false;
        for (int i = 0; i < prefixes.length; ++i) {
            if (!url.regionMatches(true, 0, prefixes[i], 0, prefixes[i].length())) continue;
            hasPrefix = true;
            if (url.regionMatches(false, 0, prefixes[i], 0, prefixes[i].length())) break;
            url = prefixes[i] + url.substring(prefixes[i].length());
            break;
        }
        if (!hasPrefix) {
            url = prefixes[0] + url;
        }
        return url;
    }

    private static void addLinkMovementMethod(TextView t) {
        MovementMethod m = t.getMovementMethod();
        if ((m == null || !(m instanceof LinkMovementMethod)) && t.getLinksClickable()) {
            t.setMovementMethod(LinkMovementMethod.getInstance());
        }
    }

    private static final void applyLink(String url, int start, int end, Spannable text) {
        URLSpan span = new URLSpan(url);
        text.setSpan((Object)span, start, end, 33);
    }

    private static final void pruneOverlaps(ArrayList<LinkSpec> links) {
        Comparator<LinkSpec> c = new Comparator<LinkSpec>(){

            @Override
            public final int compare(LinkSpec a, LinkSpec b) {
                if (a.start < b.start) {
                    return -1;
                }
                if (a.start > b.start) {
                    return 1;
                }
                if (a.end < b.end) {
                    return 1;
                }
                if (a.end > b.end) {
                    return -1;
                }
                return 0;
            }
        };
        Collections.sort(links, c);
        int len = links.size();
        int i = 0;
        while (i < len - 1) {
            LinkSpec a = links.get(i);
            LinkSpec b = links.get(i + 1);
            int remove = -1;
            if (a.start <= b.start && a.end > b.start) {
                if (b.end <= a.end) {
                    remove = i + 1;
                } else if (a.end - a.start > b.end - b.start) {
                    remove = i + 1;
                } else if (a.end - a.start < b.end - b.start) {
                    remove = i;
                }
                if (remove != -1) {
                    links.remove(remove);
                    --len;
                    continue;
                }
            }
            ++i;
        }
    }
}

