/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.widget.ImageView;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.PTApp;
import java.io.File;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.concurrent.ExecutionException;
import us.zoom.androidlib.proxy.ProxyConfig;
import us.zoom.androidlib.proxy.ProxySettings;
import us.zoom.androidlib.util.AndroidLifecycleUtils;
import us.zoom.videomeetings.R;

public class ZMGlideUtil {
    public static void initAuthenticator() {
        Authenticator authenticator = new Authenticator(){

            @Override
            public PasswordAuthentication getPasswordAuthentication() {
                String[] auths = ZMGlideUtil.getAuthenticator();
                String name = auths[0];
                String psw = auths[1];
                if (TextUtils.isEmpty((CharSequence)name) || TextUtils.isEmpty((CharSequence)psw)) {
                    return null;
                }
                return new PasswordAuthentication(name, psw.toCharArray());
            }
        };
        Authenticator.setDefault(authenticator);
    }

    public static void init() {
        ZMGlideUtil.initAuthenticator();
    }

    private static String[] getAuthenticator() {
        String[] auths = new String[2];
        ProxyConfig[] p = ProxySettings.getHttpProxyConfigs((Context)VideoBoxApplication.getInstance());
        ProxyConfig curP = null;
        for (int i = 0; i < p.length; ++i) {
            if (p[i].getProxyType() == Proxy.Type.DIRECT) continue;
            curP = p[i];
            break;
        }
        if (curP != null) {
            int res;
            String[] uname = new String[1];
            String[] psw = new String[1];
            Proxy.Type proxyType = curP.getProxyType();
            int paramType = 0;
            if (proxyType == Proxy.Type.DIRECT) {
                // empty if block
            }
            if (proxyType == Proxy.Type.HTTP) {
                paramType = 1;
            }
            if ((res = PTApp.getInstance().getAuthInfo(paramType, curP.getHost(), curP.getPort(), uname, psw)) == 1 && uname[0] != null && psw[0] != null) {
                auths[0] = uname[0];
                auths[1] = psw[0];
            }
        }
        return auths;
    }

    public static void load(Context context, @NonNull ImageView iv, Object url, RequestListener listener) {
        ZMGlideUtil.load(context, iv, url, R.drawable.zm_image_placeholder, R.drawable.zm_image_download_error, listener);
    }

    public static void load(Context context, @NonNull ImageView iv, Object url, int holderId, int errorId, RequestListener listener) {
        if (!AndroidLifecycleUtils.canLoadImage((Context)context)) {
            return;
        }
        RequestOptions options = new RequestOptions();
        if (holderId > -1) {
            options.placeholder(holderId);
        }
        if (errorId > -1) {
            options.error(errorId);
        }
        options.fitCenter().dontAnimate().diskCacheStrategy(DiskCacheStrategy.DATA);
    }

    public static void load(Context context, @NonNull ImageView iv, Object url, Drawable holder, Drawable error, RequestListener listener) {
        if (!AndroidLifecycleUtils.canLoadImage((Context)context)) {
            return;
        }
        RequestOptions options = new RequestOptions();
        if (holder != null) {
            options.placeholder(holder);
        }
        if (error != null) {
            options.error(error);
        }
        options.fitCenter().dontAnimate().diskCacheStrategy(DiskCacheStrategy.DATA);
    }

    public static <Y extends Target> void load(Context context, @NonNull Y target, String url, RequestListener listener) {
        ZMGlideUtil.load(context, target, url, R.drawable.zm_image_placeholder, R.drawable.zm_image_download_error, listener);
    }

    public static <Y extends Target> void load(Context context, @NonNull Y target, String url, int holderId, int errorId, RequestListener listener) {
        if (!AndroidLifecycleUtils.canLoadImage((Context)context)) {
            return;
        }
        RequestOptions options = new RequestOptions();
        if (holderId > -1) {
            options.placeholder(holderId);
        }
        if (errorId > -1) {
            options.error(errorId);
        }
        options.fitCenter().dontAnimate().diskCacheStrategy(DiskCacheStrategy.DATA);
    }

    public static <Y extends Target> void loadGif(Context context, @NonNull Y target, String url, RequestListener listener) {
        if (!AndroidLifecycleUtils.canLoadImage((Context)context)) {
            return;
        }
        RequestOptions options = new RequestOptions();
        options.fitCenter().diskCacheStrategy(DiskCacheStrategy.DATA);
    }

    public static File getCachedFile(Context context, String url) throws ExecutionException, InterruptedException {
        if (!AndroidLifecycleUtils.canLoadImage((Context)context)) {
            return null;
        }
        return null;
    }

    public static File getCachedFile(Context context, Object url) throws ExecutionException, InterruptedException {
        if (!AndroidLifecycleUtils.canLoadImage((Context)context)) {
            return null;
        }
        return null;
    }

    public static void clear(Context context, ImageView iv) {
        if (!AndroidLifecycleUtils.canLoadImage((Context)context)) {
            return;
        }
    }

    public static void clear(Context context, Target target) {
        if (!AndroidLifecycleUtils.canLoadImage((Context)context)) {
            return;
        }
    }

    public static RequestManager getGlideRequestManager(@NonNull Context context) {
        return null;
    }

    public static RequestManager getGlideRequestManager(@NonNull Fragment fragment) {
        return null;
    }

    static {
        ZMGlideUtil.init();
    }
}

