/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Environment;
import android.provider.Settings;
import com.zipow.cmmlib.AppContext;
import com.zipow.videobox.IMActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.fragment.NewVersionDialog;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.upgrade.UpgradeMgr;
import com.zipow.videobox.util.ZMWebUtil;
import java.util.Locale;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.CountryCodeUtil;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.ResourcesUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;
import us.zoom.videomeetings.ZMBuildConfig;

public class UpgradeUtil {
    private static final String TAG = UpgradeUtil.class.getSimpleName();

    private static String getWebServer() {
        AppContext appContext;
        String webServer = PTApp.getInstance().getZoomDomain();
        if (StringUtil.isEmptyOrNull((String)webServer) && StringUtil.isEmptyOrNull((String)(webServer = (appContext = new AppContext("config")).queryWithKey("conf.webserver", AppContext.APP_NAME_CHAT)))) {
            webServer = ZMWebUtil.getDefaultWebDomain();
        }
        webServer = webServer.replaceFirst("https", "http");
        return webServer;
    }

    public static void upgrade(ZMActivity activity) {
        if (activity == null) {
            return;
        }
        if (UpgradeUtil.needUpdateLocal((Context)activity)) {
            if (VideoBoxApplication.getInstance().isPTApp()) {
                boolean done = UpgradeMgr.getInstance((Context)activity).installZoomByAPK((Context)activity, UpgradeUtil.getWebServer());
                if (done) {
                    activity.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

                        public void run(IUIElement ui) {
                            UpgradeUtil.showDownloading((ZMActivity)ui);
                        }
                    });
                } else {
                    UIUtil.openURL((Context)activity, (String)UpgradeMgr.getZoomAPKDownloadUrl(UpgradeUtil.getWebServer()));
                }
            } else if (VideoBoxApplication.getInstance().isConfApp()) {
                IMActivity.show((Context)activity, true, IMActivity.ACTION_SHOW_AND_UPGRADE);
            }
        } else {
            UIUtil.openURL((Context)activity, (String)activity.getResources().getString(R.string.zm_url_update, new Object[]{UpgradeUtil.getWebServer()}));
        }
    }

    private static void showDownloading(ZMActivity activity) {
        if (activity == null) {
            return;
        }
        NewVersionDialog.showDownloading(activity, null);
    }

    private static boolean needUpdateLocal(Context context) {
        if (!ResourcesUtil.getBoolean((Context)context, (int)R.bool.zm_config_enable_self_ugrade, (boolean)false)) {
            return false;
        }
        boolean isNonPlayAppAllowed = true;
        try {
            isNonPlayAppAllowed = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"install_non_market_apps") == 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean hasSdcard = false;
        try {
            hasSdcard = Environment.getExternalStorageState().equals("mounted");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ZMBuildConfig.BUILD_TARGET == 0) {
            return isNonPlayAppAllowed && hasSdcard && Locale.CHINA.getCountry().equalsIgnoreCase(CountryCodeUtil.getIsoCountryCode((Context)context));
        }
        return isNonPlayAppAllowed && hasSdcard;
    }
}

