/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.content.Context;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.util.PreferenceUtil;
import us.zoom.androidlib.util.ResourcesUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class UIMgr {
    private static String uiMode = null;
    private static boolean bDriverModeEnabled = true;
    private static boolean bGlobalDriverModeEnabled = true;
    private static boolean bShowWatermarkOnVideo = false;

    public static void initialize(Context context) {
        bShowWatermarkOnVideo = ResourcesUtil.getBoolean((Context)context, (int)R.bool.zm_config_show_water_mark_on_video, (boolean)bShowWatermarkOnVideo);
    }

    public static boolean getShowWatermarkOnVideo() {
        return bShowWatermarkOnVideo;
    }

    public static boolean isLargeMode(Context context) {
        if (context == null) {
            context = VideoBoxApplication.getInstance();
        }
        if (uiMode == null && (uiMode = PreferenceUtil.readStringValue("UIMode", "")) == null) {
            uiMode = "auto";
        }
        if (uiMode.equals("normal")) {
            return false;
        }
        if (uiMode.equals("large")) {
            return true;
        }
        return ResourcesUtil.getBoolean((Context)context, (int)R.bool.zm_is_large_mode, (boolean)false);
    }

    public static boolean isDualPaneSupportedInPortraitMode(Context context) {
        return UIUtil.getDisplayMinWidthInDip((Context)context) >= 750.0f;
    }

    public static void setDriverModeEnabled(boolean enabled) {
        bDriverModeEnabled = enabled;
    }

    public static void setGlobalDriverModeEnabled(boolean enabled) {
        bGlobalDriverModeEnabled = enabled;
    }

    public static boolean isDriverModeEnabled() {
        return bDriverModeEnabled && bGlobalDriverModeEnabled;
    }
}

