/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;

public class TintUtil {
    public static Drawable tintColor(@NonNull Context context, @DrawableRes int drawableId, @ColorRes int colorId) {
        Drawable originalDrawable = ContextCompat.getDrawable((Context)context, (int)drawableId);
        return TintUtil.tintColor(context, originalDrawable, colorId);
    }

    public static Drawable tintColor(@NonNull Context context, @NonNull Drawable originalDrawable, @ColorRes int colorId) {
        int color2 = ContextCompat.getColor((Context)context, (int)colorId);
        return TintUtil.tintColor(originalDrawable, color2);
    }

    public static Drawable tintColor(@NonNull Drawable originalDrawable, @ColorInt int color2) {
        Drawable tintDrawable = DrawableCompat.wrap((Drawable)originalDrawable).mutate();
        DrawableCompat.setTint((Drawable)tintDrawable, (int)color2);
        return tintDrawable;
    }

    public static Drawable tintColorList(@NonNull Context context, @DrawableRes int drawableId, @ColorRes int colorId) {
        Drawable originalDrawable = ContextCompat.getDrawable((Context)context, (int)drawableId);
        return TintUtil.tintColorList(context, originalDrawable, colorId);
    }

    public static Drawable tintColorList(@NonNull Context context, @NonNull Drawable originalDrawable, @ColorRes int colorId) {
        ColorStateList colorStateList = ContextCompat.getColorStateList((Context)context, (int)colorId);
        return TintUtil.tintColorList(originalDrawable, colorStateList);
    }

    public static Drawable tintColorList(@NonNull Drawable originalDrawable, @NonNull ColorStateList colorStateList) {
        Drawable tintDrawable = DrawableCompat.wrap((Drawable)originalDrawable).mutate();
        DrawableCompat.setTintList((Drawable)tintDrawable, (ColorStateList)colorStateList);
        return tintDrawable;
    }
}

