/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;

public class TextDrawable
extends Drawable {
    private int mAlpha = -1;
    private ColorFilter mColorFilter;
    private String mText;
    private Typeface mTypeface;
    private float mTextSize;
    private int mTextColor;
    private TextPaint mTextPaint;
    private StaticLayout mLayout;
    private int mPaddingLeft = 0;
    private int mPaddingTop = 0;
    private int mPaddingRight = 0;
    private int mPaddingBottom = 0;

    public TextDrawable(Context context, String text, Typeface typeface, float textSize, int textColor) {
        if (text == null) {
            text = "";
        }
        this.mText = text;
        this.mTypeface = typeface;
        this.mTextSize = textSize;
        this.mTextColor = textColor;
        this.mTextPaint = new TextPaint();
        if (this.mTypeface != null) {
            this.mTextPaint.setTypeface(this.mTypeface);
        }
        this.mTextPaint.setTextSize(this.mTextSize);
        this.mTextPaint.setColor(this.mTextColor);
        this.mTextPaint.setAlpha(this.mAlpha);
        this.mTextPaint.setAntiAlias(true);
        float desiredWidth = StaticLayout.getDesiredWidth((CharSequence)this.mText, (TextPaint)this.mTextPaint);
        int width = (int)(desiredWidth + 0.5f);
        this.mLayout = new StaticLayout((CharSequence)this.mText, this.mTextPaint, width, Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, false);
    }

    public void setPadding(int left, int top, int right, int bottom) {
        this.mPaddingLeft = left;
        this.mPaddingTop = top;
        this.mPaddingRight = right;
        this.mPaddingBottom = bottom;
    }

    public int getIntrinsicWidth() {
        return this.mLayout.getWidth() + this.mPaddingLeft + this.mPaddingRight;
    }

    public int getIntrinsicHeight() {
        return this.mLayout.getHeight() + this.mPaddingTop + this.mPaddingBottom;
    }

    public void draw(Canvas canvas) {
        if (this.mColorFilter != null) {
            this.mTextPaint.setColorFilter(this.mColorFilter);
        }
        this.mTextPaint.setColor(this.mTextColor);
        this.mTextPaint.setAlpha(this.mAlpha);
        canvas.save();
        canvas.translate((float)this.mPaddingLeft, (float)this.mPaddingTop);
        this.mLayout.draw(canvas);
        canvas.restore();
    }

    public void setAlpha(int alpha) {
        this.mAlpha = alpha;
    }

    public void setColorFilter(ColorFilter cf) {
        this.mColorFilter = cf;
    }

    public int getOpacity() {
        return 0;
    }
}

