/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import com.zipow.videobox.confapp.CmmAudioStatus;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.view.PListItem;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;

public class PListItemComparator
implements Comparator<PListItem> {
    Collator mCollator;
    ConfMgr mConfMgr = ConfMgr.getInstance();
    ConfUI mConfUI;

    public PListItemComparator(Locale locale) {
        this.mCollator = Collator.getInstance(locale);
        this.mCollator.setStrength(0);
        this.mConfUI = ConfUI.getInstance();
    }

    @Override
    public int compare(PListItem lhs, PListItem rhs) {
        boolean raiseHandState2;
        CmmUser user1 = this.mConfMgr.getUserById(lhs.userId);
        CmmUser user2 = this.mConfMgr.getUserById(rhs.userId);
        if (user1 == null && user2 == null) {
            return 0;
        }
        if (user1 == null) {
            return 1;
        }
        if (user2 == null) {
            return -1;
        }
        CmmConfStatus confStatus = this.mConfMgr.getConfStatusObj();
        if (confStatus != null) {
            if (confStatus.isMyself(lhs.userId) && !confStatus.isMyself(rhs.userId)) {
                return -1;
            }
            if (confStatus.isMyself(rhs.userId) && !confStatus.isMyself(lhs.userId)) {
                return 1;
            }
        }
        boolean isHost1 = this.mConfUI.isDisplayAsHost(lhs.userId);
        boolean isHost2 = this.mConfUI.isDisplayAsHost(rhs.userId);
        if (isHost1 && !isHost2) {
            return -1;
        }
        if (isHost2 && !isHost1) {
            return 1;
        }
        if (user1.isSharingPureComputerAudio() && !user2.isSharingPureComputerAudio()) {
            return -1;
        }
        if (user2.isSharingPureComputerAudio() && !user1.isSharingPureComputerAudio()) {
            return 1;
        }
        boolean raiseHandState1 = user1.getRaiseHandState();
        if (raiseHandState1 != (raiseHandState2 = user2.getRaiseHandState())) {
            if (raiseHandState1) {
                return -1;
            }
            return 1;
        }
        if (raiseHandState1) {
            long delta = lhs.getmRaiseHandTimestamp() - rhs.getmRaiseHandTimestamp();
            if (delta > 0L) {
                return 1;
            }
            if (delta < 0L) {
                return -1;
            }
        }
        boolean isCoHost1 = this.mConfUI.isDisplayAsCohost(lhs.userId);
        boolean isCoHost2 = this.mConfUI.isDisplayAsCohost(rhs.userId);
        if (isCoHost1 && !isCoHost2) {
            return -1;
        }
        if (isCoHost2 && !isCoHost1) {
            return 1;
        }
        CmmAudioStatus audioStatus1 = user1.getAudioStatusObj();
        CmmAudioStatus audioStatus2 = user2.getAudioStatusObj();
        if (audioStatus1 == null && audioStatus2 == null) {
            return 0;
        }
        if (audioStatus1 == null) {
            return 1;
        }
        if (audioStatus2 == null) {
            return -1;
        }
        if (audioStatus1.getAudiotype() != 2L && audioStatus2.getAudiotype() == 2L) {
            return -1;
        }
        if (audioStatus1.getAudiotype() == 2L && audioStatus2.getAudiotype() != 2L) {
            return 1;
        }
        if (!audioStatus1.getIsMuted() && audioStatus2.getIsMuted()) {
            return -1;
        }
        if (audioStatus1.getIsMuted() && !audioStatus2.getIsMuted()) {
            return 1;
        }
        return this.mCollator.compare(lhs.screenName, rhs.screenName);
    }
}

